/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details regarding all the supported <code>FieldTypes</code> and their corresponding
 * <code>filterOperators</code> and <code>supportedValues</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SupportedFieldTypeDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<SupportedFieldTypeDetails.Builder, SupportedFieldTypeDetails> {
    private static final SdkField<FieldTypeDetails> V1_FIELD = SdkField.<FieldTypeDetails> builder(MarshallingType.SDK_POJO)
            .memberName("v1").getter(getter(SupportedFieldTypeDetails::v1)).setter(setter(Builder::v1))
            .constructor(FieldTypeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("v1").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(V1_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FieldTypeDetails v1;

    private SupportedFieldTypeDetails(BuilderImpl builder) {
        this.v1 = builder.v1;
    }

    /**
     * <p>
     * The initial supported version for <code>fieldType</code>. If this is later changed to a different version, v2
     * will be introduced.
     * </p>
     * 
     * @return The initial supported version for <code>fieldType</code>. If this is later changed to a different
     *         version, v2 will be introduced.
     */
    public final FieldTypeDetails v1() {
        return v1;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(v1());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupportedFieldTypeDetails)) {
            return false;
        }
        SupportedFieldTypeDetails other = (SupportedFieldTypeDetails) obj;
        return Objects.equals(v1(), other.v1());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SupportedFieldTypeDetails").add("V1", v1()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "v1":
            return Optional.ofNullable(clazz.cast(v1()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("v1", V1_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SupportedFieldTypeDetails, T> g) {
        return obj -> g.apply((SupportedFieldTypeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SupportedFieldTypeDetails> {
        /**
         * <p>
         * The initial supported version for <code>fieldType</code>. If this is later changed to a different version, v2
         * will be introduced.
         * </p>
         * 
         * @param v1
         *        The initial supported version for <code>fieldType</code>. If this is later changed to a different
         *        version, v2 will be introduced.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder v1(FieldTypeDetails v1);

        /**
         * <p>
         * The initial supported version for <code>fieldType</code>. If this is later changed to a different version, v2
         * will be introduced.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldTypeDetails.Builder} avoiding the
         * need to create one manually via {@link FieldTypeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldTypeDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #v1(FieldTypeDetails)}.
         * 
         * @param v1
         *        a consumer that will call methods on {@link FieldTypeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #v1(FieldTypeDetails)
         */
        default Builder v1(Consumer<FieldTypeDetails.Builder> v1) {
            return v1(FieldTypeDetails.builder().applyMutation(v1).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FieldTypeDetails v1;

        private BuilderImpl() {
        }

        private BuilderImpl(SupportedFieldTypeDetails model) {
            v1(model.v1);
        }

        public final FieldTypeDetails.Builder getV1() {
            return v1 != null ? v1.toBuilder() : null;
        }

        public final void setV1(FieldTypeDetails.BuilderImpl v1) {
            this.v1 = v1 != null ? v1.build() : null;
        }

        @Override
        public final Builder v1(FieldTypeDetails v1) {
            this.v1 = v1;
            return this;
        }

        @Override
        public SupportedFieldTypeDetails build() {
            return new SupportedFieldTypeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
