/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties that can be applied to a field when the connector is being used as a source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceFieldProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceFieldProperties.Builder, SourceFieldProperties> {
    private static final SdkField<Boolean> IS_RETRIEVABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isRetrievable").getter(getter(SourceFieldProperties::isRetrievable))
            .setter(setter(Builder::isRetrievable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isRetrievable").build()).build();

    private static final SdkField<Boolean> IS_QUERYABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isQueryable").getter(getter(SourceFieldProperties::isQueryable)).setter(setter(Builder::isQueryable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isQueryable").build()).build();

    private static final SdkField<Boolean> IS_TIMESTAMP_FIELD_FOR_INCREMENTAL_QUERIES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isTimestampFieldForIncrementalQueries")
            .getter(getter(SourceFieldProperties::isTimestampFieldForIncrementalQueries))
            .setter(setter(Builder::isTimestampFieldForIncrementalQueries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("isTimestampFieldForIncrementalQueries").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_RETRIEVABLE_FIELD,
            IS_QUERYABLE_FIELD, IS_TIMESTAMP_FIELD_FOR_INCREMENTAL_QUERIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean isRetrievable;

    private final Boolean isQueryable;

    private final Boolean isTimestampFieldForIncrementalQueries;

    private SourceFieldProperties(BuilderImpl builder) {
        this.isRetrievable = builder.isRetrievable;
        this.isQueryable = builder.isQueryable;
        this.isTimestampFieldForIncrementalQueries = builder.isTimestampFieldForIncrementalQueries;
    }

    /**
     * <p>
     * Indicates whether the field can be returned in a search result.
     * </p>
     * 
     * @return Indicates whether the field can be returned in a search result.
     */
    public final Boolean isRetrievable() {
        return isRetrievable;
    }

    /**
     * <p>
     * Indicates if the field can be queried.
     * </p>
     * 
     * @return Indicates if the field can be queried.
     */
    public final Boolean isQueryable() {
        return isQueryable;
    }

    /**
     * <p>
     * Indicates if this timestamp field can be used for incremental queries.
     * </p>
     * 
     * @return Indicates if this timestamp field can be used for incremental queries.
     */
    public final Boolean isTimestampFieldForIncrementalQueries() {
        return isTimestampFieldForIncrementalQueries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isRetrievable());
        hashCode = 31 * hashCode + Objects.hashCode(isQueryable());
        hashCode = 31 * hashCode + Objects.hashCode(isTimestampFieldForIncrementalQueries());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceFieldProperties)) {
            return false;
        }
        SourceFieldProperties other = (SourceFieldProperties) obj;
        return Objects.equals(isRetrievable(), other.isRetrievable()) && Objects.equals(isQueryable(), other.isQueryable())
                && Objects.equals(isTimestampFieldForIncrementalQueries(), other.isTimestampFieldForIncrementalQueries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceFieldProperties").add("IsRetrievable", isRetrievable()).add("IsQueryable", isQueryable())
                .add("IsTimestampFieldForIncrementalQueries", isTimestampFieldForIncrementalQueries()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isRetrievable":
            return Optional.ofNullable(clazz.cast(isRetrievable()));
        case "isQueryable":
            return Optional.ofNullable(clazz.cast(isQueryable()));
        case "isTimestampFieldForIncrementalQueries":
            return Optional.ofNullable(clazz.cast(isTimestampFieldForIncrementalQueries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("isRetrievable", IS_RETRIEVABLE_FIELD);
        map.put("isQueryable", IS_QUERYABLE_FIELD);
        map.put("isTimestampFieldForIncrementalQueries", IS_TIMESTAMP_FIELD_FOR_INCREMENTAL_QUERIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceFieldProperties, T> g) {
        return obj -> g.apply((SourceFieldProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceFieldProperties> {
        /**
         * <p>
         * Indicates whether the field can be returned in a search result.
         * </p>
         * 
         * @param isRetrievable
         *        Indicates whether the field can be returned in a search result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isRetrievable(Boolean isRetrievable);

        /**
         * <p>
         * Indicates if the field can be queried.
         * </p>
         * 
         * @param isQueryable
         *        Indicates if the field can be queried.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isQueryable(Boolean isQueryable);

        /**
         * <p>
         * Indicates if this timestamp field can be used for incremental queries.
         * </p>
         * 
         * @param isTimestampFieldForIncrementalQueries
         *        Indicates if this timestamp field can be used for incremental queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTimestampFieldForIncrementalQueries(Boolean isTimestampFieldForIncrementalQueries);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isRetrievable;

        private Boolean isQueryable;

        private Boolean isTimestampFieldForIncrementalQueries;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceFieldProperties model) {
            isRetrievable(model.isRetrievable);
            isQueryable(model.isQueryable);
            isTimestampFieldForIncrementalQueries(model.isTimestampFieldForIncrementalQueries);
        }

        public final Boolean getIsRetrievable() {
            return isRetrievable;
        }

        public final void setIsRetrievable(Boolean isRetrievable) {
            this.isRetrievable = isRetrievable;
        }

        @Override
        public final Builder isRetrievable(Boolean isRetrievable) {
            this.isRetrievable = isRetrievable;
            return this;
        }

        public final Boolean getIsQueryable() {
            return isQueryable;
        }

        public final void setIsQueryable(Boolean isQueryable) {
            this.isQueryable = isQueryable;
        }

        @Override
        public final Builder isQueryable(Boolean isQueryable) {
            this.isQueryable = isQueryable;
            return this;
        }

        public final Boolean getIsTimestampFieldForIncrementalQueries() {
            return isTimestampFieldForIncrementalQueries;
        }

        public final void setIsTimestampFieldForIncrementalQueries(Boolean isTimestampFieldForIncrementalQueries) {
            this.isTimestampFieldForIncrementalQueries = isTimestampFieldForIncrementalQueries;
        }

        @Override
        public final Builder isTimestampFieldForIncrementalQueries(Boolean isTimestampFieldForIncrementalQueries) {
            this.isTimestampFieldForIncrementalQueries = isTimestampFieldForIncrementalQueries;
            return this;
        }

        @Override
        public SourceFieldProperties build() {
            return new SourceFieldProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
