/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the private connection provisioning state.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrivateConnectionProvisioningState implements SdkPojo, Serializable,
        ToCopyableBuilder<PrivateConnectionProvisioningState.Builder, PrivateConnectionProvisioningState> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(PrivateConnectionProvisioningState::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureMessage").getter(getter(PrivateConnectionProvisioningState::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()).build();

    private static final SdkField<String> FAILURE_CAUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureCause").getter(getter(PrivateConnectionProvisioningState::failureCauseAsString))
            .setter(setter(Builder::failureCause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCause").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            FAILURE_MESSAGE_FIELD, FAILURE_CAUSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String failureMessage;

    private final String failureCause;

    private PrivateConnectionProvisioningState(BuilderImpl builder) {
        this.status = builder.status;
        this.failureMessage = builder.failureMessage;
        this.failureCause = builder.failureCause;
    }

    /**
     * <p>
     * Specifies the private connection provisioning status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PrivateConnectionProvisioningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies the private connection provisioning status.
     * @see PrivateConnectionProvisioningStatus
     */
    public final PrivateConnectionProvisioningStatus status() {
        return PrivateConnectionProvisioningStatus.fromValue(status);
    }

    /**
     * <p>
     * Specifies the private connection provisioning status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PrivateConnectionProvisioningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies the private connection provisioning status.
     * @see PrivateConnectionProvisioningStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Specifies the private connection provisioning failure reason.
     * </p>
     * 
     * @return Specifies the private connection provisioning failure reason.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    /**
     * <p>
     * Specifies the private connection provisioning failure cause.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCause} will
     * return {@link PrivateConnectionProvisioningFailureCause#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #failureCauseAsString}.
     * </p>
     * 
     * @return Specifies the private connection provisioning failure cause.
     * @see PrivateConnectionProvisioningFailureCause
     */
    public final PrivateConnectionProvisioningFailureCause failureCause() {
        return PrivateConnectionProvisioningFailureCause.fromValue(failureCause);
    }

    /**
     * <p>
     * Specifies the private connection provisioning failure cause.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCause} will
     * return {@link PrivateConnectionProvisioningFailureCause#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #failureCauseAsString}.
     * </p>
     * 
     * @return Specifies the private connection provisioning failure cause.
     * @see PrivateConnectionProvisioningFailureCause
     */
    public final String failureCauseAsString() {
        return failureCause;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(failureCauseAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivateConnectionProvisioningState)) {
            return false;
        }
        PrivateConnectionProvisioningState other = (PrivateConnectionProvisioningState) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failureMessage(), other.failureMessage())
                && Objects.equals(failureCauseAsString(), other.failureCauseAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrivateConnectionProvisioningState").add("Status", statusAsString())
                .add("FailureMessage", failureMessage()).add("FailureCause", failureCauseAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "failureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        case "failureCause":
            return Optional.ofNullable(clazz.cast(failureCauseAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("failureMessage", FAILURE_MESSAGE_FIELD);
        map.put("failureCause", FAILURE_CAUSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrivateConnectionProvisioningState, T> g) {
        return obj -> g.apply((PrivateConnectionProvisioningState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrivateConnectionProvisioningState> {
        /**
         * <p>
         * Specifies the private connection provisioning status.
         * </p>
         * 
         * @param status
         *        Specifies the private connection provisioning status.
         * @see PrivateConnectionProvisioningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrivateConnectionProvisioningStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Specifies the private connection provisioning status.
         * </p>
         * 
         * @param status
         *        Specifies the private connection provisioning status.
         * @see PrivateConnectionProvisioningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrivateConnectionProvisioningStatus
         */
        Builder status(PrivateConnectionProvisioningStatus status);

        /**
         * <p>
         * Specifies the private connection provisioning failure reason.
         * </p>
         * 
         * @param failureMessage
         *        Specifies the private connection provisioning failure reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);

        /**
         * <p>
         * Specifies the private connection provisioning failure cause.
         * </p>
         * 
         * @param failureCause
         *        Specifies the private connection provisioning failure cause.
         * @see PrivateConnectionProvisioningFailureCause
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrivateConnectionProvisioningFailureCause
         */
        Builder failureCause(String failureCause);

        /**
         * <p>
         * Specifies the private connection provisioning failure cause.
         * </p>
         * 
         * @param failureCause
         *        Specifies the private connection provisioning failure cause.
         * @see PrivateConnectionProvisioningFailureCause
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrivateConnectionProvisioningFailureCause
         */
        Builder failureCause(PrivateConnectionProvisioningFailureCause failureCause);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String failureMessage;

        private String failureCause;

        private BuilderImpl() {
        }

        private BuilderImpl(PrivateConnectionProvisioningState model) {
            status(model.status);
            failureMessage(model.failureMessage);
            failureCause(model.failureCause);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PrivateConnectionProvisioningStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final String getFailureCause() {
            return failureCause;
        }

        public final void setFailureCause(String failureCause) {
            this.failureCause = failureCause;
        }

        @Override
        public final Builder failureCause(String failureCause) {
            this.failureCause = failureCause;
            return this;
        }

        @Override
        public final Builder failureCause(PrivateConnectionProvisioningFailureCause failureCause) {
            this.failureCause(failureCause == null ? null : failureCause.toString());
            return this;
        }

        @Override
        public PrivateConnectionProvisioningState build() {
            return new PrivateConnectionProvisioningState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
