/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details regarding the supported field type and the operators that can be applied for filtering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldTypeDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<FieldTypeDetails.Builder, FieldTypeDetails> {
    private static final SdkField<String> FIELD_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fieldType").getter(getter(FieldTypeDetails::fieldType)).setter(setter(Builder::fieldType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldType").build()).build();

    private static final SdkField<List<String>> FILTER_OPERATORS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("filterOperators")
            .getter(getter(FieldTypeDetails::filterOperatorsAsStrings))
            .setter(setter(Builder::filterOperatorsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterOperators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("supportedValues")
            .getter(getter(FieldTypeDetails::supportedValues))
            .setter(setter(Builder::supportedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VALUE_REGEX_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("valueRegexPattern").getter(getter(FieldTypeDetails::valueRegexPattern))
            .setter(setter(Builder::valueRegexPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueRegexPattern").build()).build();

    private static final SdkField<String> SUPPORTED_DATE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("supportedDateFormat").getter(getter(FieldTypeDetails::supportedDateFormat))
            .setter(setter(Builder::supportedDateFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedDateFormat").build())
            .build();

    private static final SdkField<Range> FIELD_VALUE_RANGE_FIELD = SdkField.<Range> builder(MarshallingType.SDK_POJO)
            .memberName("fieldValueRange").getter(getter(FieldTypeDetails::fieldValueRange))
            .setter(setter(Builder::fieldValueRange)).constructor(Range::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldValueRange").build()).build();

    private static final SdkField<Range> FIELD_LENGTH_RANGE_FIELD = SdkField.<Range> builder(MarshallingType.SDK_POJO)
            .memberName("fieldLengthRange").getter(getter(FieldTypeDetails::fieldLengthRange))
            .setter(setter(Builder::fieldLengthRange)).constructor(Range::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldLengthRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_TYPE_FIELD,
            FILTER_OPERATORS_FIELD, SUPPORTED_VALUES_FIELD, VALUE_REGEX_PATTERN_FIELD, SUPPORTED_DATE_FORMAT_FIELD,
            FIELD_VALUE_RANGE_FIELD, FIELD_LENGTH_RANGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fieldType;

    private final List<String> filterOperators;

    private final List<String> supportedValues;

    private final String valueRegexPattern;

    private final String supportedDateFormat;

    private final Range fieldValueRange;

    private final Range fieldLengthRange;

    private FieldTypeDetails(BuilderImpl builder) {
        this.fieldType = builder.fieldType;
        this.filterOperators = builder.filterOperators;
        this.supportedValues = builder.supportedValues;
        this.valueRegexPattern = builder.valueRegexPattern;
        this.supportedDateFormat = builder.supportedDateFormat;
        this.fieldValueRange = builder.fieldValueRange;
        this.fieldLengthRange = builder.fieldLengthRange;
    }

    /**
     * <p>
     * The type of field, such as string, integer, date, and so on.
     * </p>
     * 
     * @return The type of field, such as string, integer, date, and so on.
     */
    public final String fieldType() {
        return fieldType;
    }

    /**
     * <p>
     * The list of operators supported by a field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterOperators} method.
     * </p>
     * 
     * @return The list of operators supported by a field.
     */
    public final List<Operator> filterOperators() {
        return FilterOperatorListCopier.copyStringToEnum(filterOperators);
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterOperators property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFilterOperators() {
        return filterOperators != null && !(filterOperators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of operators supported by a field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterOperators} method.
     * </p>
     * 
     * @return The list of operators supported by a field.
     */
    public final List<String> filterOperatorsAsStrings() {
        return filterOperators;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupportedValues() {
        return supportedValues != null && !(supportedValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of values that a field can contain. For example, a Boolean <code>fieldType</code> can have two values:
     * "true" and "false".
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedValues} method.
     * </p>
     * 
     * @return The list of values that a field can contain. For example, a Boolean <code>fieldType</code> can have two
     *         values: "true" and "false".
     */
    public final List<String> supportedValues() {
        return supportedValues;
    }

    /**
     * <p>
     * The regular expression pattern for the field name.
     * </p>
     * 
     * @return The regular expression pattern for the field name.
     */
    public final String valueRegexPattern() {
        return valueRegexPattern;
    }

    /**
     * <p>
     * The date format that the field supports.
     * </p>
     * 
     * @return The date format that the field supports.
     */
    public final String supportedDateFormat() {
        return supportedDateFormat;
    }

    /**
     * <p>
     * The range of values this field can hold.
     * </p>
     * 
     * @return The range of values this field can hold.
     */
    public final Range fieldValueRange() {
        return fieldValueRange;
    }

    /**
     * <p>
     * This is the allowable length range for this field's value.
     * </p>
     * 
     * @return This is the allowable length range for this field's value.
     */
    public final Range fieldLengthRange() {
        return fieldLengthRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldType());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterOperators() ? filterOperatorsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedValues() ? supportedValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(valueRegexPattern());
        hashCode = 31 * hashCode + Objects.hashCode(supportedDateFormat());
        hashCode = 31 * hashCode + Objects.hashCode(fieldValueRange());
        hashCode = 31 * hashCode + Objects.hashCode(fieldLengthRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldTypeDetails)) {
            return false;
        }
        FieldTypeDetails other = (FieldTypeDetails) obj;
        return Objects.equals(fieldType(), other.fieldType()) && hasFilterOperators() == other.hasFilterOperators()
                && Objects.equals(filterOperatorsAsStrings(), other.filterOperatorsAsStrings())
                && hasSupportedValues() == other.hasSupportedValues()
                && Objects.equals(supportedValues(), other.supportedValues())
                && Objects.equals(valueRegexPattern(), other.valueRegexPattern())
                && Objects.equals(supportedDateFormat(), other.supportedDateFormat())
                && Objects.equals(fieldValueRange(), other.fieldValueRange())
                && Objects.equals(fieldLengthRange(), other.fieldLengthRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldTypeDetails").add("FieldType", fieldType())
                .add("FilterOperators", hasFilterOperators() ? filterOperatorsAsStrings() : null)
                .add("SupportedValues", hasSupportedValues() ? supportedValues() : null)
                .add("ValueRegexPattern", valueRegexPattern()).add("SupportedDateFormat", supportedDateFormat())
                .add("FieldValueRange", fieldValueRange()).add("FieldLengthRange", fieldLengthRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fieldType":
            return Optional.ofNullable(clazz.cast(fieldType()));
        case "filterOperators":
            return Optional.ofNullable(clazz.cast(filterOperatorsAsStrings()));
        case "supportedValues":
            return Optional.ofNullable(clazz.cast(supportedValues()));
        case "valueRegexPattern":
            return Optional.ofNullable(clazz.cast(valueRegexPattern()));
        case "supportedDateFormat":
            return Optional.ofNullable(clazz.cast(supportedDateFormat()));
        case "fieldValueRange":
            return Optional.ofNullable(clazz.cast(fieldValueRange()));
        case "fieldLengthRange":
            return Optional.ofNullable(clazz.cast(fieldLengthRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fieldType", FIELD_TYPE_FIELD);
        map.put("filterOperators", FILTER_OPERATORS_FIELD);
        map.put("supportedValues", SUPPORTED_VALUES_FIELD);
        map.put("valueRegexPattern", VALUE_REGEX_PATTERN_FIELD);
        map.put("supportedDateFormat", SUPPORTED_DATE_FORMAT_FIELD);
        map.put("fieldValueRange", FIELD_VALUE_RANGE_FIELD);
        map.put("fieldLengthRange", FIELD_LENGTH_RANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FieldTypeDetails, T> g) {
        return obj -> g.apply((FieldTypeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldTypeDetails> {
        /**
         * <p>
         * The type of field, such as string, integer, date, and so on.
         * </p>
         * 
         * @param fieldType
         *        The type of field, such as string, integer, date, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldType(String fieldType);

        /**
         * <p>
         * The list of operators supported by a field.
         * </p>
         * 
         * @param filterOperators
         *        The list of operators supported by a field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterOperatorsWithStrings(Collection<String> filterOperators);

        /**
         * <p>
         * The list of operators supported by a field.
         * </p>
         * 
         * @param filterOperators
         *        The list of operators supported by a field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterOperatorsWithStrings(String... filterOperators);

        /**
         * <p>
         * The list of operators supported by a field.
         * </p>
         * 
         * @param filterOperators
         *        The list of operators supported by a field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterOperators(Collection<Operator> filterOperators);

        /**
         * <p>
         * The list of operators supported by a field.
         * </p>
         * 
         * @param filterOperators
         *        The list of operators supported by a field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterOperators(Operator... filterOperators);

        /**
         * <p>
         * The list of values that a field can contain. For example, a Boolean <code>fieldType</code> can have two
         * values: "true" and "false".
         * </p>
         * 
         * @param supportedValues
         *        The list of values that a field can contain. For example, a Boolean <code>fieldType</code> can have
         *        two values: "true" and "false".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedValues(Collection<String> supportedValues);

        /**
         * <p>
         * The list of values that a field can contain. For example, a Boolean <code>fieldType</code> can have two
         * values: "true" and "false".
         * </p>
         * 
         * @param supportedValues
         *        The list of values that a field can contain. For example, a Boolean <code>fieldType</code> can have
         *        two values: "true" and "false".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedValues(String... supportedValues);

        /**
         * <p>
         * The regular expression pattern for the field name.
         * </p>
         * 
         * @param valueRegexPattern
         *        The regular expression pattern for the field name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueRegexPattern(String valueRegexPattern);

        /**
         * <p>
         * The date format that the field supports.
         * </p>
         * 
         * @param supportedDateFormat
         *        The date format that the field supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDateFormat(String supportedDateFormat);

        /**
         * <p>
         * The range of values this field can hold.
         * </p>
         * 
         * @param fieldValueRange
         *        The range of values this field can hold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldValueRange(Range fieldValueRange);

        /**
         * <p>
         * The range of values this field can hold.
         * </p>
         * This is a convenience method that creates an instance of the {@link Range.Builder} avoiding the need to
         * create one manually via {@link Range#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Range.Builder#build()} is called immediately and its result is
         * passed to {@link #fieldValueRange(Range)}.
         * 
         * @param fieldValueRange
         *        a consumer that will call methods on {@link Range.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldValueRange(Range)
         */
        default Builder fieldValueRange(Consumer<Range.Builder> fieldValueRange) {
            return fieldValueRange(Range.builder().applyMutation(fieldValueRange).build());
        }

        /**
         * <p>
         * This is the allowable length range for this field's value.
         * </p>
         * 
         * @param fieldLengthRange
         *        This is the allowable length range for this field's value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldLengthRange(Range fieldLengthRange);

        /**
         * <p>
         * This is the allowable length range for this field's value.
         * </p>
         * This is a convenience method that creates an instance of the {@link Range.Builder} avoiding the need to
         * create one manually via {@link Range#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Range.Builder#build()} is called immediately and its result is
         * passed to {@link #fieldLengthRange(Range)}.
         * 
         * @param fieldLengthRange
         *        a consumer that will call methods on {@link Range.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldLengthRange(Range)
         */
        default Builder fieldLengthRange(Consumer<Range.Builder> fieldLengthRange) {
            return fieldLengthRange(Range.builder().applyMutation(fieldLengthRange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String fieldType;

        private List<String> filterOperators = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedValues = DefaultSdkAutoConstructList.getInstance();

        private String valueRegexPattern;

        private String supportedDateFormat;

        private Range fieldValueRange;

        private Range fieldLengthRange;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldTypeDetails model) {
            fieldType(model.fieldType);
            filterOperatorsWithStrings(model.filterOperators);
            supportedValues(model.supportedValues);
            valueRegexPattern(model.valueRegexPattern);
            supportedDateFormat(model.supportedDateFormat);
            fieldValueRange(model.fieldValueRange);
            fieldLengthRange(model.fieldLengthRange);
        }

        public final String getFieldType() {
            return fieldType;
        }

        public final void setFieldType(String fieldType) {
            this.fieldType = fieldType;
        }

        @Override
        public final Builder fieldType(String fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        public final Collection<String> getFilterOperators() {
            if (filterOperators instanceof SdkAutoConstructList) {
                return null;
            }
            return filterOperators;
        }

        public final void setFilterOperators(Collection<String> filterOperators) {
            this.filterOperators = FilterOperatorListCopier.copy(filterOperators);
        }

        @Override
        public final Builder filterOperatorsWithStrings(Collection<String> filterOperators) {
            this.filterOperators = FilterOperatorListCopier.copy(filterOperators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterOperatorsWithStrings(String... filterOperators) {
            filterOperatorsWithStrings(Arrays.asList(filterOperators));
            return this;
        }

        @Override
        public final Builder filterOperators(Collection<Operator> filterOperators) {
            this.filterOperators = FilterOperatorListCopier.copyEnumToString(filterOperators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterOperators(Operator... filterOperators) {
            filterOperators(Arrays.asList(filterOperators));
            return this;
        }

        public final Collection<String> getSupportedValues() {
            if (supportedValues instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedValues;
        }

        public final void setSupportedValues(Collection<String> supportedValues) {
            this.supportedValues = SupportedValueListCopier.copy(supportedValues);
        }

        @Override
        public final Builder supportedValues(Collection<String> supportedValues) {
            this.supportedValues = SupportedValueListCopier.copy(supportedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedValues(String... supportedValues) {
            supportedValues(Arrays.asList(supportedValues));
            return this;
        }

        public final String getValueRegexPattern() {
            return valueRegexPattern;
        }

        public final void setValueRegexPattern(String valueRegexPattern) {
            this.valueRegexPattern = valueRegexPattern;
        }

        @Override
        public final Builder valueRegexPattern(String valueRegexPattern) {
            this.valueRegexPattern = valueRegexPattern;
            return this;
        }

        public final String getSupportedDateFormat() {
            return supportedDateFormat;
        }

        public final void setSupportedDateFormat(String supportedDateFormat) {
            this.supportedDateFormat = supportedDateFormat;
        }

        @Override
        public final Builder supportedDateFormat(String supportedDateFormat) {
            this.supportedDateFormat = supportedDateFormat;
            return this;
        }

        public final Range.Builder getFieldValueRange() {
            return fieldValueRange != null ? fieldValueRange.toBuilder() : null;
        }

        public final void setFieldValueRange(Range.BuilderImpl fieldValueRange) {
            this.fieldValueRange = fieldValueRange != null ? fieldValueRange.build() : null;
        }

        @Override
        public final Builder fieldValueRange(Range fieldValueRange) {
            this.fieldValueRange = fieldValueRange;
            return this;
        }

        public final Range.Builder getFieldLengthRange() {
            return fieldLengthRange != null ? fieldLengthRange.toBuilder() : null;
        }

        public final void setFieldLengthRange(Range.BuilderImpl fieldLengthRange) {
            this.fieldLengthRange = fieldLengthRange != null ? fieldLengthRange.build() : null;
        }

        @Override
        public final Builder fieldLengthRange(Range fieldLengthRange) {
            this.fieldLengthRange = fieldLengthRange;
            return this;
        }

        @Override
        public FieldTypeDetails build() {
            return new FieldTypeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
