/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the authentication config that the connector supports.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthenticationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthenticationConfig.Builder, AuthenticationConfig> {
    private static final SdkField<Boolean> IS_BASIC_AUTH_SUPPORTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isBasicAuthSupported").getter(getter(AuthenticationConfig::isBasicAuthSupported))
            .setter(setter(Builder::isBasicAuthSupported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isBasicAuthSupported").build())
            .build();

    private static final SdkField<Boolean> IS_API_KEY_AUTH_SUPPORTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isApiKeyAuthSupported").getter(getter(AuthenticationConfig::isApiKeyAuthSupported))
            .setter(setter(Builder::isApiKeyAuthSupported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isApiKeyAuthSupported").build())
            .build();

    private static final SdkField<Boolean> IS_O_AUTH2_SUPPORTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isOAuth2Supported").getter(getter(AuthenticationConfig::isOAuth2Supported))
            .setter(setter(Builder::isOAuth2Supported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isOAuth2Supported").build()).build();

    private static final SdkField<Boolean> IS_CUSTOM_AUTH_SUPPORTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isCustomAuthSupported").getter(getter(AuthenticationConfig::isCustomAuthSupported))
            .setter(setter(Builder::isCustomAuthSupported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isCustomAuthSupported").build())
            .build();

    private static final SdkField<OAuth2Defaults> O_AUTH2_DEFAULTS_FIELD = SdkField
            .<OAuth2Defaults> builder(MarshallingType.SDK_POJO).memberName("oAuth2Defaults")
            .getter(getter(AuthenticationConfig::oAuth2Defaults)).setter(setter(Builder::oAuth2Defaults))
            .constructor(OAuth2Defaults::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuth2Defaults").build()).build();

    private static final SdkField<List<CustomAuthConfig>> CUSTOM_AUTH_CONFIGS_FIELD = SdkField
            .<List<CustomAuthConfig>> builder(MarshallingType.LIST)
            .memberName("customAuthConfigs")
            .getter(getter(AuthenticationConfig::customAuthConfigs))
            .setter(setter(Builder::customAuthConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customAuthConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomAuthConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomAuthConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_BASIC_AUTH_SUPPORTED_FIELD,
            IS_API_KEY_AUTH_SUPPORTED_FIELD, IS_O_AUTH2_SUPPORTED_FIELD, IS_CUSTOM_AUTH_SUPPORTED_FIELD, O_AUTH2_DEFAULTS_FIELD,
            CUSTOM_AUTH_CONFIGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean isBasicAuthSupported;

    private final Boolean isApiKeyAuthSupported;

    private final Boolean isOAuth2Supported;

    private final Boolean isCustomAuthSupported;

    private final OAuth2Defaults oAuth2Defaults;

    private final List<CustomAuthConfig> customAuthConfigs;

    private AuthenticationConfig(BuilderImpl builder) {
        this.isBasicAuthSupported = builder.isBasicAuthSupported;
        this.isApiKeyAuthSupported = builder.isApiKeyAuthSupported;
        this.isOAuth2Supported = builder.isOAuth2Supported;
        this.isCustomAuthSupported = builder.isCustomAuthSupported;
        this.oAuth2Defaults = builder.oAuth2Defaults;
        this.customAuthConfigs = builder.customAuthConfigs;
    }

    /**
     * <p>
     * Indicates whether basic authentication is supported by the connector.
     * </p>
     * 
     * @return Indicates whether basic authentication is supported by the connector.
     */
    public final Boolean isBasicAuthSupported() {
        return isBasicAuthSupported;
    }

    /**
     * <p>
     * Indicates whether API key authentication is supported by the connector
     * </p>
     * 
     * @return Indicates whether API key authentication is supported by the connector
     */
    public final Boolean isApiKeyAuthSupported() {
        return isApiKeyAuthSupported;
    }

    /**
     * <p>
     * Indicates whether OAuth 2.0 authentication is supported by the connector.
     * </p>
     * 
     * @return Indicates whether OAuth 2.0 authentication is supported by the connector.
     */
    public final Boolean isOAuth2Supported() {
        return isOAuth2Supported;
    }

    /**
     * <p>
     * Indicates whether custom authentication is supported by the connector
     * </p>
     * 
     * @return Indicates whether custom authentication is supported by the connector
     */
    public final Boolean isCustomAuthSupported() {
        return isCustomAuthSupported;
    }

    /**
     * <p>
     * Contains the default values required for OAuth 2.0 authentication.
     * </p>
     * 
     * @return Contains the default values required for OAuth 2.0 authentication.
     */
    public final OAuth2Defaults oAuth2Defaults() {
        return oAuth2Defaults;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomAuthConfigs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomAuthConfigs() {
        return customAuthConfigs != null && !(customAuthConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information required for custom authentication.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomAuthConfigs} method.
     * </p>
     * 
     * @return Contains information required for custom authentication.
     */
    public final List<CustomAuthConfig> customAuthConfigs() {
        return customAuthConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isBasicAuthSupported());
        hashCode = 31 * hashCode + Objects.hashCode(isApiKeyAuthSupported());
        hashCode = 31 * hashCode + Objects.hashCode(isOAuth2Supported());
        hashCode = 31 * hashCode + Objects.hashCode(isCustomAuthSupported());
        hashCode = 31 * hashCode + Objects.hashCode(oAuth2Defaults());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomAuthConfigs() ? customAuthConfigs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationConfig)) {
            return false;
        }
        AuthenticationConfig other = (AuthenticationConfig) obj;
        return Objects.equals(isBasicAuthSupported(), other.isBasicAuthSupported())
                && Objects.equals(isApiKeyAuthSupported(), other.isApiKeyAuthSupported())
                && Objects.equals(isOAuth2Supported(), other.isOAuth2Supported())
                && Objects.equals(isCustomAuthSupported(), other.isCustomAuthSupported())
                && Objects.equals(oAuth2Defaults(), other.oAuth2Defaults())
                && hasCustomAuthConfigs() == other.hasCustomAuthConfigs()
                && Objects.equals(customAuthConfigs(), other.customAuthConfigs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthenticationConfig").add("IsBasicAuthSupported", isBasicAuthSupported())
                .add("IsApiKeyAuthSupported", isApiKeyAuthSupported()).add("IsOAuth2Supported", isOAuth2Supported())
                .add("IsCustomAuthSupported", isCustomAuthSupported()).add("OAuth2Defaults", oAuth2Defaults())
                .add("CustomAuthConfigs", hasCustomAuthConfigs() ? customAuthConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isBasicAuthSupported":
            return Optional.ofNullable(clazz.cast(isBasicAuthSupported()));
        case "isApiKeyAuthSupported":
            return Optional.ofNullable(clazz.cast(isApiKeyAuthSupported()));
        case "isOAuth2Supported":
            return Optional.ofNullable(clazz.cast(isOAuth2Supported()));
        case "isCustomAuthSupported":
            return Optional.ofNullable(clazz.cast(isCustomAuthSupported()));
        case "oAuth2Defaults":
            return Optional.ofNullable(clazz.cast(oAuth2Defaults()));
        case "customAuthConfigs":
            return Optional.ofNullable(clazz.cast(customAuthConfigs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("isBasicAuthSupported", IS_BASIC_AUTH_SUPPORTED_FIELD);
        map.put("isApiKeyAuthSupported", IS_API_KEY_AUTH_SUPPORTED_FIELD);
        map.put("isOAuth2Supported", IS_O_AUTH2_SUPPORTED_FIELD);
        map.put("isCustomAuthSupported", IS_CUSTOM_AUTH_SUPPORTED_FIELD);
        map.put("oAuth2Defaults", O_AUTH2_DEFAULTS_FIELD);
        map.put("customAuthConfigs", CUSTOM_AUTH_CONFIGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationConfig, T> g) {
        return obj -> g.apply((AuthenticationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthenticationConfig> {
        /**
         * <p>
         * Indicates whether basic authentication is supported by the connector.
         * </p>
         * 
         * @param isBasicAuthSupported
         *        Indicates whether basic authentication is supported by the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isBasicAuthSupported(Boolean isBasicAuthSupported);

        /**
         * <p>
         * Indicates whether API key authentication is supported by the connector
         * </p>
         * 
         * @param isApiKeyAuthSupported
         *        Indicates whether API key authentication is supported by the connector
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isApiKeyAuthSupported(Boolean isApiKeyAuthSupported);

        /**
         * <p>
         * Indicates whether OAuth 2.0 authentication is supported by the connector.
         * </p>
         * 
         * @param isOAuth2Supported
         *        Indicates whether OAuth 2.0 authentication is supported by the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isOAuth2Supported(Boolean isOAuth2Supported);

        /**
         * <p>
         * Indicates whether custom authentication is supported by the connector
         * </p>
         * 
         * @param isCustomAuthSupported
         *        Indicates whether custom authentication is supported by the connector
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isCustomAuthSupported(Boolean isCustomAuthSupported);

        /**
         * <p>
         * Contains the default values required for OAuth 2.0 authentication.
         * </p>
         * 
         * @param oAuth2Defaults
         *        Contains the default values required for OAuth 2.0 authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuth2Defaults(OAuth2Defaults oAuth2Defaults);

        /**
         * <p>
         * Contains the default values required for OAuth 2.0 authentication.
         * </p>
         * This is a convenience method that creates an instance of the {@link OAuth2Defaults.Builder} avoiding the need
         * to create one manually via {@link OAuth2Defaults#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OAuth2Defaults.Builder#build()} is called immediately and its
         * result is passed to {@link #oAuth2Defaults(OAuth2Defaults)}.
         * 
         * @param oAuth2Defaults
         *        a consumer that will call methods on {@link OAuth2Defaults.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oAuth2Defaults(OAuth2Defaults)
         */
        default Builder oAuth2Defaults(Consumer<OAuth2Defaults.Builder> oAuth2Defaults) {
            return oAuth2Defaults(OAuth2Defaults.builder().applyMutation(oAuth2Defaults).build());
        }

        /**
         * <p>
         * Contains information required for custom authentication.
         * </p>
         * 
         * @param customAuthConfigs
         *        Contains information required for custom authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAuthConfigs(Collection<CustomAuthConfig> customAuthConfigs);

        /**
         * <p>
         * Contains information required for custom authentication.
         * </p>
         * 
         * @param customAuthConfigs
         *        Contains information required for custom authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAuthConfigs(CustomAuthConfig... customAuthConfigs);

        /**
         * <p>
         * Contains information required for custom authentication.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appflow.model.CustomAuthConfig.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.appflow.model.CustomAuthConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appflow.model.CustomAuthConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #customAuthConfigs(List<CustomAuthConfig>)}.
         * 
         * @param customAuthConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appflow.model.CustomAuthConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customAuthConfigs(java.util.Collection<CustomAuthConfig>)
         */
        Builder customAuthConfigs(Consumer<CustomAuthConfig.Builder>... customAuthConfigs);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isBasicAuthSupported;

        private Boolean isApiKeyAuthSupported;

        private Boolean isOAuth2Supported;

        private Boolean isCustomAuthSupported;

        private OAuth2Defaults oAuth2Defaults;

        private List<CustomAuthConfig> customAuthConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationConfig model) {
            isBasicAuthSupported(model.isBasicAuthSupported);
            isApiKeyAuthSupported(model.isApiKeyAuthSupported);
            isOAuth2Supported(model.isOAuth2Supported);
            isCustomAuthSupported(model.isCustomAuthSupported);
            oAuth2Defaults(model.oAuth2Defaults);
            customAuthConfigs(model.customAuthConfigs);
        }

        public final Boolean getIsBasicAuthSupported() {
            return isBasicAuthSupported;
        }

        public final void setIsBasicAuthSupported(Boolean isBasicAuthSupported) {
            this.isBasicAuthSupported = isBasicAuthSupported;
        }

        @Override
        public final Builder isBasicAuthSupported(Boolean isBasicAuthSupported) {
            this.isBasicAuthSupported = isBasicAuthSupported;
            return this;
        }

        public final Boolean getIsApiKeyAuthSupported() {
            return isApiKeyAuthSupported;
        }

        public final void setIsApiKeyAuthSupported(Boolean isApiKeyAuthSupported) {
            this.isApiKeyAuthSupported = isApiKeyAuthSupported;
        }

        @Override
        public final Builder isApiKeyAuthSupported(Boolean isApiKeyAuthSupported) {
            this.isApiKeyAuthSupported = isApiKeyAuthSupported;
            return this;
        }

        public final Boolean getIsOAuth2Supported() {
            return isOAuth2Supported;
        }

        public final void setIsOAuth2Supported(Boolean isOAuth2Supported) {
            this.isOAuth2Supported = isOAuth2Supported;
        }

        @Override
        public final Builder isOAuth2Supported(Boolean isOAuth2Supported) {
            this.isOAuth2Supported = isOAuth2Supported;
            return this;
        }

        public final Boolean getIsCustomAuthSupported() {
            return isCustomAuthSupported;
        }

        public final void setIsCustomAuthSupported(Boolean isCustomAuthSupported) {
            this.isCustomAuthSupported = isCustomAuthSupported;
        }

        @Override
        public final Builder isCustomAuthSupported(Boolean isCustomAuthSupported) {
            this.isCustomAuthSupported = isCustomAuthSupported;
            return this;
        }

        public final OAuth2Defaults.Builder getOAuth2Defaults() {
            return oAuth2Defaults != null ? oAuth2Defaults.toBuilder() : null;
        }

        public final void setOAuth2Defaults(OAuth2Defaults.BuilderImpl oAuth2Defaults) {
            this.oAuth2Defaults = oAuth2Defaults != null ? oAuth2Defaults.build() : null;
        }

        @Override
        public final Builder oAuth2Defaults(OAuth2Defaults oAuth2Defaults) {
            this.oAuth2Defaults = oAuth2Defaults;
            return this;
        }

        public final List<CustomAuthConfig.Builder> getCustomAuthConfigs() {
            List<CustomAuthConfig.Builder> result = CustomAuthConfigListCopier.copyToBuilder(this.customAuthConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomAuthConfigs(Collection<CustomAuthConfig.BuilderImpl> customAuthConfigs) {
            this.customAuthConfigs = CustomAuthConfigListCopier.copyFromBuilder(customAuthConfigs);
        }

        @Override
        public final Builder customAuthConfigs(Collection<CustomAuthConfig> customAuthConfigs) {
            this.customAuthConfigs = CustomAuthConfigListCopier.copy(customAuthConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAuthConfigs(CustomAuthConfig... customAuthConfigs) {
            customAuthConfigs(Arrays.asList(customAuthConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAuthConfigs(Consumer<CustomAuthConfig.Builder>... customAuthConfigs) {
            customAuthConfigs(Stream.of(customAuthConfigs).map(c -> CustomAuthConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AuthenticationConfig build() {
            return new AuthenticationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
