/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connector-specific credentials required when using Amplitude.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AmplitudeConnectorProfileCredentials implements SdkPojo, Serializable,
        ToCopyableBuilder<AmplitudeConnectorProfileCredentials.Builder, AmplitudeConnectorProfileCredentials> {
    private static final SdkField<String> API_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("apiKey")
            .getter(getter(AmplitudeConnectorProfileCredentials::apiKey)).setter(setter(Builder::apiKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKey").build()).build();

    private static final SdkField<String> SECRET_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secretKey").getter(getter(AmplitudeConnectorProfileCredentials::secretKey))
            .setter(setter(Builder::secretKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_KEY_FIELD,
            SECRET_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String apiKey;

    private final String secretKey;

    private AmplitudeConnectorProfileCredentials(BuilderImpl builder) {
        this.apiKey = builder.apiKey;
        this.secretKey = builder.secretKey;
    }

    /**
     * <p>
     * A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API.
     * </p>
     * 
     * @return A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API.
     */
    public final String apiKey() {
        return apiKey;
    }

    /**
     * <p>
     * The Secret Access Key portion of the credentials.
     * </p>
     * 
     * @return The Secret Access Key portion of the credentials.
     */
    public final String secretKey() {
        return secretKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiKey());
        hashCode = 31 * hashCode + Objects.hashCode(secretKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmplitudeConnectorProfileCredentials)) {
            return false;
        }
        AmplitudeConnectorProfileCredentials other = (AmplitudeConnectorProfileCredentials) obj;
        return Objects.equals(apiKey(), other.apiKey()) && Objects.equals(secretKey(), other.secretKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AmplitudeConnectorProfileCredentials")
                .add("ApiKey", apiKey() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SecretKey", secretKey() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiKey":
            return Optional.ofNullable(clazz.cast(apiKey()));
        case "secretKey":
            return Optional.ofNullable(clazz.cast(secretKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("apiKey", API_KEY_FIELD);
        map.put("secretKey", SECRET_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AmplitudeConnectorProfileCredentials, T> g) {
        return obj -> g.apply((AmplitudeConnectorProfileCredentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AmplitudeConnectorProfileCredentials> {
        /**
         * <p>
         * A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API.
         * </p>
         * 
         * @param apiKey
         *        A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your
         *        API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKey(String apiKey);

        /**
         * <p>
         * The Secret Access Key portion of the credentials.
         * </p>
         * 
         * @param secretKey
         *        The Secret Access Key portion of the credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretKey(String secretKey);
    }

    static final class BuilderImpl implements Builder {
        private String apiKey;

        private String secretKey;

        private BuilderImpl() {
        }

        private BuilderImpl(AmplitudeConnectorProfileCredentials model) {
            apiKey(model.apiKey);
            secretKey(model.secretKey);
        }

        public final String getApiKey() {
            return apiKey;
        }

        public final void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        @Override
        public final Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public final String getSecretKey() {
            return secretKey;
        }

        public final void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        @Override
        public final Builder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        @Override
        public AmplitudeConnectorProfileCredentials build() {
            return new AmplitudeConnectorProfileCredentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
