/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.CatalogType;
import software.amazon.awssdk.services.appflow.model.RegistrationOutput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetadataCatalogDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetadataCatalogDetail> {
    private static final SdkField<String> CATALOG_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("catalogType").getter(MetadataCatalogDetail.getter(MetadataCatalogDetail::catalogTypeAsString)).setter(MetadataCatalogDetail.setter(Builder::catalogType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalogType").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableName").getter(MetadataCatalogDetail.getter(MetadataCatalogDetail::tableName)).setter(MetadataCatalogDetail.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()}).build();
    private static final SdkField<RegistrationOutput> TABLE_REGISTRATION_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tableRegistrationOutput").getter(MetadataCatalogDetail.getter(MetadataCatalogDetail::tableRegistrationOutput)).setter(MetadataCatalogDetail.setter(Builder::tableRegistrationOutput)).constructor(RegistrationOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableRegistrationOutput").build()}).build();
    private static final SdkField<RegistrationOutput> PARTITION_REGISTRATION_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("partitionRegistrationOutput").getter(MetadataCatalogDetail.getter(MetadataCatalogDetail::partitionRegistrationOutput)).setter(MetadataCatalogDetail.setter(Builder::partitionRegistrationOutput)).constructor(RegistrationOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partitionRegistrationOutput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_TYPE_FIELD, TABLE_NAME_FIELD, TABLE_REGISTRATION_OUTPUT_FIELD, PARTITION_REGISTRATION_OUTPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetadataCatalogDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String catalogType;
    private final String tableName;
    private final RegistrationOutput tableRegistrationOutput;
    private final RegistrationOutput partitionRegistrationOutput;

    private MetadataCatalogDetail(BuilderImpl builder) {
        this.catalogType = builder.catalogType;
        this.tableName = builder.tableName;
        this.tableRegistrationOutput = builder.tableRegistrationOutput;
        this.partitionRegistrationOutput = builder.partitionRegistrationOutput;
    }

    public final CatalogType catalogType() {
        return CatalogType.fromValue(this.catalogType);
    }

    public final String catalogTypeAsString() {
        return this.catalogType;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final RegistrationOutput tableRegistrationOutput() {
        return this.tableRegistrationOutput;
    }

    public final RegistrationOutput partitionRegistrationOutput() {
        return this.partitionRegistrationOutput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableRegistrationOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionRegistrationOutput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataCatalogDetail)) {
            return false;
        }
        MetadataCatalogDetail other = (MetadataCatalogDetail)obj;
        return Objects.equals(this.catalogTypeAsString(), other.catalogTypeAsString()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.tableRegistrationOutput(), other.tableRegistrationOutput()) && Objects.equals(this.partitionRegistrationOutput(), other.partitionRegistrationOutput());
    }

    public final String toString() {
        return ToString.builder((String)"MetadataCatalogDetail").add("CatalogType", (Object)this.catalogTypeAsString()).add("TableName", (Object)this.tableName()).add("TableRegistrationOutput", (Object)this.tableRegistrationOutput()).add("PartitionRegistrationOutput", (Object)this.partitionRegistrationOutput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "catalogType": {
                return Optional.ofNullable(clazz.cast(this.catalogTypeAsString()));
            }
            case "tableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "tableRegistrationOutput": {
                return Optional.ofNullable(clazz.cast(this.tableRegistrationOutput()));
            }
            case "partitionRegistrationOutput": {
                return Optional.ofNullable(clazz.cast(this.partitionRegistrationOutput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("catalogType", CATALOG_TYPE_FIELD);
        map.put("tableName", TABLE_NAME_FIELD);
        map.put("tableRegistrationOutput", TABLE_REGISTRATION_OUTPUT_FIELD);
        map.put("partitionRegistrationOutput", PARTITION_REGISTRATION_OUTPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetadataCatalogDetail, T> g) {
        return obj -> g.apply((MetadataCatalogDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String catalogType;
        private String tableName;
        private RegistrationOutput tableRegistrationOutput;
        private RegistrationOutput partitionRegistrationOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataCatalogDetail model) {
            this.catalogType(model.catalogType);
            this.tableName(model.tableName);
            this.tableRegistrationOutput(model.tableRegistrationOutput);
            this.partitionRegistrationOutput(model.partitionRegistrationOutput);
        }

        public final String getCatalogType() {
            return this.catalogType;
        }

        public final void setCatalogType(String catalogType) {
            this.catalogType = catalogType;
        }

        @Override
        public final Builder catalogType(String catalogType) {
            this.catalogType = catalogType;
            return this;
        }

        @Override
        public final Builder catalogType(CatalogType catalogType) {
            this.catalogType(catalogType == null ? null : catalogType.toString());
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final RegistrationOutput.Builder getTableRegistrationOutput() {
            return this.tableRegistrationOutput != null ? this.tableRegistrationOutput.toBuilder() : null;
        }

        public final void setTableRegistrationOutput(RegistrationOutput.BuilderImpl tableRegistrationOutput) {
            this.tableRegistrationOutput = tableRegistrationOutput != null ? tableRegistrationOutput.build() : null;
        }

        @Override
        public final Builder tableRegistrationOutput(RegistrationOutput tableRegistrationOutput) {
            this.tableRegistrationOutput = tableRegistrationOutput;
            return this;
        }

        public final RegistrationOutput.Builder getPartitionRegistrationOutput() {
            return this.partitionRegistrationOutput != null ? this.partitionRegistrationOutput.toBuilder() : null;
        }

        public final void setPartitionRegistrationOutput(RegistrationOutput.BuilderImpl partitionRegistrationOutput) {
            this.partitionRegistrationOutput = partitionRegistrationOutput != null ? partitionRegistrationOutput.build() : null;
        }

        @Override
        public final Builder partitionRegistrationOutput(RegistrationOutput partitionRegistrationOutput) {
            this.partitionRegistrationOutput = partitionRegistrationOutput;
            return this;
        }

        public MetadataCatalogDetail build() {
            return new MetadataCatalogDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetadataCatalogDetail> {
        public Builder catalogType(String var1);

        public Builder catalogType(CatalogType var1);

        public Builder tableName(String var1);

        public Builder tableRegistrationOutput(RegistrationOutput var1);

        default public Builder tableRegistrationOutput(Consumer<RegistrationOutput.Builder> tableRegistrationOutput) {
            return this.tableRegistrationOutput((RegistrationOutput)((RegistrationOutput.Builder)RegistrationOutput.builder().applyMutation(tableRegistrationOutput)).build());
        }

        public Builder partitionRegistrationOutput(RegistrationOutput var1);

        default public Builder partitionRegistrationOutput(Consumer<RegistrationOutput.Builder> partitionRegistrationOutput) {
            return this.partitionRegistrationOutput((RegistrationOutput)((RegistrationOutput.Builder)RegistrationOutput.builder().applyMutation(partitionRegistrationOutput)).build());
        }
    }
}

