/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.ExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutionDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecutionDetails> {
    private static final SdkField<String> MOST_RECENT_EXECUTION_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mostRecentExecutionMessage").getter(ExecutionDetails.getter(ExecutionDetails::mostRecentExecutionMessage)).setter(ExecutionDetails.setter(Builder::mostRecentExecutionMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mostRecentExecutionMessage").build()}).build();
    private static final SdkField<Instant> MOST_RECENT_EXECUTION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("mostRecentExecutionTime").getter(ExecutionDetails.getter(ExecutionDetails::mostRecentExecutionTime)).setter(ExecutionDetails.setter(Builder::mostRecentExecutionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mostRecentExecutionTime").build()}).build();
    private static final SdkField<String> MOST_RECENT_EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mostRecentExecutionStatus").getter(ExecutionDetails.getter(ExecutionDetails::mostRecentExecutionStatusAsString)).setter(ExecutionDetails.setter(Builder::mostRecentExecutionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mostRecentExecutionStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MOST_RECENT_EXECUTION_MESSAGE_FIELD, MOST_RECENT_EXECUTION_TIME_FIELD, MOST_RECENT_EXECUTION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExecutionDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String mostRecentExecutionMessage;
    private final Instant mostRecentExecutionTime;
    private final String mostRecentExecutionStatus;

    private ExecutionDetails(BuilderImpl builder) {
        this.mostRecentExecutionMessage = builder.mostRecentExecutionMessage;
        this.mostRecentExecutionTime = builder.mostRecentExecutionTime;
        this.mostRecentExecutionStatus = builder.mostRecentExecutionStatus;
    }

    public final String mostRecentExecutionMessage() {
        return this.mostRecentExecutionMessage;
    }

    public final Instant mostRecentExecutionTime() {
        return this.mostRecentExecutionTime;
    }

    public final ExecutionStatus mostRecentExecutionStatus() {
        return ExecutionStatus.fromValue(this.mostRecentExecutionStatus);
    }

    public final String mostRecentExecutionStatusAsString() {
        return this.mostRecentExecutionStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mostRecentExecutionMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.mostRecentExecutionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.mostRecentExecutionStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionDetails)) {
            return false;
        }
        ExecutionDetails other = (ExecutionDetails)obj;
        return Objects.equals(this.mostRecentExecutionMessage(), other.mostRecentExecutionMessage()) && Objects.equals(this.mostRecentExecutionTime(), other.mostRecentExecutionTime()) && Objects.equals(this.mostRecentExecutionStatusAsString(), other.mostRecentExecutionStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ExecutionDetails").add("MostRecentExecutionMessage", (Object)this.mostRecentExecutionMessage()).add("MostRecentExecutionTime", (Object)this.mostRecentExecutionTime()).add("MostRecentExecutionStatus", (Object)this.mostRecentExecutionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "mostRecentExecutionMessage": {
                return Optional.ofNullable(clazz.cast(this.mostRecentExecutionMessage()));
            }
            case "mostRecentExecutionTime": {
                return Optional.ofNullable(clazz.cast(this.mostRecentExecutionTime()));
            }
            case "mostRecentExecutionStatus": {
                return Optional.ofNullable(clazz.cast(this.mostRecentExecutionStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mostRecentExecutionMessage", MOST_RECENT_EXECUTION_MESSAGE_FIELD);
        map.put("mostRecentExecutionTime", MOST_RECENT_EXECUTION_TIME_FIELD);
        map.put("mostRecentExecutionStatus", MOST_RECENT_EXECUTION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecutionDetails, T> g) {
        return obj -> g.apply((ExecutionDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mostRecentExecutionMessage;
        private Instant mostRecentExecutionTime;
        private String mostRecentExecutionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionDetails model) {
            this.mostRecentExecutionMessage(model.mostRecentExecutionMessage);
            this.mostRecentExecutionTime(model.mostRecentExecutionTime);
            this.mostRecentExecutionStatus(model.mostRecentExecutionStatus);
        }

        public final String getMostRecentExecutionMessage() {
            return this.mostRecentExecutionMessage;
        }

        public final void setMostRecentExecutionMessage(String mostRecentExecutionMessage) {
            this.mostRecentExecutionMessage = mostRecentExecutionMessage;
        }

        @Override
        public final Builder mostRecentExecutionMessage(String mostRecentExecutionMessage) {
            this.mostRecentExecutionMessage = mostRecentExecutionMessage;
            return this;
        }

        public final Instant getMostRecentExecutionTime() {
            return this.mostRecentExecutionTime;
        }

        public final void setMostRecentExecutionTime(Instant mostRecentExecutionTime) {
            this.mostRecentExecutionTime = mostRecentExecutionTime;
        }

        @Override
        public final Builder mostRecentExecutionTime(Instant mostRecentExecutionTime) {
            this.mostRecentExecutionTime = mostRecentExecutionTime;
            return this;
        }

        public final String getMostRecentExecutionStatus() {
            return this.mostRecentExecutionStatus;
        }

        public final void setMostRecentExecutionStatus(String mostRecentExecutionStatus) {
            this.mostRecentExecutionStatus = mostRecentExecutionStatus;
        }

        @Override
        public final Builder mostRecentExecutionStatus(String mostRecentExecutionStatus) {
            this.mostRecentExecutionStatus = mostRecentExecutionStatus;
            return this;
        }

        @Override
        public final Builder mostRecentExecutionStatus(ExecutionStatus mostRecentExecutionStatus) {
            this.mostRecentExecutionStatus(mostRecentExecutionStatus == null ? null : mostRecentExecutionStatus.toString());
            return this;
        }

        public ExecutionDetails build() {
            return new ExecutionDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecutionDetails> {
        public Builder mostRecentExecutionMessage(String var1);

        public Builder mostRecentExecutionTime(Instant var1);

        public Builder mostRecentExecutionStatus(String var1);

        public Builder mostRecentExecutionStatus(ExecutionStatus var1);
    }
}

