/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appflow.model.AuthParameter;
import software.amazon.awssdk.services.appflow.model.AuthParameterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomAuthConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomAuthConfig> {
    private static final SdkField<String> CUSTOM_AUTHENTICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customAuthenticationType").getter(CustomAuthConfig.getter(CustomAuthConfig::customAuthenticationType)).setter(CustomAuthConfig.setter(Builder::customAuthenticationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customAuthenticationType").build()}).build();
    private static final SdkField<List<AuthParameter>> AUTH_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("authParameters").getter(CustomAuthConfig.getter(CustomAuthConfig::authParameters)).setter(CustomAuthConfig.setter(Builder::authParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuthParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_AUTHENTICATION_TYPE_FIELD, AUTH_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomAuthConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String customAuthenticationType;
    private final List<AuthParameter> authParameters;

    private CustomAuthConfig(BuilderImpl builder) {
        this.customAuthenticationType = builder.customAuthenticationType;
        this.authParameters = builder.authParameters;
    }

    public final String customAuthenticationType() {
        return this.customAuthenticationType;
    }

    public final boolean hasAuthParameters() {
        return this.authParameters != null && !(this.authParameters instanceof SdkAutoConstructList);
    }

    public final List<AuthParameter> authParameters() {
        return this.authParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customAuthenticationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthParameters() ? this.authParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomAuthConfig)) {
            return false;
        }
        CustomAuthConfig other = (CustomAuthConfig)obj;
        return Objects.equals(this.customAuthenticationType(), other.customAuthenticationType()) && this.hasAuthParameters() == other.hasAuthParameters() && Objects.equals(this.authParameters(), other.authParameters());
    }

    public final String toString() {
        return ToString.builder((String)"CustomAuthConfig").add("CustomAuthenticationType", (Object)this.customAuthenticationType()).add("AuthParameters", this.hasAuthParameters() ? this.authParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "customAuthenticationType": {
                return Optional.ofNullable(clazz.cast(this.customAuthenticationType()));
            }
            case "authParameters": {
                return Optional.ofNullable(clazz.cast(this.authParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customAuthenticationType", CUSTOM_AUTHENTICATION_TYPE_FIELD);
        map.put("authParameters", AUTH_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomAuthConfig, T> g) {
        return obj -> g.apply((CustomAuthConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String customAuthenticationType;
        private List<AuthParameter> authParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomAuthConfig model) {
            this.customAuthenticationType(model.customAuthenticationType);
            this.authParameters(model.authParameters);
        }

        public final String getCustomAuthenticationType() {
            return this.customAuthenticationType;
        }

        public final void setCustomAuthenticationType(String customAuthenticationType) {
            this.customAuthenticationType = customAuthenticationType;
        }

        @Override
        public final Builder customAuthenticationType(String customAuthenticationType) {
            this.customAuthenticationType = customAuthenticationType;
            return this;
        }

        public final List<AuthParameter.Builder> getAuthParameters() {
            List<AuthParameter.Builder> result = AuthParameterListCopier.copyToBuilder(this.authParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuthParameters(Collection<AuthParameter.BuilderImpl> authParameters) {
            this.authParameters = AuthParameterListCopier.copyFromBuilder(authParameters);
        }

        @Override
        public final Builder authParameters(Collection<AuthParameter> authParameters) {
            this.authParameters = AuthParameterListCopier.copy(authParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authParameters(AuthParameter ... authParameters) {
            this.authParameters(Arrays.asList(authParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authParameters(Consumer<AuthParameter.Builder> ... authParameters) {
            this.authParameters(Stream.of(authParameters).map(c -> (AuthParameter)((AuthParameter.Builder)AuthParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CustomAuthConfig build() {
            return new CustomAuthConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomAuthConfig> {
        public Builder customAuthenticationType(String var1);

        public Builder authParameters(Collection<AuthParameter> var1);

        public Builder authParameters(AuthParameter ... var1);

        public Builder authParameters(Consumer<AuthParameter.Builder> ... var1);
    }
}

