/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.AmplitudeSourceProperties;
import software.amazon.awssdk.services.appflow.model.CustomConnectorSourceProperties;
import software.amazon.awssdk.services.appflow.model.DatadogSourceProperties;
import software.amazon.awssdk.services.appflow.model.DynatraceSourceProperties;
import software.amazon.awssdk.services.appflow.model.GoogleAnalyticsSourceProperties;
import software.amazon.awssdk.services.appflow.model.InforNexusSourceProperties;
import software.amazon.awssdk.services.appflow.model.MarketoSourceProperties;
import software.amazon.awssdk.services.appflow.model.PardotSourceProperties;
import software.amazon.awssdk.services.appflow.model.S3SourceProperties;
import software.amazon.awssdk.services.appflow.model.SAPODataSourceProperties;
import software.amazon.awssdk.services.appflow.model.SalesforceSourceProperties;
import software.amazon.awssdk.services.appflow.model.ServiceNowSourceProperties;
import software.amazon.awssdk.services.appflow.model.SingularSourceProperties;
import software.amazon.awssdk.services.appflow.model.SlackSourceProperties;
import software.amazon.awssdk.services.appflow.model.TrendmicroSourceProperties;
import software.amazon.awssdk.services.appflow.model.VeevaSourceProperties;
import software.amazon.awssdk.services.appflow.model.ZendeskSourceProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceConnectorProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceConnectorProperties> {
    private static final SdkField<AmplitudeSourceProperties> AMPLITUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Amplitude").getter(SourceConnectorProperties.getter(SourceConnectorProperties::amplitude)).setter(SourceConnectorProperties.setter(Builder::amplitude)).constructor(AmplitudeSourceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Amplitude").build()}).build();
    private static final SdkField<DatadogSourceProperties> DATADOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Datadog").getter(SourceConnectorProperties.getter(SourceConnectorProperties::datadog)).setter(SourceConnectorProperties.setter(Builder::datadog)).constructor(DatadogSourceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Datadog").build()}).build();
    private static final SdkField<DynatraceSourceProperties> DYNATRACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Dynatrace").getter(SourceConnectorProperties.getter(SourceConnectorProperties::dynatrace)).setter(SourceConnectorProperties.setter(Builder::dynatrace)).constructor(DynatraceSourceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dynatrace").build()}).build();
    private static final SdkField<GoogleAnalyticsSourceProperties> GOOGLE_ANALYTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GoogleAnalytics").getter(SourceConnectorProperties.getter(SourceConnectorProperties::googleAnalytics)).setter(SourceConnectorProperties.setter(Builder::googleAnalytics)).constructor(GoogleAnalyticsSourceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GoogleAnalytics").build()}).build();
    private static final SdkField<InforNexusSourceProperties> INFOR_NEXUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InforNexus").getter(SourceConnectorProperties.getter(SourceConnectorProperties::inforNexus)).setter(SourceConnectorProperties.setter(Builder::inforNexus)).constructor(InforNexusSourceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InforNexus").build()}).build();
    private static final SdkField<MarketoSourceProperties> MARKETO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Marketo").getter(SourceConnectorProperties.getter(SourceConnectorProperties::marketo)).setter(SourceConnectorProperties.setter(Builder::marketo)).constructor(MarketoSourceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marketo").build()}).build();
    private static final SdkField<S3SourceProperties> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3").getter(SourceConnectorProperties.getter(SourceConnectorProperties::s3)).setter(SourceConnectorProperties.setter(Builder::s3)).constructor(S3SourceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3").build()}).build();
    private static final SdkField<SalesforceSourceProperties> SALESFORCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Salesforce").getter(SourceConnectorProperties.getter(SourceConnectorProperties::salesforce)).setter(SourceConnectorProperties.setter(Builder::salesforce)).constructor(SalesforceSourceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Salesforce").build()}).build();
    private static final SdkField<ServiceNowSourceProperties> SERVICE_NOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceNow").getter(SourceConnectorProperties.getter(SourceConnectorProperties::serviceNow)).setter(SourceConnectorProperties.setter(Builder::serviceNow)).constructor(ServiceNowSourceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNow").build()}).build();
    private static final SdkField<SingularSourceProperties> SINGULAR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Singular").getter(SourceConnectorProperties.getter(SourceConnectorProperties::singular)).setter(SourceConnectorProperties.setter(Builder::singular)).constructor(SingularSourceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Singular").build()}).build();
    private static final SdkField<SlackSourceProperties> SLACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Slack").getter(SourceConnectorProperties.getter(SourceConnectorProperties::slack)).setter(SourceConnectorProperties.setter(Builder::slack)).constructor(SlackSourceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Slack").build()}).build();
    private static final SdkField<TrendmicroSourceProperties> TRENDMICRO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Trendmicro").getter(SourceConnectorProperties.getter(SourceConnectorProperties::trendmicro)).setter(SourceConnectorProperties.setter(Builder::trendmicro)).constructor(TrendmicroSourceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Trendmicro").build()}).build();
    private static final SdkField<VeevaSourceProperties> VEEVA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Veeva").getter(SourceConnectorProperties.getter(SourceConnectorProperties::veeva)).setter(SourceConnectorProperties.setter(Builder::veeva)).constructor(VeevaSourceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Veeva").build()}).build();
    private static final SdkField<ZendeskSourceProperties> ZENDESK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Zendesk").getter(SourceConnectorProperties.getter(SourceConnectorProperties::zendesk)).setter(SourceConnectorProperties.setter(Builder::zendesk)).constructor(ZendeskSourceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Zendesk").build()}).build();
    private static final SdkField<SAPODataSourceProperties> SAPO_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SAPOData").getter(SourceConnectorProperties.getter(SourceConnectorProperties::sapoData)).setter(SourceConnectorProperties.setter(Builder::sapoData)).constructor(SAPODataSourceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAPOData").build()}).build();
    private static final SdkField<CustomConnectorSourceProperties> CUSTOM_CONNECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomConnector").getter(SourceConnectorProperties.getter(SourceConnectorProperties::customConnector)).setter(SourceConnectorProperties.setter(Builder::customConnector)).constructor(CustomConnectorSourceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomConnector").build()}).build();
    private static final SdkField<PardotSourceProperties> PARDOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Pardot").getter(SourceConnectorProperties.getter(SourceConnectorProperties::pardot)).setter(SourceConnectorProperties.setter(Builder::pardot)).constructor(PardotSourceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pardot").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMPLITUDE_FIELD, DATADOG_FIELD, DYNATRACE_FIELD, GOOGLE_ANALYTICS_FIELD, INFOR_NEXUS_FIELD, MARKETO_FIELD, S3_FIELD, SALESFORCE_FIELD, SERVICE_NOW_FIELD, SINGULAR_FIELD, SLACK_FIELD, TRENDMICRO_FIELD, VEEVA_FIELD, ZENDESK_FIELD, SAPO_DATA_FIELD, CUSTOM_CONNECTOR_FIELD, PARDOT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Amplitude", AMPLITUDE_FIELD);
            this.put("Datadog", DATADOG_FIELD);
            this.put("Dynatrace", DYNATRACE_FIELD);
            this.put("GoogleAnalytics", GOOGLE_ANALYTICS_FIELD);
            this.put("InforNexus", INFOR_NEXUS_FIELD);
            this.put("Marketo", MARKETO_FIELD);
            this.put("S3", S3_FIELD);
            this.put("Salesforce", SALESFORCE_FIELD);
            this.put("ServiceNow", SERVICE_NOW_FIELD);
            this.put("Singular", SINGULAR_FIELD);
            this.put("Slack", SLACK_FIELD);
            this.put("Trendmicro", TRENDMICRO_FIELD);
            this.put("Veeva", VEEVA_FIELD);
            this.put("Zendesk", ZENDESK_FIELD);
            this.put("SAPOData", SAPO_DATA_FIELD);
            this.put("CustomConnector", CUSTOM_CONNECTOR_FIELD);
            this.put("Pardot", PARDOT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final AmplitudeSourceProperties amplitude;
    private final DatadogSourceProperties datadog;
    private final DynatraceSourceProperties dynatrace;
    private final GoogleAnalyticsSourceProperties googleAnalytics;
    private final InforNexusSourceProperties inforNexus;
    private final MarketoSourceProperties marketo;
    private final S3SourceProperties s3;
    private final SalesforceSourceProperties salesforce;
    private final ServiceNowSourceProperties serviceNow;
    private final SingularSourceProperties singular;
    private final SlackSourceProperties slack;
    private final TrendmicroSourceProperties trendmicro;
    private final VeevaSourceProperties veeva;
    private final ZendeskSourceProperties zendesk;
    private final SAPODataSourceProperties sapoData;
    private final CustomConnectorSourceProperties customConnector;
    private final PardotSourceProperties pardot;

    private SourceConnectorProperties(BuilderImpl builder) {
        this.amplitude = builder.amplitude;
        this.datadog = builder.datadog;
        this.dynatrace = builder.dynatrace;
        this.googleAnalytics = builder.googleAnalytics;
        this.inforNexus = builder.inforNexus;
        this.marketo = builder.marketo;
        this.s3 = builder.s3;
        this.salesforce = builder.salesforce;
        this.serviceNow = builder.serviceNow;
        this.singular = builder.singular;
        this.slack = builder.slack;
        this.trendmicro = builder.trendmicro;
        this.veeva = builder.veeva;
        this.zendesk = builder.zendesk;
        this.sapoData = builder.sapoData;
        this.customConnector = builder.customConnector;
        this.pardot = builder.pardot;
    }

    public final AmplitudeSourceProperties amplitude() {
        return this.amplitude;
    }

    public final DatadogSourceProperties datadog() {
        return this.datadog;
    }

    public final DynatraceSourceProperties dynatrace() {
        return this.dynatrace;
    }

    public final GoogleAnalyticsSourceProperties googleAnalytics() {
        return this.googleAnalytics;
    }

    public final InforNexusSourceProperties inforNexus() {
        return this.inforNexus;
    }

    public final MarketoSourceProperties marketo() {
        return this.marketo;
    }

    public final S3SourceProperties s3() {
        return this.s3;
    }

    public final SalesforceSourceProperties salesforce() {
        return this.salesforce;
    }

    public final ServiceNowSourceProperties serviceNow() {
        return this.serviceNow;
    }

    public final SingularSourceProperties singular() {
        return this.singular;
    }

    public final SlackSourceProperties slack() {
        return this.slack;
    }

    public final TrendmicroSourceProperties trendmicro() {
        return this.trendmicro;
    }

    public final VeevaSourceProperties veeva() {
        return this.veeva;
    }

    public final ZendeskSourceProperties zendesk() {
        return this.zendesk;
    }

    public final SAPODataSourceProperties sapoData() {
        return this.sapoData;
    }

    public final CustomConnectorSourceProperties customConnector() {
        return this.customConnector;
    }

    public final PardotSourceProperties pardot() {
        return this.pardot;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amplitude());
        hashCode = 31 * hashCode + Objects.hashCode(this.datadog());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynatrace());
        hashCode = 31 * hashCode + Objects.hashCode(this.googleAnalytics());
        hashCode = 31 * hashCode + Objects.hashCode(this.inforNexus());
        hashCode = 31 * hashCode + Objects.hashCode(this.marketo());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        hashCode = 31 * hashCode + Objects.hashCode(this.salesforce());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNow());
        hashCode = 31 * hashCode + Objects.hashCode(this.singular());
        hashCode = 31 * hashCode + Objects.hashCode(this.slack());
        hashCode = 31 * hashCode + Objects.hashCode(this.trendmicro());
        hashCode = 31 * hashCode + Objects.hashCode(this.veeva());
        hashCode = 31 * hashCode + Objects.hashCode(this.zendesk());
        hashCode = 31 * hashCode + Objects.hashCode(this.sapoData());
        hashCode = 31 * hashCode + Objects.hashCode(this.customConnector());
        hashCode = 31 * hashCode + Objects.hashCode(this.pardot());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceConnectorProperties)) {
            return false;
        }
        SourceConnectorProperties other = (SourceConnectorProperties)obj;
        return Objects.equals(this.amplitude(), other.amplitude()) && Objects.equals(this.datadog(), other.datadog()) && Objects.equals(this.dynatrace(), other.dynatrace()) && Objects.equals(this.googleAnalytics(), other.googleAnalytics()) && Objects.equals(this.inforNexus(), other.inforNexus()) && Objects.equals(this.marketo(), other.marketo()) && Objects.equals(this.s3(), other.s3()) && Objects.equals(this.salesforce(), other.salesforce()) && Objects.equals(this.serviceNow(), other.serviceNow()) && Objects.equals(this.singular(), other.singular()) && Objects.equals(this.slack(), other.slack()) && Objects.equals(this.trendmicro(), other.trendmicro()) && Objects.equals(this.veeva(), other.veeva()) && Objects.equals(this.zendesk(), other.zendesk()) && Objects.equals(this.sapoData(), other.sapoData()) && Objects.equals(this.customConnector(), other.customConnector()) && Objects.equals(this.pardot(), other.pardot());
    }

    public final String toString() {
        return ToString.builder((String)"SourceConnectorProperties").add("Amplitude", (Object)this.amplitude()).add("Datadog", (Object)this.datadog()).add("Dynatrace", (Object)this.dynatrace()).add("GoogleAnalytics", (Object)this.googleAnalytics()).add("InforNexus", (Object)this.inforNexus()).add("Marketo", (Object)this.marketo()).add("S3", (Object)this.s3()).add("Salesforce", (Object)this.salesforce()).add("ServiceNow", (Object)this.serviceNow()).add("Singular", (Object)this.singular()).add("Slack", (Object)this.slack()).add("Trendmicro", (Object)this.trendmicro()).add("Veeva", (Object)this.veeva()).add("Zendesk", (Object)this.zendesk()).add("SAPOData", (Object)this.sapoData()).add("CustomConnector", (Object)this.customConnector()).add("Pardot", (Object)this.pardot()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Amplitude": {
                return Optional.ofNullable(clazz.cast(this.amplitude()));
            }
            case "Datadog": {
                return Optional.ofNullable(clazz.cast(this.datadog()));
            }
            case "Dynatrace": {
                return Optional.ofNullable(clazz.cast(this.dynatrace()));
            }
            case "GoogleAnalytics": {
                return Optional.ofNullable(clazz.cast(this.googleAnalytics()));
            }
            case "InforNexus": {
                return Optional.ofNullable(clazz.cast(this.inforNexus()));
            }
            case "Marketo": {
                return Optional.ofNullable(clazz.cast(this.marketo()));
            }
            case "S3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
            case "Salesforce": {
                return Optional.ofNullable(clazz.cast(this.salesforce()));
            }
            case "ServiceNow": {
                return Optional.ofNullable(clazz.cast(this.serviceNow()));
            }
            case "Singular": {
                return Optional.ofNullable(clazz.cast(this.singular()));
            }
            case "Slack": {
                return Optional.ofNullable(clazz.cast(this.slack()));
            }
            case "Trendmicro": {
                return Optional.ofNullable(clazz.cast(this.trendmicro()));
            }
            case "Veeva": {
                return Optional.ofNullable(clazz.cast(this.veeva()));
            }
            case "Zendesk": {
                return Optional.ofNullable(clazz.cast(this.zendesk()));
            }
            case "SAPOData": {
                return Optional.ofNullable(clazz.cast(this.sapoData()));
            }
            case "CustomConnector": {
                return Optional.ofNullable(clazz.cast(this.customConnector()));
            }
            case "Pardot": {
                return Optional.ofNullable(clazz.cast(this.pardot()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SourceConnectorProperties, T> g) {
        return obj -> g.apply((SourceConnectorProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AmplitudeSourceProperties amplitude;
        private DatadogSourceProperties datadog;
        private DynatraceSourceProperties dynatrace;
        private GoogleAnalyticsSourceProperties googleAnalytics;
        private InforNexusSourceProperties inforNexus;
        private MarketoSourceProperties marketo;
        private S3SourceProperties s3;
        private SalesforceSourceProperties salesforce;
        private ServiceNowSourceProperties serviceNow;
        private SingularSourceProperties singular;
        private SlackSourceProperties slack;
        private TrendmicroSourceProperties trendmicro;
        private VeevaSourceProperties veeva;
        private ZendeskSourceProperties zendesk;
        private SAPODataSourceProperties sapoData;
        private CustomConnectorSourceProperties customConnector;
        private PardotSourceProperties pardot;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceConnectorProperties model) {
            this.amplitude(model.amplitude);
            this.datadog(model.datadog);
            this.dynatrace(model.dynatrace);
            this.googleAnalytics(model.googleAnalytics);
            this.inforNexus(model.inforNexus);
            this.marketo(model.marketo);
            this.s3(model.s3);
            this.salesforce(model.salesforce);
            this.serviceNow(model.serviceNow);
            this.singular(model.singular);
            this.slack(model.slack);
            this.trendmicro(model.trendmicro);
            this.veeva(model.veeva);
            this.zendesk(model.zendesk);
            this.sapoData(model.sapoData);
            this.customConnector(model.customConnector);
            this.pardot(model.pardot);
        }

        public final AmplitudeSourceProperties.Builder getAmplitude() {
            return this.amplitude != null ? this.amplitude.toBuilder() : null;
        }

        public final void setAmplitude(AmplitudeSourceProperties.BuilderImpl amplitude) {
            this.amplitude = amplitude != null ? amplitude.build() : null;
        }

        @Override
        public final Builder amplitude(AmplitudeSourceProperties amplitude) {
            this.amplitude = amplitude;
            return this;
        }

        public final DatadogSourceProperties.Builder getDatadog() {
            return this.datadog != null ? this.datadog.toBuilder() : null;
        }

        public final void setDatadog(DatadogSourceProperties.BuilderImpl datadog) {
            this.datadog = datadog != null ? datadog.build() : null;
        }

        @Override
        public final Builder datadog(DatadogSourceProperties datadog) {
            this.datadog = datadog;
            return this;
        }

        public final DynatraceSourceProperties.Builder getDynatrace() {
            return this.dynatrace != null ? this.dynatrace.toBuilder() : null;
        }

        public final void setDynatrace(DynatraceSourceProperties.BuilderImpl dynatrace) {
            this.dynatrace = dynatrace != null ? dynatrace.build() : null;
        }

        @Override
        public final Builder dynatrace(DynatraceSourceProperties dynatrace) {
            this.dynatrace = dynatrace;
            return this;
        }

        public final GoogleAnalyticsSourceProperties.Builder getGoogleAnalytics() {
            return this.googleAnalytics != null ? this.googleAnalytics.toBuilder() : null;
        }

        public final void setGoogleAnalytics(GoogleAnalyticsSourceProperties.BuilderImpl googleAnalytics) {
            this.googleAnalytics = googleAnalytics != null ? googleAnalytics.build() : null;
        }

        @Override
        public final Builder googleAnalytics(GoogleAnalyticsSourceProperties googleAnalytics) {
            this.googleAnalytics = googleAnalytics;
            return this;
        }

        public final InforNexusSourceProperties.Builder getInforNexus() {
            return this.inforNexus != null ? this.inforNexus.toBuilder() : null;
        }

        public final void setInforNexus(InforNexusSourceProperties.BuilderImpl inforNexus) {
            this.inforNexus = inforNexus != null ? inforNexus.build() : null;
        }

        @Override
        public final Builder inforNexus(InforNexusSourceProperties inforNexus) {
            this.inforNexus = inforNexus;
            return this;
        }

        public final MarketoSourceProperties.Builder getMarketo() {
            return this.marketo != null ? this.marketo.toBuilder() : null;
        }

        public final void setMarketo(MarketoSourceProperties.BuilderImpl marketo) {
            this.marketo = marketo != null ? marketo.build() : null;
        }

        @Override
        public final Builder marketo(MarketoSourceProperties marketo) {
            this.marketo = marketo;
            return this;
        }

        public final S3SourceProperties.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        public final void setS3(S3SourceProperties.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        public final Builder s3(S3SourceProperties s3) {
            this.s3 = s3;
            return this;
        }

        public final SalesforceSourceProperties.Builder getSalesforce() {
            return this.salesforce != null ? this.salesforce.toBuilder() : null;
        }

        public final void setSalesforce(SalesforceSourceProperties.BuilderImpl salesforce) {
            this.salesforce = salesforce != null ? salesforce.build() : null;
        }

        @Override
        public final Builder salesforce(SalesforceSourceProperties salesforce) {
            this.salesforce = salesforce;
            return this;
        }

        public final ServiceNowSourceProperties.Builder getServiceNow() {
            return this.serviceNow != null ? this.serviceNow.toBuilder() : null;
        }

        public final void setServiceNow(ServiceNowSourceProperties.BuilderImpl serviceNow) {
            this.serviceNow = serviceNow != null ? serviceNow.build() : null;
        }

        @Override
        public final Builder serviceNow(ServiceNowSourceProperties serviceNow) {
            this.serviceNow = serviceNow;
            return this;
        }

        public final SingularSourceProperties.Builder getSingular() {
            return this.singular != null ? this.singular.toBuilder() : null;
        }

        public final void setSingular(SingularSourceProperties.BuilderImpl singular) {
            this.singular = singular != null ? singular.build() : null;
        }

        @Override
        public final Builder singular(SingularSourceProperties singular) {
            this.singular = singular;
            return this;
        }

        public final SlackSourceProperties.Builder getSlack() {
            return this.slack != null ? this.slack.toBuilder() : null;
        }

        public final void setSlack(SlackSourceProperties.BuilderImpl slack) {
            this.slack = slack != null ? slack.build() : null;
        }

        @Override
        public final Builder slack(SlackSourceProperties slack) {
            this.slack = slack;
            return this;
        }

        public final TrendmicroSourceProperties.Builder getTrendmicro() {
            return this.trendmicro != null ? this.trendmicro.toBuilder() : null;
        }

        public final void setTrendmicro(TrendmicroSourceProperties.BuilderImpl trendmicro) {
            this.trendmicro = trendmicro != null ? trendmicro.build() : null;
        }

        @Override
        public final Builder trendmicro(TrendmicroSourceProperties trendmicro) {
            this.trendmicro = trendmicro;
            return this;
        }

        public final VeevaSourceProperties.Builder getVeeva() {
            return this.veeva != null ? this.veeva.toBuilder() : null;
        }

        public final void setVeeva(VeevaSourceProperties.BuilderImpl veeva) {
            this.veeva = veeva != null ? veeva.build() : null;
        }

        @Override
        public final Builder veeva(VeevaSourceProperties veeva) {
            this.veeva = veeva;
            return this;
        }

        public final ZendeskSourceProperties.Builder getZendesk() {
            return this.zendesk != null ? this.zendesk.toBuilder() : null;
        }

        public final void setZendesk(ZendeskSourceProperties.BuilderImpl zendesk) {
            this.zendesk = zendesk != null ? zendesk.build() : null;
        }

        @Override
        public final Builder zendesk(ZendeskSourceProperties zendesk) {
            this.zendesk = zendesk;
            return this;
        }

        public final SAPODataSourceProperties.Builder getSapoData() {
            return this.sapoData != null ? this.sapoData.toBuilder() : null;
        }

        public final void setSapoData(SAPODataSourceProperties.BuilderImpl sapoData) {
            this.sapoData = sapoData != null ? sapoData.build() : null;
        }

        @Override
        public final Builder sapoData(SAPODataSourceProperties sapoData) {
            this.sapoData = sapoData;
            return this;
        }

        public final CustomConnectorSourceProperties.Builder getCustomConnector() {
            return this.customConnector != null ? this.customConnector.toBuilder() : null;
        }

        public final void setCustomConnector(CustomConnectorSourceProperties.BuilderImpl customConnector) {
            this.customConnector = customConnector != null ? customConnector.build() : null;
        }

        @Override
        public final Builder customConnector(CustomConnectorSourceProperties customConnector) {
            this.customConnector = customConnector;
            return this;
        }

        public final PardotSourceProperties.Builder getPardot() {
            return this.pardot != null ? this.pardot.toBuilder() : null;
        }

        public final void setPardot(PardotSourceProperties.BuilderImpl pardot) {
            this.pardot = pardot != null ? pardot.build() : null;
        }

        @Override
        public final Builder pardot(PardotSourceProperties pardot) {
            this.pardot = pardot;
            return this;
        }

        public SourceConnectorProperties build() {
            return new SourceConnectorProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceConnectorProperties> {
        public Builder amplitude(AmplitudeSourceProperties var1);

        default public Builder amplitude(Consumer<AmplitudeSourceProperties.Builder> amplitude) {
            return this.amplitude((AmplitudeSourceProperties)((AmplitudeSourceProperties.Builder)AmplitudeSourceProperties.builder().applyMutation(amplitude)).build());
        }

        public Builder datadog(DatadogSourceProperties var1);

        default public Builder datadog(Consumer<DatadogSourceProperties.Builder> datadog) {
            return this.datadog((DatadogSourceProperties)((DatadogSourceProperties.Builder)DatadogSourceProperties.builder().applyMutation(datadog)).build());
        }

        public Builder dynatrace(DynatraceSourceProperties var1);

        default public Builder dynatrace(Consumer<DynatraceSourceProperties.Builder> dynatrace) {
            return this.dynatrace((DynatraceSourceProperties)((DynatraceSourceProperties.Builder)DynatraceSourceProperties.builder().applyMutation(dynatrace)).build());
        }

        public Builder googleAnalytics(GoogleAnalyticsSourceProperties var1);

        default public Builder googleAnalytics(Consumer<GoogleAnalyticsSourceProperties.Builder> googleAnalytics) {
            return this.googleAnalytics((GoogleAnalyticsSourceProperties)((GoogleAnalyticsSourceProperties.Builder)GoogleAnalyticsSourceProperties.builder().applyMutation(googleAnalytics)).build());
        }

        public Builder inforNexus(InforNexusSourceProperties var1);

        default public Builder inforNexus(Consumer<InforNexusSourceProperties.Builder> inforNexus) {
            return this.inforNexus((InforNexusSourceProperties)((InforNexusSourceProperties.Builder)InforNexusSourceProperties.builder().applyMutation(inforNexus)).build());
        }

        public Builder marketo(MarketoSourceProperties var1);

        default public Builder marketo(Consumer<MarketoSourceProperties.Builder> marketo) {
            return this.marketo((MarketoSourceProperties)((MarketoSourceProperties.Builder)MarketoSourceProperties.builder().applyMutation(marketo)).build());
        }

        public Builder s3(S3SourceProperties var1);

        default public Builder s3(Consumer<S3SourceProperties.Builder> s3) {
            return this.s3((S3SourceProperties)((S3SourceProperties.Builder)S3SourceProperties.builder().applyMutation(s3)).build());
        }

        public Builder salesforce(SalesforceSourceProperties var1);

        default public Builder salesforce(Consumer<SalesforceSourceProperties.Builder> salesforce) {
            return this.salesforce((SalesforceSourceProperties)((SalesforceSourceProperties.Builder)SalesforceSourceProperties.builder().applyMutation(salesforce)).build());
        }

        public Builder serviceNow(ServiceNowSourceProperties var1);

        default public Builder serviceNow(Consumer<ServiceNowSourceProperties.Builder> serviceNow) {
            return this.serviceNow((ServiceNowSourceProperties)((ServiceNowSourceProperties.Builder)ServiceNowSourceProperties.builder().applyMutation(serviceNow)).build());
        }

        public Builder singular(SingularSourceProperties var1);

        default public Builder singular(Consumer<SingularSourceProperties.Builder> singular) {
            return this.singular((SingularSourceProperties)((SingularSourceProperties.Builder)SingularSourceProperties.builder().applyMutation(singular)).build());
        }

        public Builder slack(SlackSourceProperties var1);

        default public Builder slack(Consumer<SlackSourceProperties.Builder> slack) {
            return this.slack((SlackSourceProperties)((SlackSourceProperties.Builder)SlackSourceProperties.builder().applyMutation(slack)).build());
        }

        public Builder trendmicro(TrendmicroSourceProperties var1);

        default public Builder trendmicro(Consumer<TrendmicroSourceProperties.Builder> trendmicro) {
            return this.trendmicro((TrendmicroSourceProperties)((TrendmicroSourceProperties.Builder)TrendmicroSourceProperties.builder().applyMutation(trendmicro)).build());
        }

        public Builder veeva(VeevaSourceProperties var1);

        default public Builder veeva(Consumer<VeevaSourceProperties.Builder> veeva) {
            return this.veeva((VeevaSourceProperties)((VeevaSourceProperties.Builder)VeevaSourceProperties.builder().applyMutation(veeva)).build());
        }

        public Builder zendesk(ZendeskSourceProperties var1);

        default public Builder zendesk(Consumer<ZendeskSourceProperties.Builder> zendesk) {
            return this.zendesk((ZendeskSourceProperties)((ZendeskSourceProperties.Builder)ZendeskSourceProperties.builder().applyMutation(zendesk)).build());
        }

        public Builder sapoData(SAPODataSourceProperties var1);

        default public Builder sapoData(Consumer<SAPODataSourceProperties.Builder> sapoData) {
            return this.sapoData((SAPODataSourceProperties)((SAPODataSourceProperties.Builder)SAPODataSourceProperties.builder().applyMutation(sapoData)).build());
        }

        public Builder customConnector(CustomConnectorSourceProperties var1);

        default public Builder customConnector(Consumer<CustomConnectorSourceProperties.Builder> customConnector) {
            return this.customConnector((CustomConnectorSourceProperties)((CustomConnectorSourceProperties.Builder)CustomConnectorSourceProperties.builder().applyMutation(customConnector)).build());
        }

        public Builder pardot(PardotSourceProperties var1);

        default public Builder pardot(Consumer<PardotSourceProperties.Builder> pardot) {
            return this.pardot((PardotSourceProperties)((PardotSourceProperties.Builder)PardotSourceProperties.builder().applyMutation(pardot)).build());
        }
    }
}

