/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appflow.model.AppflowRequest;
import software.amazon.awssdk.services.appflow.model.ExecutionIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelFlowExecutionsRequest
extends AppflowRequest
implements ToCopyableBuilder<Builder, CancelFlowExecutionsRequest> {
    private static final SdkField<String> FLOW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowName").getter(CancelFlowExecutionsRequest.getter(CancelFlowExecutionsRequest::flowName)).setter(CancelFlowExecutionsRequest.setter(Builder::flowName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowName").build()}).build();
    private static final SdkField<List<String>> EXECUTION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("executionIds").getter(CancelFlowExecutionsRequest.getter(CancelFlowExecutionsRequest::executionIds)).setter(CancelFlowExecutionsRequest.setter(Builder::executionIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_NAME_FIELD, EXECUTION_IDS_FIELD));
    private final String flowName;
    private final List<String> executionIds;

    private CancelFlowExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.flowName = builder.flowName;
        this.executionIds = builder.executionIds;
    }

    public final String flowName() {
        return this.flowName;
    }

    public final boolean hasExecutionIds() {
        return this.executionIds != null && !(this.executionIds instanceof SdkAutoConstructList);
    }

    public final List<String> executionIds() {
        return this.executionIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flowName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExecutionIds() ? this.executionIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelFlowExecutionsRequest)) {
            return false;
        }
        CancelFlowExecutionsRequest other = (CancelFlowExecutionsRequest)((Object)obj);
        return Objects.equals(this.flowName(), other.flowName()) && this.hasExecutionIds() == other.hasExecutionIds() && Objects.equals(this.executionIds(), other.executionIds());
    }

    public final String toString() {
        return ToString.builder((String)"CancelFlowExecutionsRequest").add("FlowName", (Object)this.flowName()).add("ExecutionIds", this.hasExecutionIds() ? this.executionIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "flowName": {
                return Optional.ofNullable(clazz.cast(this.flowName()));
            }
            case "executionIds": {
                return Optional.ofNullable(clazz.cast(this.executionIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelFlowExecutionsRequest, T> g) {
        return obj -> g.apply((CancelFlowExecutionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppflowRequest.BuilderImpl
    implements Builder {
        private String flowName;
        private List<String> executionIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CancelFlowExecutionsRequest model) {
            super(model);
            this.flowName(model.flowName);
            this.executionIds(model.executionIds);
        }

        public final String getFlowName() {
            return this.flowName;
        }

        public final void setFlowName(String flowName) {
            this.flowName = flowName;
        }

        @Override
        public final Builder flowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        public final Collection<String> getExecutionIds() {
            if (this.executionIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.executionIds;
        }

        public final void setExecutionIds(Collection<String> executionIds) {
            this.executionIds = ExecutionIdsCopier.copy(executionIds);
        }

        @Override
        public final Builder executionIds(Collection<String> executionIds) {
            this.executionIds = ExecutionIdsCopier.copy(executionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionIds(String ... executionIds) {
            this.executionIds(Arrays.asList(executionIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelFlowExecutionsRequest build() {
            return new CancelFlowExecutionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppflowRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelFlowExecutionsRequest> {
        public Builder flowName(String var1);

        public Builder executionIds(Collection<String> var1);

        public Builder executionIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

