/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appflow.model.CustomPropertiesCopier;
import software.amazon.awssdk.services.appflow.model.ErrorHandlingConfig;
import software.amazon.awssdk.services.appflow.model.IdFieldNameListCopier;
import software.amazon.awssdk.services.appflow.model.WriteOperationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomConnectorDestinationProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomConnectorDestinationProperties> {
    private static final SdkField<String> ENTITY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityName").getter(CustomConnectorDestinationProperties.getter(CustomConnectorDestinationProperties::entityName)).setter(CustomConnectorDestinationProperties.setter(Builder::entityName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityName").build()}).build();
    private static final SdkField<ErrorHandlingConfig> ERROR_HANDLING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorHandlingConfig").getter(CustomConnectorDestinationProperties.getter(CustomConnectorDestinationProperties::errorHandlingConfig)).setter(CustomConnectorDestinationProperties.setter(Builder::errorHandlingConfig)).constructor(ErrorHandlingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorHandlingConfig").build()}).build();
    private static final SdkField<String> WRITE_OPERATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("writeOperationType").getter(CustomConnectorDestinationProperties.getter(CustomConnectorDestinationProperties::writeOperationTypeAsString)).setter(CustomConnectorDestinationProperties.setter(Builder::writeOperationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("writeOperationType").build()}).build();
    private static final SdkField<List<String>> ID_FIELD_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("idFieldNames").getter(CustomConnectorDestinationProperties.getter(CustomConnectorDestinationProperties::idFieldNames)).setter(CustomConnectorDestinationProperties.setter(Builder::idFieldNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idFieldNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> CUSTOM_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("customProperties").getter(CustomConnectorDestinationProperties.getter(CustomConnectorDestinationProperties::customProperties)).setter(CustomConnectorDestinationProperties.setter(Builder::customProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_NAME_FIELD, ERROR_HANDLING_CONFIG_FIELD, WRITE_OPERATION_TYPE_FIELD, ID_FIELD_NAMES_FIELD, CUSTOM_PROPERTIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String entityName;
    private final ErrorHandlingConfig errorHandlingConfig;
    private final String writeOperationType;
    private final List<String> idFieldNames;
    private final Map<String, String> customProperties;

    private CustomConnectorDestinationProperties(BuilderImpl builder) {
        this.entityName = builder.entityName;
        this.errorHandlingConfig = builder.errorHandlingConfig;
        this.writeOperationType = builder.writeOperationType;
        this.idFieldNames = builder.idFieldNames;
        this.customProperties = builder.customProperties;
    }

    public final String entityName() {
        return this.entityName;
    }

    public final ErrorHandlingConfig errorHandlingConfig() {
        return this.errorHandlingConfig;
    }

    public final WriteOperationType writeOperationType() {
        return WriteOperationType.fromValue(this.writeOperationType);
    }

    public final String writeOperationTypeAsString() {
        return this.writeOperationType;
    }

    public final boolean hasIdFieldNames() {
        return this.idFieldNames != null && !(this.idFieldNames instanceof SdkAutoConstructList);
    }

    public final List<String> idFieldNames() {
        return this.idFieldNames;
    }

    public final boolean hasCustomProperties() {
        return this.customProperties != null && !(this.customProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> customProperties() {
        return this.customProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entityName());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorHandlingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeOperationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdFieldNames() ? this.idFieldNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomProperties() ? this.customProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomConnectorDestinationProperties)) {
            return false;
        }
        CustomConnectorDestinationProperties other = (CustomConnectorDestinationProperties)obj;
        return Objects.equals(this.entityName(), other.entityName()) && Objects.equals(this.errorHandlingConfig(), other.errorHandlingConfig()) && Objects.equals(this.writeOperationTypeAsString(), other.writeOperationTypeAsString()) && this.hasIdFieldNames() == other.hasIdFieldNames() && Objects.equals(this.idFieldNames(), other.idFieldNames()) && this.hasCustomProperties() == other.hasCustomProperties() && Objects.equals(this.customProperties(), other.customProperties());
    }

    public final String toString() {
        return ToString.builder((String)"CustomConnectorDestinationProperties").add("EntityName", (Object)this.entityName()).add("ErrorHandlingConfig", (Object)this.errorHandlingConfig()).add("WriteOperationType", (Object)this.writeOperationTypeAsString()).add("IdFieldNames", this.hasIdFieldNames() ? this.idFieldNames() : null).add("CustomProperties", this.hasCustomProperties() ? this.customProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entityName": {
                return Optional.ofNullable(clazz.cast(this.entityName()));
            }
            case "errorHandlingConfig": {
                return Optional.ofNullable(clazz.cast(this.errorHandlingConfig()));
            }
            case "writeOperationType": {
                return Optional.ofNullable(clazz.cast(this.writeOperationTypeAsString()));
            }
            case "idFieldNames": {
                return Optional.ofNullable(clazz.cast(this.idFieldNames()));
            }
            case "customProperties": {
                return Optional.ofNullable(clazz.cast(this.customProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomConnectorDestinationProperties, T> g) {
        return obj -> g.apply((CustomConnectorDestinationProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String entityName;
        private ErrorHandlingConfig errorHandlingConfig;
        private String writeOperationType;
        private List<String> idFieldNames = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> customProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomConnectorDestinationProperties model) {
            this.entityName(model.entityName);
            this.errorHandlingConfig(model.errorHandlingConfig);
            this.writeOperationType(model.writeOperationType);
            this.idFieldNames(model.idFieldNames);
            this.customProperties(model.customProperties);
        }

        public final String getEntityName() {
            return this.entityName;
        }

        public final void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public final Builder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public final ErrorHandlingConfig.Builder getErrorHandlingConfig() {
            return this.errorHandlingConfig != null ? this.errorHandlingConfig.toBuilder() : null;
        }

        public final void setErrorHandlingConfig(ErrorHandlingConfig.BuilderImpl errorHandlingConfig) {
            this.errorHandlingConfig = errorHandlingConfig != null ? errorHandlingConfig.build() : null;
        }

        @Override
        public final Builder errorHandlingConfig(ErrorHandlingConfig errorHandlingConfig) {
            this.errorHandlingConfig = errorHandlingConfig;
            return this;
        }

        public final String getWriteOperationType() {
            return this.writeOperationType;
        }

        public final void setWriteOperationType(String writeOperationType) {
            this.writeOperationType = writeOperationType;
        }

        @Override
        public final Builder writeOperationType(String writeOperationType) {
            this.writeOperationType = writeOperationType;
            return this;
        }

        @Override
        public final Builder writeOperationType(WriteOperationType writeOperationType) {
            this.writeOperationType(writeOperationType == null ? null : writeOperationType.toString());
            return this;
        }

        public final Collection<String> getIdFieldNames() {
            if (this.idFieldNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.idFieldNames;
        }

        public final void setIdFieldNames(Collection<String> idFieldNames) {
            this.idFieldNames = IdFieldNameListCopier.copy(idFieldNames);
        }

        @Override
        public final Builder idFieldNames(Collection<String> idFieldNames) {
            this.idFieldNames = IdFieldNameListCopier.copy(idFieldNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder idFieldNames(String ... idFieldNames) {
            this.idFieldNames(Arrays.asList(idFieldNames));
            return this;
        }

        public final Map<String, String> getCustomProperties() {
            if (this.customProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.customProperties;
        }

        public final void setCustomProperties(Map<String, String> customProperties) {
            this.customProperties = CustomPropertiesCopier.copy(customProperties);
        }

        @Override
        public final Builder customProperties(Map<String, String> customProperties) {
            this.customProperties = CustomPropertiesCopier.copy(customProperties);
            return this;
        }

        public CustomConnectorDestinationProperties build() {
            return new CustomConnectorDestinationProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomConnectorDestinationProperties> {
        public Builder entityName(String var1);

        public Builder errorHandlingConfig(ErrorHandlingConfig var1);

        default public Builder errorHandlingConfig(Consumer<ErrorHandlingConfig.Builder> errorHandlingConfig) {
            return this.errorHandlingConfig((ErrorHandlingConfig)((ErrorHandlingConfig.Builder)ErrorHandlingConfig.builder().applyMutation(errorHandlingConfig)).build());
        }

        public Builder writeOperationType(String var1);

        public Builder writeOperationType(WriteOperationType var1);

        public Builder idFieldNames(Collection<String> var1);

        public Builder idFieldNames(String ... var1);

        public Builder customProperties(Map<String, String> var1);
    }
}

