/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appflow.model.AppflowResponse;
import software.amazon.awssdk.services.appflow.model.DestinationFlowConfig;
import software.amazon.awssdk.services.appflow.model.DestinationFlowConfigListCopier;
import software.amazon.awssdk.services.appflow.model.ExecutionDetails;
import software.amazon.awssdk.services.appflow.model.FlowStatus;
import software.amazon.awssdk.services.appflow.model.SourceFlowConfig;
import software.amazon.awssdk.services.appflow.model.TagMapCopier;
import software.amazon.awssdk.services.appflow.model.Task;
import software.amazon.awssdk.services.appflow.model.TasksCopier;
import software.amazon.awssdk.services.appflow.model.TriggerConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFlowResponse
extends AppflowResponse
implements ToCopyableBuilder<Builder, DescribeFlowResponse> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowArn").getter(DescribeFlowResponse.getter(DescribeFlowResponse::flowArn)).setter(DescribeFlowResponse.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(DescribeFlowResponse.getter(DescribeFlowResponse::description)).setter(DescribeFlowResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> FLOW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowName").getter(DescribeFlowResponse.getter(DescribeFlowResponse::flowName)).setter(DescribeFlowResponse.setter(Builder::flowName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowName").build()}).build();
    private static final SdkField<String> KMS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsArn").getter(DescribeFlowResponse.getter(DescribeFlowResponse::kmsArn)).setter(DescribeFlowResponse.setter(Builder::kmsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsArn").build()}).build();
    private static final SdkField<String> FLOW_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowStatus").getter(DescribeFlowResponse.getter(DescribeFlowResponse::flowStatusAsString)).setter(DescribeFlowResponse.setter(Builder::flowStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowStatus").build()}).build();
    private static final SdkField<String> FLOW_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowStatusMessage").getter(DescribeFlowResponse.getter(DescribeFlowResponse::flowStatusMessage)).setter(DescribeFlowResponse.setter(Builder::flowStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowStatusMessage").build()}).build();
    private static final SdkField<SourceFlowConfig> SOURCE_FLOW_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceFlowConfig").getter(DescribeFlowResponse.getter(DescribeFlowResponse::sourceFlowConfig)).setter(DescribeFlowResponse.setter(Builder::sourceFlowConfig)).constructor(SourceFlowConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFlowConfig").build()}).build();
    private static final SdkField<List<DestinationFlowConfig>> DESTINATION_FLOW_CONFIG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("destinationFlowConfigList").getter(DescribeFlowResponse.getter(DescribeFlowResponse::destinationFlowConfigList)).setter(DescribeFlowResponse.setter(Builder::destinationFlowConfigList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationFlowConfigList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DestinationFlowConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ExecutionDetails> LAST_RUN_EXECUTION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lastRunExecutionDetails").getter(DescribeFlowResponse.getter(DescribeFlowResponse::lastRunExecutionDetails)).setter(DescribeFlowResponse.setter(Builder::lastRunExecutionDetails)).constructor(ExecutionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRunExecutionDetails").build()}).build();
    private static final SdkField<TriggerConfig> TRIGGER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("triggerConfig").getter(DescribeFlowResponse.getter(DescribeFlowResponse::triggerConfig)).setter(DescribeFlowResponse.setter(Builder::triggerConfig)).constructor(TriggerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerConfig").build()}).build();
    private static final SdkField<List<Task>> TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tasks").getter(DescribeFlowResponse.getter(DescribeFlowResponse::tasks)).setter(DescribeFlowResponse.setter(Builder::tasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tasks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Task::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(DescribeFlowResponse.getter(DescribeFlowResponse::createdAt)).setter(DescribeFlowResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(DescribeFlowResponse.getter(DescribeFlowResponse::lastUpdatedAt)).setter(DescribeFlowResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(DescribeFlowResponse.getter(DescribeFlowResponse::createdBy)).setter(DescribeFlowResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastUpdatedBy").getter(DescribeFlowResponse.getter(DescribeFlowResponse::lastUpdatedBy)).setter(DescribeFlowResponse.setter(Builder::lastUpdatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedBy").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(DescribeFlowResponse.getter(DescribeFlowResponse::tags)).setter(DescribeFlowResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD, DESCRIPTION_FIELD, FLOW_NAME_FIELD, KMS_ARN_FIELD, FLOW_STATUS_FIELD, FLOW_STATUS_MESSAGE_FIELD, SOURCE_FLOW_CONFIG_FIELD, DESTINATION_FLOW_CONFIG_LIST_FIELD, LAST_RUN_EXECUTION_DETAILS_FIELD, TRIGGER_CONFIG_FIELD, TASKS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, CREATED_BY_FIELD, LAST_UPDATED_BY_FIELD, TAGS_FIELD));
    private final String flowArn;
    private final String description;
    private final String flowName;
    private final String kmsArn;
    private final String flowStatus;
    private final String flowStatusMessage;
    private final SourceFlowConfig sourceFlowConfig;
    private final List<DestinationFlowConfig> destinationFlowConfigList;
    private final ExecutionDetails lastRunExecutionDetails;
    private final TriggerConfig triggerConfig;
    private final List<Task> tasks;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final String createdBy;
    private final String lastUpdatedBy;
    private final Map<String, String> tags;

    private DescribeFlowResponse(BuilderImpl builder) {
        super(builder);
        this.flowArn = builder.flowArn;
        this.description = builder.description;
        this.flowName = builder.flowName;
        this.kmsArn = builder.kmsArn;
        this.flowStatus = builder.flowStatus;
        this.flowStatusMessage = builder.flowStatusMessage;
        this.sourceFlowConfig = builder.sourceFlowConfig;
        this.destinationFlowConfigList = builder.destinationFlowConfigList;
        this.lastRunExecutionDetails = builder.lastRunExecutionDetails;
        this.triggerConfig = builder.triggerConfig;
        this.tasks = builder.tasks;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.createdBy = builder.createdBy;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.tags = builder.tags;
    }

    public final String flowArn() {
        return this.flowArn;
    }

    public final String description() {
        return this.description;
    }

    public final String flowName() {
        return this.flowName;
    }

    public final String kmsArn() {
        return this.kmsArn;
    }

    public final FlowStatus flowStatus() {
        return FlowStatus.fromValue(this.flowStatus);
    }

    public final String flowStatusAsString() {
        return this.flowStatus;
    }

    public final String flowStatusMessage() {
        return this.flowStatusMessage;
    }

    public final SourceFlowConfig sourceFlowConfig() {
        return this.sourceFlowConfig;
    }

    public final boolean hasDestinationFlowConfigList() {
        return this.destinationFlowConfigList != null && !(this.destinationFlowConfigList instanceof SdkAutoConstructList);
    }

    public final List<DestinationFlowConfig> destinationFlowConfigList() {
        return this.destinationFlowConfigList;
    }

    public final ExecutionDetails lastRunExecutionDetails() {
        return this.lastRunExecutionDetails;
    }

    public final TriggerConfig triggerConfig() {
        return this.triggerConfig;
    }

    public final boolean hasTasks() {
        return this.tasks != null && !(this.tasks instanceof SdkAutoConstructList);
    }

    public final List<Task> tasks() {
        return this.tasks;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String lastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowName());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFlowConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationFlowConfigList() ? this.destinationFlowConfigList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRunExecutionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTasks() ? this.tasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFlowResponse)) {
            return false;
        }
        DescribeFlowResponse other = (DescribeFlowResponse)((Object)obj);
        return Objects.equals(this.flowArn(), other.flowArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.flowName(), other.flowName()) && Objects.equals(this.kmsArn(), other.kmsArn()) && Objects.equals(this.flowStatusAsString(), other.flowStatusAsString()) && Objects.equals(this.flowStatusMessage(), other.flowStatusMessage()) && Objects.equals(this.sourceFlowConfig(), other.sourceFlowConfig()) && this.hasDestinationFlowConfigList() == other.hasDestinationFlowConfigList() && Objects.equals(this.destinationFlowConfigList(), other.destinationFlowConfigList()) && Objects.equals(this.lastRunExecutionDetails(), other.lastRunExecutionDetails()) && Objects.equals(this.triggerConfig(), other.triggerConfig()) && this.hasTasks() == other.hasTasks() && Objects.equals(this.tasks(), other.tasks()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.lastUpdatedBy(), other.lastUpdatedBy()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFlowResponse").add("FlowArn", (Object)this.flowArn()).add("Description", (Object)this.description()).add("FlowName", (Object)this.flowName()).add("KmsArn", (Object)this.kmsArn()).add("FlowStatus", (Object)this.flowStatusAsString()).add("FlowStatusMessage", (Object)this.flowStatusMessage()).add("SourceFlowConfig", (Object)this.sourceFlowConfig()).add("DestinationFlowConfigList", this.hasDestinationFlowConfigList() ? this.destinationFlowConfigList() : null).add("LastRunExecutionDetails", (Object)this.lastRunExecutionDetails()).add("TriggerConfig", (Object)this.triggerConfig()).add("Tasks", this.hasTasks() ? this.tasks() : null).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("CreatedBy", (Object)this.createdBy()).add("LastUpdatedBy", (Object)this.lastUpdatedBy()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "flowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "flowName": {
                return Optional.ofNullable(clazz.cast(this.flowName()));
            }
            case "kmsArn": {
                return Optional.ofNullable(clazz.cast(this.kmsArn()));
            }
            case "flowStatus": {
                return Optional.ofNullable(clazz.cast(this.flowStatusAsString()));
            }
            case "flowStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.flowStatusMessage()));
            }
            case "sourceFlowConfig": {
                return Optional.ofNullable(clazz.cast(this.sourceFlowConfig()));
            }
            case "destinationFlowConfigList": {
                return Optional.ofNullable(clazz.cast(this.destinationFlowConfigList()));
            }
            case "lastRunExecutionDetails": {
                return Optional.ofNullable(clazz.cast(this.lastRunExecutionDetails()));
            }
            case "triggerConfig": {
                return Optional.ofNullable(clazz.cast(this.triggerConfig()));
            }
            case "tasks": {
                return Optional.ofNullable(clazz.cast(this.tasks()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "lastUpdatedBy": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedBy()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFlowResponse, T> g) {
        return obj -> g.apply((DescribeFlowResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppflowResponse.BuilderImpl
    implements Builder {
        private String flowArn;
        private String description;
        private String flowName;
        private String kmsArn;
        private String flowStatus;
        private String flowStatusMessage;
        private SourceFlowConfig sourceFlowConfig;
        private List<DestinationFlowConfig> destinationFlowConfigList = DefaultSdkAutoConstructList.getInstance();
        private ExecutionDetails lastRunExecutionDetails;
        private TriggerConfig triggerConfig;
        private List<Task> tasks = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private String createdBy;
        private String lastUpdatedBy;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFlowResponse model) {
            super(model);
            this.flowArn(model.flowArn);
            this.description(model.description);
            this.flowName(model.flowName);
            this.kmsArn(model.kmsArn);
            this.flowStatus(model.flowStatus);
            this.flowStatusMessage(model.flowStatusMessage);
            this.sourceFlowConfig(model.sourceFlowConfig);
            this.destinationFlowConfigList(model.destinationFlowConfigList);
            this.lastRunExecutionDetails(model.lastRunExecutionDetails);
            this.triggerConfig(model.triggerConfig);
            this.tasks(model.tasks);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.createdBy(model.createdBy);
            this.lastUpdatedBy(model.lastUpdatedBy);
            this.tags(model.tags);
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFlowName() {
            return this.flowName;
        }

        public final void setFlowName(String flowName) {
            this.flowName = flowName;
        }

        @Override
        public final Builder flowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        public final String getKmsArn() {
            return this.kmsArn;
        }

        public final void setKmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
        }

        @Override
        public final Builder kmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
            return this;
        }

        public final String getFlowStatus() {
            return this.flowStatus;
        }

        public final void setFlowStatus(String flowStatus) {
            this.flowStatus = flowStatus;
        }

        @Override
        public final Builder flowStatus(String flowStatus) {
            this.flowStatus = flowStatus;
            return this;
        }

        @Override
        public final Builder flowStatus(FlowStatus flowStatus) {
            this.flowStatus(flowStatus == null ? null : flowStatus.toString());
            return this;
        }

        public final String getFlowStatusMessage() {
            return this.flowStatusMessage;
        }

        public final void setFlowStatusMessage(String flowStatusMessage) {
            this.flowStatusMessage = flowStatusMessage;
        }

        @Override
        public final Builder flowStatusMessage(String flowStatusMessage) {
            this.flowStatusMessage = flowStatusMessage;
            return this;
        }

        public final SourceFlowConfig.Builder getSourceFlowConfig() {
            return this.sourceFlowConfig != null ? this.sourceFlowConfig.toBuilder() : null;
        }

        public final void setSourceFlowConfig(SourceFlowConfig.BuilderImpl sourceFlowConfig) {
            this.sourceFlowConfig = sourceFlowConfig != null ? sourceFlowConfig.build() : null;
        }

        @Override
        public final Builder sourceFlowConfig(SourceFlowConfig sourceFlowConfig) {
            this.sourceFlowConfig = sourceFlowConfig;
            return this;
        }

        public final List<DestinationFlowConfig.Builder> getDestinationFlowConfigList() {
            List<DestinationFlowConfig.Builder> result = DestinationFlowConfigListCopier.copyToBuilder(this.destinationFlowConfigList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinationFlowConfigList(Collection<DestinationFlowConfig.BuilderImpl> destinationFlowConfigList) {
            this.destinationFlowConfigList = DestinationFlowConfigListCopier.copyFromBuilder(destinationFlowConfigList);
        }

        @Override
        public final Builder destinationFlowConfigList(Collection<DestinationFlowConfig> destinationFlowConfigList) {
            this.destinationFlowConfigList = DestinationFlowConfigListCopier.copy(destinationFlowConfigList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationFlowConfigList(DestinationFlowConfig ... destinationFlowConfigList) {
            this.destinationFlowConfigList(Arrays.asList(destinationFlowConfigList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationFlowConfigList(Consumer<DestinationFlowConfig.Builder> ... destinationFlowConfigList) {
            this.destinationFlowConfigList(Stream.of(destinationFlowConfigList).map(c -> (DestinationFlowConfig)((DestinationFlowConfig.Builder)DestinationFlowConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ExecutionDetails.Builder getLastRunExecutionDetails() {
            return this.lastRunExecutionDetails != null ? this.lastRunExecutionDetails.toBuilder() : null;
        }

        public final void setLastRunExecutionDetails(ExecutionDetails.BuilderImpl lastRunExecutionDetails) {
            this.lastRunExecutionDetails = lastRunExecutionDetails != null ? lastRunExecutionDetails.build() : null;
        }

        @Override
        public final Builder lastRunExecutionDetails(ExecutionDetails lastRunExecutionDetails) {
            this.lastRunExecutionDetails = lastRunExecutionDetails;
            return this;
        }

        public final TriggerConfig.Builder getTriggerConfig() {
            return this.triggerConfig != null ? this.triggerConfig.toBuilder() : null;
        }

        public final void setTriggerConfig(TriggerConfig.BuilderImpl triggerConfig) {
            this.triggerConfig = triggerConfig != null ? triggerConfig.build() : null;
        }

        @Override
        public final Builder triggerConfig(TriggerConfig triggerConfig) {
            this.triggerConfig = triggerConfig;
            return this;
        }

        public final List<Task.Builder> getTasks() {
            List<Task.Builder> result = TasksCopier.copyToBuilder(this.tasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTasks(Collection<Task.BuilderImpl> tasks) {
            this.tasks = TasksCopier.copyFromBuilder(tasks);
        }

        @Override
        public final Builder tasks(Collection<Task> tasks) {
            this.tasks = TasksCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Task ... tasks) {
            this.tasks(Arrays.asList(tasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Consumer<Task.Builder> ... tasks) {
            this.tasks(Stream.of(tasks).map(c -> (Task)((Task.Builder)Task.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getLastUpdatedBy() {
            return this.lastUpdatedBy;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public DescribeFlowResponse build() {
            return new DescribeFlowResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppflowResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFlowResponse> {
        public Builder flowArn(String var1);

        public Builder description(String var1);

        public Builder flowName(String var1);

        public Builder kmsArn(String var1);

        public Builder flowStatus(String var1);

        public Builder flowStatus(FlowStatus var1);

        public Builder flowStatusMessage(String var1);

        public Builder sourceFlowConfig(SourceFlowConfig var1);

        default public Builder sourceFlowConfig(Consumer<SourceFlowConfig.Builder> sourceFlowConfig) {
            return this.sourceFlowConfig((SourceFlowConfig)((SourceFlowConfig.Builder)SourceFlowConfig.builder().applyMutation(sourceFlowConfig)).build());
        }

        public Builder destinationFlowConfigList(Collection<DestinationFlowConfig> var1);

        public Builder destinationFlowConfigList(DestinationFlowConfig ... var1);

        public Builder destinationFlowConfigList(Consumer<DestinationFlowConfig.Builder> ... var1);

        public Builder lastRunExecutionDetails(ExecutionDetails var1);

        default public Builder lastRunExecutionDetails(Consumer<ExecutionDetails.Builder> lastRunExecutionDetails) {
            return this.lastRunExecutionDetails((ExecutionDetails)((ExecutionDetails.Builder)ExecutionDetails.builder().applyMutation(lastRunExecutionDetails)).build());
        }

        public Builder triggerConfig(TriggerConfig var1);

        default public Builder triggerConfig(Consumer<TriggerConfig.Builder> triggerConfig) {
            return this.triggerConfig((TriggerConfig)((TriggerConfig.Builder)TriggerConfig.builder().applyMutation(triggerConfig)).build());
        }

        public Builder tasks(Collection<Task> var1);

        public Builder tasks(Task ... var1);

        public Builder tasks(Consumer<Task.Builder> ... var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder lastUpdatedBy(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

