/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftConnectorProfileProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftConnectorProfileProperties> {
    private static final SdkField<String> DATABASE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("databaseUrl").getter(RedshiftConnectorProfileProperties.getter(RedshiftConnectorProfileProperties::databaseUrl)).setter(RedshiftConnectorProfileProperties.setter(Builder::databaseUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseUrl").build()}).build();
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketName").getter(RedshiftConnectorProfileProperties.getter(RedshiftConnectorProfileProperties::bucketName)).setter(RedshiftConnectorProfileProperties.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()}).build();
    private static final SdkField<String> BUCKET_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketPrefix").getter(RedshiftConnectorProfileProperties.getter(RedshiftConnectorProfileProperties::bucketPrefix)).setter(RedshiftConnectorProfileProperties.setter(Builder::bucketPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketPrefix").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(RedshiftConnectorProfileProperties.getter(RedshiftConnectorProfileProperties::roleArn)).setter(RedshiftConnectorProfileProperties.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_URL_FIELD, BUCKET_NAME_FIELD, BUCKET_PREFIX_FIELD, ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String databaseUrl;
    private final String bucketName;
    private final String bucketPrefix;
    private final String roleArn;

    private RedshiftConnectorProfileProperties(BuilderImpl builder) {
        this.databaseUrl = builder.databaseUrl;
        this.bucketName = builder.bucketName;
        this.bucketPrefix = builder.bucketPrefix;
        this.roleArn = builder.roleArn;
    }

    public final String databaseUrl() {
        return this.databaseUrl;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final String bucketPrefix() {
        return this.bucketPrefix;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftConnectorProfileProperties)) {
            return false;
        }
        RedshiftConnectorProfileProperties other = (RedshiftConnectorProfileProperties)obj;
        return Objects.equals(this.databaseUrl(), other.databaseUrl()) && Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.bucketPrefix(), other.bucketPrefix()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"RedshiftConnectorProfileProperties").add("DatabaseUrl", (Object)this.databaseUrl()).add("BucketName", (Object)this.bucketName()).add("BucketPrefix", (Object)this.bucketPrefix()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "databaseUrl": {
                return Optional.ofNullable(clazz.cast(this.databaseUrl()));
            }
            case "bucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "bucketPrefix": {
                return Optional.ofNullable(clazz.cast(this.bucketPrefix()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftConnectorProfileProperties, T> g) {
        return obj -> g.apply((RedshiftConnectorProfileProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String databaseUrl;
        private String bucketName;
        private String bucketPrefix;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftConnectorProfileProperties model) {
            this.databaseUrl(model.databaseUrl);
            this.bucketName(model.bucketName);
            this.bucketPrefix(model.bucketPrefix);
            this.roleArn(model.roleArn);
        }

        public final String getDatabaseUrl() {
            return this.databaseUrl;
        }

        public final void setDatabaseUrl(String databaseUrl) {
            this.databaseUrl = databaseUrl;
        }

        @Override
        @Transient
        public final Builder databaseUrl(String databaseUrl) {
            this.databaseUrl = databaseUrl;
            return this;
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        @Transient
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getBucketPrefix() {
            return this.bucketPrefix;
        }

        public final void setBucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
        }

        @Override
        @Transient
        public final Builder bucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public RedshiftConnectorProfileProperties build() {
            return new RedshiftConnectorProfileProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftConnectorProfileProperties> {
        public Builder databaseUrl(String var1);

        public Builder bucketName(String var1);

        public Builder bucketPrefix(String var1);

        public Builder roleArn(String var1);
    }
}

