/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the configuration of the source connector used in the flow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceFlowConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceFlowConfig.Builder, SourceFlowConfig> {
    private static final SdkField<String> CONNECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorType").getter(getter(SourceFlowConfig::connectorTypeAsString))
            .setter(setter(Builder::connectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorType").build()).build();

    private static final SdkField<String> CONNECTOR_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorProfileName").getter(getter(SourceFlowConfig::connectorProfileName))
            .setter(setter(Builder::connectorProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileName").build())
            .build();

    private static final SdkField<SourceConnectorProperties> SOURCE_CONNECTOR_PROPERTIES_FIELD = SdkField
            .<SourceConnectorProperties> builder(MarshallingType.SDK_POJO).memberName("sourceConnectorProperties")
            .getter(getter(SourceFlowConfig::sourceConnectorProperties)).setter(setter(Builder::sourceConnectorProperties))
            .constructor(SourceConnectorProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceConnectorProperties").build())
            .build();

    private static final SdkField<IncrementalPullConfig> INCREMENTAL_PULL_CONFIG_FIELD = SdkField
            .<IncrementalPullConfig> builder(MarshallingType.SDK_POJO).memberName("incrementalPullConfig")
            .getter(getter(SourceFlowConfig::incrementalPullConfig)).setter(setter(Builder::incrementalPullConfig))
            .constructor(IncrementalPullConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incrementalPullConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_TYPE_FIELD,
            CONNECTOR_PROFILE_NAME_FIELD, SOURCE_CONNECTOR_PROPERTIES_FIELD, INCREMENTAL_PULL_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String connectorType;

    private final String connectorProfileName;

    private final SourceConnectorProperties sourceConnectorProperties;

    private final IncrementalPullConfig incrementalPullConfig;

    private SourceFlowConfig(BuilderImpl builder) {
        this.connectorType = builder.connectorType;
        this.connectorProfileName = builder.connectorProfileName;
        this.sourceConnectorProperties = builder.sourceConnectorProperties;
        this.incrementalPullConfig = builder.incrementalPullConfig;
    }

    /**
     * <p>
     * The type of connector, such as Salesforce, Amplitude, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The type of connector, such as Salesforce, Amplitude, and so on.
     * @see ConnectorType
     */
    public final ConnectorType connectorType() {
        return ConnectorType.fromValue(connectorType);
    }

    /**
     * <p>
     * The type of connector, such as Salesforce, Amplitude, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The type of connector, such as Salesforce, Amplitude, and so on.
     * @see ConnectorType
     */
    public final String connectorTypeAsString() {
        return connectorType;
    }

    /**
     * <p>
     * The name of the connector profile. This name must be unique for each connector profile in the AWS account.
     * </p>
     * 
     * @return The name of the connector profile. This name must be unique for each connector profile in the AWS
     *         account.
     */
    public final String connectorProfileName() {
        return connectorProfileName;
    }

    /**
     * <p>
     * Specifies the information that is required to query a particular source connector.
     * </p>
     * 
     * @return Specifies the information that is required to query a particular source connector.
     */
    public final SourceConnectorProperties sourceConnectorProperties() {
        return sourceConnectorProperties;
    }

    /**
     * <p>
     * Defines the configuration for a scheduled incremental data pull. If a valid configuration is provided, the fields
     * specified in the configuration are used when querying for the incremental data pull.
     * </p>
     * 
     * @return Defines the configuration for a scheduled incremental data pull. If a valid configuration is provided,
     *         the fields specified in the configuration are used when querying for the incremental data pull.
     */
    public final IncrementalPullConfig incrementalPullConfig() {
        return incrementalPullConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectorProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceConnectorProperties());
        hashCode = 31 * hashCode + Objects.hashCode(incrementalPullConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceFlowConfig)) {
            return false;
        }
        SourceFlowConfig other = (SourceFlowConfig) obj;
        return Objects.equals(connectorTypeAsString(), other.connectorTypeAsString())
                && Objects.equals(connectorProfileName(), other.connectorProfileName())
                && Objects.equals(sourceConnectorProperties(), other.sourceConnectorProperties())
                && Objects.equals(incrementalPullConfig(), other.incrementalPullConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceFlowConfig").add("ConnectorType", connectorTypeAsString())
                .add("ConnectorProfileName", connectorProfileName())
                .add("SourceConnectorProperties", sourceConnectorProperties())
                .add("IncrementalPullConfig", incrementalPullConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorType":
            return Optional.ofNullable(clazz.cast(connectorTypeAsString()));
        case "connectorProfileName":
            return Optional.ofNullable(clazz.cast(connectorProfileName()));
        case "sourceConnectorProperties":
            return Optional.ofNullable(clazz.cast(sourceConnectorProperties()));
        case "incrementalPullConfig":
            return Optional.ofNullable(clazz.cast(incrementalPullConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceFlowConfig, T> g) {
        return obj -> g.apply((SourceFlowConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceFlowConfig> {
        /**
         * <p>
         * The type of connector, such as Salesforce, Amplitude, and so on.
         * </p>
         * 
         * @param connectorType
         *        The type of connector, such as Salesforce, Amplitude, and so on.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder connectorType(String connectorType);

        /**
         * <p>
         * The type of connector, such as Salesforce, Amplitude, and so on.
         * </p>
         * 
         * @param connectorType
         *        The type of connector, such as Salesforce, Amplitude, and so on.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder connectorType(ConnectorType connectorType);

        /**
         * <p>
         * The name of the connector profile. This name must be unique for each connector profile in the AWS account.
         * </p>
         * 
         * @param connectorProfileName
         *        The name of the connector profile. This name must be unique for each connector profile in the AWS
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorProfileName(String connectorProfileName);

        /**
         * <p>
         * Specifies the information that is required to query a particular source connector.
         * </p>
         * 
         * @param sourceConnectorProperties
         *        Specifies the information that is required to query a particular source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceConnectorProperties(SourceConnectorProperties sourceConnectorProperties);

        /**
         * <p>
         * Specifies the information that is required to query a particular source connector.
         * </p>
         * This is a convenience that creates an instance of the {@link SourceConnectorProperties.Builder} avoiding the
         * need to create one manually via {@link SourceConnectorProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceConnectorProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #sourceConnectorProperties(SourceConnectorProperties)}.
         * 
         * @param sourceConnectorProperties
         *        a consumer that will call methods on {@link SourceConnectorProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceConnectorProperties(SourceConnectorProperties)
         */
        default Builder sourceConnectorProperties(Consumer<SourceConnectorProperties.Builder> sourceConnectorProperties) {
            return sourceConnectorProperties(SourceConnectorProperties.builder().applyMutation(sourceConnectorProperties).build());
        }

        /**
         * <p>
         * Defines the configuration for a scheduled incremental data pull. If a valid configuration is provided, the
         * fields specified in the configuration are used when querying for the incremental data pull.
         * </p>
         * 
         * @param incrementalPullConfig
         *        Defines the configuration for a scheduled incremental data pull. If a valid configuration is provided,
         *        the fields specified in the configuration are used when querying for the incremental data pull.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incrementalPullConfig(IncrementalPullConfig incrementalPullConfig);

        /**
         * <p>
         * Defines the configuration for a scheduled incremental data pull. If a valid configuration is provided, the
         * fields specified in the configuration are used when querying for the incremental data pull.
         * </p>
         * This is a convenience that creates an instance of the {@link IncrementalPullConfig.Builder} avoiding the need
         * to create one manually via {@link IncrementalPullConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link IncrementalPullConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #incrementalPullConfig(IncrementalPullConfig)}.
         * 
         * @param incrementalPullConfig
         *        a consumer that will call methods on {@link IncrementalPullConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #incrementalPullConfig(IncrementalPullConfig)
         */
        default Builder incrementalPullConfig(Consumer<IncrementalPullConfig.Builder> incrementalPullConfig) {
            return incrementalPullConfig(IncrementalPullConfig.builder().applyMutation(incrementalPullConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String connectorType;

        private String connectorProfileName;

        private SourceConnectorProperties sourceConnectorProperties;

        private IncrementalPullConfig incrementalPullConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceFlowConfig model) {
            connectorType(model.connectorType);
            connectorProfileName(model.connectorProfileName);
            sourceConnectorProperties(model.sourceConnectorProperties);
            incrementalPullConfig(model.incrementalPullConfig);
        }

        public final String getConnectorType() {
            return connectorType;
        }

        @Override
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        public final Builder connectorType(ConnectorType connectorType) {
            this.connectorType(connectorType == null ? null : connectorType.toString());
            return this;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        public final String getConnectorProfileName() {
            return connectorProfileName;
        }

        @Override
        public final Builder connectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
            return this;
        }

        public final void setConnectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
        }

        public final SourceConnectorProperties.Builder getSourceConnectorProperties() {
            return sourceConnectorProperties != null ? sourceConnectorProperties.toBuilder() : null;
        }

        @Override
        public final Builder sourceConnectorProperties(SourceConnectorProperties sourceConnectorProperties) {
            this.sourceConnectorProperties = sourceConnectorProperties;
            return this;
        }

        public final void setSourceConnectorProperties(SourceConnectorProperties.BuilderImpl sourceConnectorProperties) {
            this.sourceConnectorProperties = sourceConnectorProperties != null ? sourceConnectorProperties.build() : null;
        }

        public final IncrementalPullConfig.Builder getIncrementalPullConfig() {
            return incrementalPullConfig != null ? incrementalPullConfig.toBuilder() : null;
        }

        @Override
        public final Builder incrementalPullConfig(IncrementalPullConfig incrementalPullConfig) {
            this.incrementalPullConfig = incrementalPullConfig;
            return this;
        }

        public final void setIncrementalPullConfig(IncrementalPullConfig.BuilderImpl incrementalPullConfig) {
            this.incrementalPullConfig = incrementalPullConfig != null ? incrementalPullConfig.build() : null;
        }

        @Override
        public SourceFlowConfig build() {
            return new SourceFlowConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
