/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connector metadata specific to Slack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlackMetadata implements SdkPojo, Serializable, ToCopyableBuilder<SlackMetadata.Builder, SlackMetadata> {
    private static final SdkField<List<String>> O_AUTH_SCOPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("oAuthScopes")
            .getter(getter(SlackMetadata::oAuthScopes))
            .setter(setter(Builder::oAuthScopes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuthScopes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(O_AUTH_SCOPES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> oAuthScopes;

    private SlackMetadata(BuilderImpl builder) {
        this.oAuthScopes = builder.oAuthScopes;
    }

    /**
     * Returns true if the OAuthScopes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasOAuthScopes() {
        return oAuthScopes != null && !(oAuthScopes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The desired authorization scope for the Slack account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOAuthScopes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The desired authorization scope for the Slack account.
     */
    public final List<String> oAuthScopes() {
        return oAuthScopes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOAuthScopes() ? oAuthScopes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlackMetadata)) {
            return false;
        }
        SlackMetadata other = (SlackMetadata) obj;
        return hasOAuthScopes() == other.hasOAuthScopes() && Objects.equals(oAuthScopes(), other.oAuthScopes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlackMetadata").add("OAuthScopes", hasOAuthScopes() ? oAuthScopes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "oAuthScopes":
            return Optional.ofNullable(clazz.cast(oAuthScopes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SlackMetadata, T> g) {
        return obj -> g.apply((SlackMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlackMetadata> {
        /**
         * <p>
         * The desired authorization scope for the Slack account.
         * </p>
         * 
         * @param oAuthScopes
         *        The desired authorization scope for the Slack account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthScopes(Collection<String> oAuthScopes);

        /**
         * <p>
         * The desired authorization scope for the Slack account.
         * </p>
         * 
         * @param oAuthScopes
         *        The desired authorization scope for the Slack account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthScopes(String... oAuthScopes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> oAuthScopes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SlackMetadata model) {
            oAuthScopes(model.oAuthScopes);
        }

        public final Collection<String> getOAuthScopes() {
            if (oAuthScopes instanceof SdkAutoConstructList) {
                return null;
            }
            return oAuthScopes;
        }

        @Override
        public final Builder oAuthScopes(Collection<String> oAuthScopes) {
            this.oAuthScopes = OAuthScopeListCopier.copy(oAuthScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder oAuthScopes(String... oAuthScopes) {
            oAuthScopes(Arrays.asList(oAuthScopes));
            return this;
        }

        public final void setOAuthScopes(Collection<String> oAuthScopes) {
            this.oAuthScopes = OAuthScopeListCopier.copy(oAuthScopes);
        }

        @Override
        public SlackMetadata build() {
            return new SlackMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
