/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details regarding the supported field type and the operators that can be applied for filtering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldTypeDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<FieldTypeDetails.Builder, FieldTypeDetails> {
    private static final SdkField<String> FIELD_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fieldType").getter(getter(FieldTypeDetails::fieldType)).setter(setter(Builder::fieldType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldType").build()).build();

    private static final SdkField<List<String>> FILTER_OPERATORS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("filterOperators")
            .getter(getter(FieldTypeDetails::filterOperatorsAsStrings))
            .setter(setter(Builder::filterOperatorsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterOperators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("supportedValues")
            .getter(getter(FieldTypeDetails::supportedValues))
            .setter(setter(Builder::supportedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_TYPE_FIELD,
            FILTER_OPERATORS_FIELD, SUPPORTED_VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fieldType;

    private final List<String> filterOperators;

    private final List<String> supportedValues;

    private FieldTypeDetails(BuilderImpl builder) {
        this.fieldType = builder.fieldType;
        this.filterOperators = builder.filterOperators;
        this.supportedValues = builder.supportedValues;
    }

    /**
     * <p>
     * The type of field, such as string, integer, date, and so on.
     * </p>
     * 
     * @return The type of field, such as string, integer, date, and so on.
     */
    public final String fieldType() {
        return fieldType;
    }

    /**
     * <p>
     * The list of operators supported by a field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilterOperators()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of operators supported by a field.
     */
    public final List<Operator> filterOperators() {
        return FilterOperatorListCopier.copyStringToEnum(filterOperators);
    }

    /**
     * Returns true if the FilterOperators property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasFilterOperators() {
        return filterOperators != null && !(filterOperators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of operators supported by a field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilterOperators()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of operators supported by a field.
     */
    public final List<String> filterOperatorsAsStrings() {
        return filterOperators;
    }

    /**
     * Returns true if the SupportedValues property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSupportedValues() {
        return supportedValues != null && !(supportedValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of values that a field can contain. For example, a Boolean <code>fieldType</code> can have two values:
     * "true" and "false".
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of values that a field can contain. For example, a Boolean <code>fieldType</code> can have two
     *         values: "true" and "false".
     */
    public final List<String> supportedValues() {
        return supportedValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldType());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterOperators() ? filterOperatorsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedValues() ? supportedValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldTypeDetails)) {
            return false;
        }
        FieldTypeDetails other = (FieldTypeDetails) obj;
        return Objects.equals(fieldType(), other.fieldType()) && hasFilterOperators() == other.hasFilterOperators()
                && Objects.equals(filterOperatorsAsStrings(), other.filterOperatorsAsStrings())
                && hasSupportedValues() == other.hasSupportedValues()
                && Objects.equals(supportedValues(), other.supportedValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldTypeDetails").add("FieldType", fieldType())
                .add("FilterOperators", hasFilterOperators() ? filterOperatorsAsStrings() : null)
                .add("SupportedValues", hasSupportedValues() ? supportedValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fieldType":
            return Optional.ofNullable(clazz.cast(fieldType()));
        case "filterOperators":
            return Optional.ofNullable(clazz.cast(filterOperatorsAsStrings()));
        case "supportedValues":
            return Optional.ofNullable(clazz.cast(supportedValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FieldTypeDetails, T> g) {
        return obj -> g.apply((FieldTypeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldTypeDetails> {
        /**
         * <p>
         * The type of field, such as string, integer, date, and so on.
         * </p>
         * 
         * @param fieldType
         *        The type of field, such as string, integer, date, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldType(String fieldType);

        /**
         * <p>
         * The list of operators supported by a field.
         * </p>
         * 
         * @param filterOperators
         *        The list of operators supported by a field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterOperatorsWithStrings(Collection<String> filterOperators);

        /**
         * <p>
         * The list of operators supported by a field.
         * </p>
         * 
         * @param filterOperators
         *        The list of operators supported by a field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterOperatorsWithStrings(String... filterOperators);

        /**
         * <p>
         * The list of operators supported by a field.
         * </p>
         * 
         * @param filterOperators
         *        The list of operators supported by a field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterOperators(Collection<Operator> filterOperators);

        /**
         * <p>
         * The list of operators supported by a field.
         * </p>
         * 
         * @param filterOperators
         *        The list of operators supported by a field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterOperators(Operator... filterOperators);

        /**
         * <p>
         * The list of values that a field can contain. For example, a Boolean <code>fieldType</code> can have two
         * values: "true" and "false".
         * </p>
         * 
         * @param supportedValues
         *        The list of values that a field can contain. For example, a Boolean <code>fieldType</code> can have
         *        two values: "true" and "false".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedValues(Collection<String> supportedValues);

        /**
         * <p>
         * The list of values that a field can contain. For example, a Boolean <code>fieldType</code> can have two
         * values: "true" and "false".
         * </p>
         * 
         * @param supportedValues
         *        The list of values that a field can contain. For example, a Boolean <code>fieldType</code> can have
         *        two values: "true" and "false".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedValues(String... supportedValues);
    }

    static final class BuilderImpl implements Builder {
        private String fieldType;

        private List<String> filterOperators = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FieldTypeDetails model) {
            fieldType(model.fieldType);
            filterOperatorsWithStrings(model.filterOperators);
            supportedValues(model.supportedValues);
        }

        public final String getFieldType() {
            return fieldType;
        }

        @Override
        public final Builder fieldType(String fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        public final void setFieldType(String fieldType) {
            this.fieldType = fieldType;
        }

        public final Collection<String> getFilterOperators() {
            if (filterOperators instanceof SdkAutoConstructList) {
                return null;
            }
            return filterOperators;
        }

        @Override
        public final Builder filterOperatorsWithStrings(Collection<String> filterOperators) {
            this.filterOperators = FilterOperatorListCopier.copy(filterOperators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterOperatorsWithStrings(String... filterOperators) {
            filterOperatorsWithStrings(Arrays.asList(filterOperators));
            return this;
        }

        @Override
        public final Builder filterOperators(Collection<Operator> filterOperators) {
            this.filterOperators = FilterOperatorListCopier.copyEnumToString(filterOperators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterOperators(Operator... filterOperators) {
            filterOperators(Arrays.asList(filterOperators));
            return this;
        }

        public final void setFilterOperators(Collection<String> filterOperators) {
            this.filterOperators = FilterOperatorListCopier.copy(filterOperators);
        }

        public final Collection<String> getSupportedValues() {
            if (supportedValues instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedValues;
        }

        @Override
        public final Builder supportedValues(Collection<String> supportedValues) {
            this.supportedValues = SupportedValueListCopier.copy(supportedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedValues(String... supportedValues) {
            supportedValues(Arrays.asList(supportedValues));
            return this;
        }

        public final void setSupportedValues(Collection<String> supportedValues) {
            this.supportedValues = SupportedValueListCopier.copy(supportedValues);
        }

        @Override
        public FieldTypeDetails build() {
            return new FieldTypeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
