/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the configuration of destination connectors present in the flow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationFlowConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DestinationFlowConfig.Builder, DestinationFlowConfig> {
    private static final SdkField<String> CONNECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorType").getter(getter(DestinationFlowConfig::connectorTypeAsString))
            .setter(setter(Builder::connectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorType").build()).build();

    private static final SdkField<String> CONNECTOR_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorProfileName").getter(getter(DestinationFlowConfig::connectorProfileName))
            .setter(setter(Builder::connectorProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileName").build())
            .build();

    private static final SdkField<DestinationConnectorProperties> DESTINATION_CONNECTOR_PROPERTIES_FIELD = SdkField
            .<DestinationConnectorProperties> builder(MarshallingType.SDK_POJO)
            .memberName("destinationConnectorProperties")
            .getter(getter(DestinationFlowConfig::destinationConnectorProperties))
            .setter(setter(Builder::destinationConnectorProperties))
            .constructor(DestinationConnectorProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConnectorProperties")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_TYPE_FIELD,
            CONNECTOR_PROFILE_NAME_FIELD, DESTINATION_CONNECTOR_PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String connectorType;

    private final String connectorProfileName;

    private final DestinationConnectorProperties destinationConnectorProperties;

    private DestinationFlowConfig(BuilderImpl builder) {
        this.connectorType = builder.connectorType;
        this.connectorProfileName = builder.connectorProfileName;
        this.destinationConnectorProperties = builder.destinationConnectorProperties;
    }

    /**
     * <p>
     * The type of connector, such as Salesforce, Amplitude, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The type of connector, such as Salesforce, Amplitude, and so on.
     * @see ConnectorType
     */
    public final ConnectorType connectorType() {
        return ConnectorType.fromValue(connectorType);
    }

    /**
     * <p>
     * The type of connector, such as Salesforce, Amplitude, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The type of connector, such as Salesforce, Amplitude, and so on.
     * @see ConnectorType
     */
    public final String connectorTypeAsString() {
        return connectorType;
    }

    /**
     * <p>
     * The name of the connector profile. This name must be unique for each connector profile in the AWS account.
     * </p>
     * 
     * @return The name of the connector profile. This name must be unique for each connector profile in the AWS
     *         account.
     */
    public final String connectorProfileName() {
        return connectorProfileName;
    }

    /**
     * <p>
     * This stores the information that is required to query a particular connector.
     * </p>
     * 
     * @return This stores the information that is required to query a particular connector.
     */
    public final DestinationConnectorProperties destinationConnectorProperties() {
        return destinationConnectorProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectorProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(destinationConnectorProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationFlowConfig)) {
            return false;
        }
        DestinationFlowConfig other = (DestinationFlowConfig) obj;
        return Objects.equals(connectorTypeAsString(), other.connectorTypeAsString())
                && Objects.equals(connectorProfileName(), other.connectorProfileName())
                && Objects.equals(destinationConnectorProperties(), other.destinationConnectorProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DestinationFlowConfig").add("ConnectorType", connectorTypeAsString())
                .add("ConnectorProfileName", connectorProfileName())
                .add("DestinationConnectorProperties", destinationConnectorProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorType":
            return Optional.ofNullable(clazz.cast(connectorTypeAsString()));
        case "connectorProfileName":
            return Optional.ofNullable(clazz.cast(connectorProfileName()));
        case "destinationConnectorProperties":
            return Optional.ofNullable(clazz.cast(destinationConnectorProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DestinationFlowConfig, T> g) {
        return obj -> g.apply((DestinationFlowConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationFlowConfig> {
        /**
         * <p>
         * The type of connector, such as Salesforce, Amplitude, and so on.
         * </p>
         * 
         * @param connectorType
         *        The type of connector, such as Salesforce, Amplitude, and so on.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder connectorType(String connectorType);

        /**
         * <p>
         * The type of connector, such as Salesforce, Amplitude, and so on.
         * </p>
         * 
         * @param connectorType
         *        The type of connector, such as Salesforce, Amplitude, and so on.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder connectorType(ConnectorType connectorType);

        /**
         * <p>
         * The name of the connector profile. This name must be unique for each connector profile in the AWS account.
         * </p>
         * 
         * @param connectorProfileName
         *        The name of the connector profile. This name must be unique for each connector profile in the AWS
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorProfileName(String connectorProfileName);

        /**
         * <p>
         * This stores the information that is required to query a particular connector.
         * </p>
         * 
         * @param destinationConnectorProperties
         *        This stores the information that is required to query a particular connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConnectorProperties(DestinationConnectorProperties destinationConnectorProperties);

        /**
         * <p>
         * This stores the information that is required to query a particular connector.
         * </p>
         * This is a convenience that creates an instance of the {@link DestinationConnectorProperties.Builder} avoiding
         * the need to create one manually via {@link DestinationConnectorProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link DestinationConnectorProperties.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #destinationConnectorProperties(DestinationConnectorProperties)}.
         * 
         * @param destinationConnectorProperties
         *        a consumer that will call methods on {@link DestinationConnectorProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationConnectorProperties(DestinationConnectorProperties)
         */
        default Builder destinationConnectorProperties(
                Consumer<DestinationConnectorProperties.Builder> destinationConnectorProperties) {
            return destinationConnectorProperties(DestinationConnectorProperties.builder()
                    .applyMutation(destinationConnectorProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String connectorType;

        private String connectorProfileName;

        private DestinationConnectorProperties destinationConnectorProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationFlowConfig model) {
            connectorType(model.connectorType);
            connectorProfileName(model.connectorProfileName);
            destinationConnectorProperties(model.destinationConnectorProperties);
        }

        public final String getConnectorType() {
            return connectorType;
        }

        @Override
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        public final Builder connectorType(ConnectorType connectorType) {
            this.connectorType(connectorType == null ? null : connectorType.toString());
            return this;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        public final String getConnectorProfileName() {
            return connectorProfileName;
        }

        @Override
        public final Builder connectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
            return this;
        }

        public final void setConnectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
        }

        public final DestinationConnectorProperties.Builder getDestinationConnectorProperties() {
            return destinationConnectorProperties != null ? destinationConnectorProperties.toBuilder() : null;
        }

        @Override
        public final Builder destinationConnectorProperties(DestinationConnectorProperties destinationConnectorProperties) {
            this.destinationConnectorProperties = destinationConnectorProperties;
            return this;
        }

        public final void setDestinationConnectorProperties(
                DestinationConnectorProperties.BuilderImpl destinationConnectorProperties) {
            this.destinationConnectorProperties = destinationConnectorProperties != null ? destinationConnectorProperties.build()
                    : null;
        }

        @Override
        public DestinationFlowConfig build() {
            return new DestinationFlowConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
