/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connector-specific credentials required by Datadog.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatadogConnectorProfileCredentials implements SdkPojo, Serializable,
        ToCopyableBuilder<DatadogConnectorProfileCredentials.Builder, DatadogConnectorProfileCredentials> {
    private static final SdkField<String> API_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("apiKey")
            .getter(getter(DatadogConnectorProfileCredentials::apiKey)).setter(setter(Builder::apiKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKey").build()).build();

    private static final SdkField<String> APPLICATION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationKey").getter(getter(DatadogConnectorProfileCredentials::applicationKey))
            .setter(setter(Builder::applicationKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_KEY_FIELD,
            APPLICATION_KEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String apiKey;

    private final String applicationKey;

    private DatadogConnectorProfileCredentials(BuilderImpl builder) {
        this.apiKey = builder.apiKey;
        this.applicationKey = builder.applicationKey;
    }

    /**
     * <p>
     * A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API.
     * </p>
     * 
     * @return A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API.
     */
    public final String apiKey() {
        return apiKey;
    }

    /**
     * <p>
     * Application keys, in conjunction with your API key, give you full access to Datadog’s programmatic API.
     * Application keys are associated with the user account that created them. The application key is used to log all
     * requests made to the API.
     * </p>
     * 
     * @return Application keys, in conjunction with your API key, give you full access to Datadog’s programmatic API.
     *         Application keys are associated with the user account that created them. The application key is used to
     *         log all requests made to the API.
     */
    public final String applicationKey() {
        return applicationKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiKey());
        hashCode = 31 * hashCode + Objects.hashCode(applicationKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatadogConnectorProfileCredentials)) {
            return false;
        }
        DatadogConnectorProfileCredentials other = (DatadogConnectorProfileCredentials) obj;
        return Objects.equals(apiKey(), other.apiKey()) && Objects.equals(applicationKey(), other.applicationKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatadogConnectorProfileCredentials").add("ApiKey", apiKey())
                .add("ApplicationKey", applicationKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiKey":
            return Optional.ofNullable(clazz.cast(apiKey()));
        case "applicationKey":
            return Optional.ofNullable(clazz.cast(applicationKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatadogConnectorProfileCredentials, T> g) {
        return obj -> g.apply((DatadogConnectorProfileCredentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatadogConnectorProfileCredentials> {
        /**
         * <p>
         * A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API.
         * </p>
         * 
         * @param apiKey
         *        A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your
         *        API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKey(String apiKey);

        /**
         * <p>
         * Application keys, in conjunction with your API key, give you full access to Datadog’s programmatic API.
         * Application keys are associated with the user account that created them. The application key is used to log
         * all requests made to the API.
         * </p>
         * 
         * @param applicationKey
         *        Application keys, in conjunction with your API key, give you full access to Datadog’s programmatic
         *        API. Application keys are associated with the user account that created them. The application key is
         *        used to log all requests made to the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationKey(String applicationKey);
    }

    static final class BuilderImpl implements Builder {
        private String apiKey;

        private String applicationKey;

        private BuilderImpl() {
        }

        private BuilderImpl(DatadogConnectorProfileCredentials model) {
            apiKey(model.apiKey);
            applicationKey(model.applicationKey);
        }

        public final String getApiKey() {
            return apiKey;
        }

        @Override
        public final Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public final void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        public final String getApplicationKey() {
            return applicationKey;
        }

        @Override
        public final Builder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            return this;
        }

        public final void setApplicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
        }

        @Override
        public DatadogConnectorProfileCredentials build() {
            return new DatadogConnectorProfileCredentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
