/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceFieldProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceFieldProperties> {
    private static final SdkField<Boolean> IS_RETRIEVABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isRetrievable").getter(SourceFieldProperties.getter(SourceFieldProperties::isRetrievable)).setter(SourceFieldProperties.setter(Builder::isRetrievable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isRetrievable").build()}).build();
    private static final SdkField<Boolean> IS_QUERYABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isQueryable").getter(SourceFieldProperties.getter(SourceFieldProperties::isQueryable)).setter(SourceFieldProperties.setter(Builder::isQueryable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isQueryable").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_RETRIEVABLE_FIELD, IS_QUERYABLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean isRetrievable;
    private final Boolean isQueryable;

    private SourceFieldProperties(BuilderImpl builder) {
        this.isRetrievable = builder.isRetrievable;
        this.isQueryable = builder.isQueryable;
    }

    public Boolean isRetrievable() {
        return this.isRetrievable;
    }

    public Boolean isQueryable() {
        return this.isQueryable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.isRetrievable());
        hashCode = 31 * hashCode + Objects.hashCode(this.isQueryable());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceFieldProperties)) {
            return false;
        }
        SourceFieldProperties other = (SourceFieldProperties)obj;
        return Objects.equals(this.isRetrievable(), other.isRetrievable()) && Objects.equals(this.isQueryable(), other.isQueryable());
    }

    public String toString() {
        return ToString.builder((String)"SourceFieldProperties").add("IsRetrievable", (Object)this.isRetrievable()).add("IsQueryable", (Object)this.isQueryable()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "isRetrievable": {
                return Optional.ofNullable(clazz.cast(this.isRetrievable()));
            }
            case "isQueryable": {
                return Optional.ofNullable(clazz.cast(this.isQueryable()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceFieldProperties, T> g) {
        return obj -> g.apply((SourceFieldProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean isRetrievable;
        private Boolean isQueryable;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceFieldProperties model) {
            this.isRetrievable(model.isRetrievable);
            this.isQueryable(model.isQueryable);
        }

        public final Boolean getIsRetrievable() {
            return this.isRetrievable;
        }

        @Override
        public final Builder isRetrievable(Boolean isRetrievable) {
            this.isRetrievable = isRetrievable;
            return this;
        }

        public final void setIsRetrievable(Boolean isRetrievable) {
            this.isRetrievable = isRetrievable;
        }

        public final Boolean getIsQueryable() {
            return this.isQueryable;
        }

        @Override
        public final Builder isQueryable(Boolean isQueryable) {
            this.isQueryable = isQueryable;
            return this;
        }

        public final void setIsQueryable(Boolean isQueryable) {
            this.isQueryable = isQueryable;
        }

        public SourceFieldProperties build() {
            return new SourceFieldProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceFieldProperties> {
        public Builder isRetrievable(Boolean var1);

        public Builder isQueryable(Boolean var1);
    }
}

