/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.AppflowRequest;
import software.amazon.awssdk.services.appflow.model.ConnectionMode;
import software.amazon.awssdk.services.appflow.model.ConnectorProfileConfig;
import software.amazon.awssdk.services.appflow.model.ConnectorType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConnectorProfileRequest
extends AppflowRequest
implements ToCopyableBuilder<Builder, CreateConnectorProfileRequest> {
    private static final SdkField<String> CONNECTOR_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorProfileName").getter(CreateConnectorProfileRequest.getter(CreateConnectorProfileRequest::connectorProfileName)).setter(CreateConnectorProfileRequest.setter(Builder::connectorProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileName").build()}).build();
    private static final SdkField<String> KMS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsArn").getter(CreateConnectorProfileRequest.getter(CreateConnectorProfileRequest::kmsArn)).setter(CreateConnectorProfileRequest.setter(Builder::kmsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsArn").build()}).build();
    private static final SdkField<String> CONNECTOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorType").getter(CreateConnectorProfileRequest.getter(CreateConnectorProfileRequest::connectorTypeAsString)).setter(CreateConnectorProfileRequest.setter(Builder::connectorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorType").build()}).build();
    private static final SdkField<String> CONNECTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionMode").getter(CreateConnectorProfileRequest.getter(CreateConnectorProfileRequest::connectionModeAsString)).setter(CreateConnectorProfileRequest.setter(Builder::connectionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionMode").build()}).build();
    private static final SdkField<ConnectorProfileConfig> CONNECTOR_PROFILE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("connectorProfileConfig").getter(CreateConnectorProfileRequest.getter(CreateConnectorProfileRequest::connectorProfileConfig)).setter(CreateConnectorProfileRequest.setter(Builder::connectorProfileConfig)).constructor(ConnectorProfileConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_PROFILE_NAME_FIELD, KMS_ARN_FIELD, CONNECTOR_TYPE_FIELD, CONNECTION_MODE_FIELD, CONNECTOR_PROFILE_CONFIG_FIELD));
    private final String connectorProfileName;
    private final String kmsArn;
    private final String connectorType;
    private final String connectionMode;
    private final ConnectorProfileConfig connectorProfileConfig;

    private CreateConnectorProfileRequest(BuilderImpl builder) {
        super(builder);
        this.connectorProfileName = builder.connectorProfileName;
        this.kmsArn = builder.kmsArn;
        this.connectorType = builder.connectorType;
        this.connectionMode = builder.connectionMode;
        this.connectorProfileConfig = builder.connectorProfileConfig;
    }

    public String connectorProfileName() {
        return this.connectorProfileName;
    }

    public String kmsArn() {
        return this.kmsArn;
    }

    public ConnectorType connectorType() {
        return ConnectorType.fromValue(this.connectorType);
    }

    public String connectorTypeAsString() {
        return this.connectorType;
    }

    public ConnectionMode connectionMode() {
        return ConnectionMode.fromValue(this.connectionMode);
    }

    public String connectionModeAsString() {
        return this.connectionMode;
    }

    public ConnectorProfileConfig connectorProfileConfig() {
        return this.connectorProfileConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorProfileConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectorProfileRequest)) {
            return false;
        }
        CreateConnectorProfileRequest other = (CreateConnectorProfileRequest)((Object)obj);
        return Objects.equals(this.connectorProfileName(), other.connectorProfileName()) && Objects.equals(this.kmsArn(), other.kmsArn()) && Objects.equals(this.connectorTypeAsString(), other.connectorTypeAsString()) && Objects.equals(this.connectionModeAsString(), other.connectionModeAsString()) && Objects.equals(this.connectorProfileConfig(), other.connectorProfileConfig());
    }

    public String toString() {
        return ToString.builder((String)"CreateConnectorProfileRequest").add("ConnectorProfileName", (Object)this.connectorProfileName()).add("KmsArn", (Object)this.kmsArn()).add("ConnectorType", (Object)this.connectorTypeAsString()).add("ConnectionMode", (Object)this.connectionModeAsString()).add("ConnectorProfileConfig", (Object)this.connectorProfileConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectorProfileName": {
                return Optional.ofNullable(clazz.cast(this.connectorProfileName()));
            }
            case "kmsArn": {
                return Optional.ofNullable(clazz.cast(this.kmsArn()));
            }
            case "connectorType": {
                return Optional.ofNullable(clazz.cast(this.connectorTypeAsString()));
            }
            case "connectionMode": {
                return Optional.ofNullable(clazz.cast(this.connectionModeAsString()));
            }
            case "connectorProfileConfig": {
                return Optional.ofNullable(clazz.cast(this.connectorProfileConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectorProfileRequest, T> g) {
        return obj -> g.apply((CreateConnectorProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppflowRequest.BuilderImpl
    implements Builder {
        private String connectorProfileName;
        private String kmsArn;
        private String connectorType;
        private String connectionMode;
        private ConnectorProfileConfig connectorProfileConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectorProfileRequest model) {
            super(model);
            this.connectorProfileName(model.connectorProfileName);
            this.kmsArn(model.kmsArn);
            this.connectorType(model.connectorType);
            this.connectionMode(model.connectionMode);
            this.connectorProfileConfig(model.connectorProfileConfig);
        }

        public final String getConnectorProfileName() {
            return this.connectorProfileName;
        }

        @Override
        public final Builder connectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
            return this;
        }

        public final void setConnectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
        }

        public final String getKmsArn() {
            return this.kmsArn;
        }

        @Override
        public final Builder kmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
            return this;
        }

        public final void setKmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
        }

        public final String getConnectorType() {
            return this.connectorType;
        }

        @Override
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        public final Builder connectorType(ConnectorType connectorType) {
            this.connectorType(connectorType == null ? null : connectorType.toString());
            return this;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        public final String getConnectionMode() {
            return this.connectionMode;
        }

        @Override
        public final Builder connectionMode(String connectionMode) {
            this.connectionMode = connectionMode;
            return this;
        }

        @Override
        public final Builder connectionMode(ConnectionMode connectionMode) {
            this.connectionMode(connectionMode == null ? null : connectionMode.toString());
            return this;
        }

        public final void setConnectionMode(String connectionMode) {
            this.connectionMode = connectionMode;
        }

        public final ConnectorProfileConfig.Builder getConnectorProfileConfig() {
            return this.connectorProfileConfig != null ? this.connectorProfileConfig.toBuilder() : null;
        }

        @Override
        public final Builder connectorProfileConfig(ConnectorProfileConfig connectorProfileConfig) {
            this.connectorProfileConfig = connectorProfileConfig;
            return this;
        }

        public final void setConnectorProfileConfig(ConnectorProfileConfig.BuilderImpl connectorProfileConfig) {
            this.connectorProfileConfig = connectorProfileConfig != null ? connectorProfileConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConnectorProfileRequest build() {
            return new CreateConnectorProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppflowRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConnectorProfileRequest> {
        public Builder connectorProfileName(String var1);

        public Builder kmsArn(String var1);

        public Builder connectorType(String var1);

        public Builder connectorType(ConnectorType var1);

        public Builder connectionMode(String var1);

        public Builder connectionMode(ConnectionMode var1);

        public Builder connectorProfileConfig(ConnectorProfileConfig var1);

        default public Builder connectorProfileConfig(Consumer<ConnectorProfileConfig.Builder> connectorProfileConfig) {
            return this.connectorProfileConfig((ConnectorProfileConfig)((ConnectorProfileConfig.Builder)ConnectorProfileConfig.builder().applyMutation(connectorProfileConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

