/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.DestinationFieldProperties;
import software.amazon.awssdk.services.appflow.model.SourceFieldProperties;
import software.amazon.awssdk.services.appflow.model.SupportedFieldTypeDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectorEntityField
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectorEntityField> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConnectorEntityField.getter(ConnectorEntityField::identifier)).setter(ConnectorEntityField.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()}).build();
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConnectorEntityField.getter(ConnectorEntityField::label)).setter(ConnectorEntityField.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("label").build()}).build();
    private static final SdkField<SupportedFieldTypeDetails> SUPPORTED_FIELD_TYPE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ConnectorEntityField.getter(ConnectorEntityField::supportedFieldTypeDetails)).setter(ConnectorEntityField.setter(Builder::supportedFieldTypeDetails)).constructor(SupportedFieldTypeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedFieldTypeDetails").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConnectorEntityField.getter(ConnectorEntityField::description)).setter(ConnectorEntityField.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<SourceFieldProperties> SOURCE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ConnectorEntityField.getter(ConnectorEntityField::sourceProperties)).setter(ConnectorEntityField.setter(Builder::sourceProperties)).constructor(SourceFieldProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceProperties").build()}).build();
    private static final SdkField<DestinationFieldProperties> DESTINATION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ConnectorEntityField.getter(ConnectorEntityField::destinationProperties)).setter(ConnectorEntityField.setter(Builder::destinationProperties)).constructor(DestinationFieldProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, LABEL_FIELD, SUPPORTED_FIELD_TYPE_DETAILS_FIELD, DESCRIPTION_FIELD, SOURCE_PROPERTIES_FIELD, DESTINATION_PROPERTIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String identifier;
    private final String label;
    private final SupportedFieldTypeDetails supportedFieldTypeDetails;
    private final String description;
    private final SourceFieldProperties sourceProperties;
    private final DestinationFieldProperties destinationProperties;

    private ConnectorEntityField(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.label = builder.label;
        this.supportedFieldTypeDetails = builder.supportedFieldTypeDetails;
        this.description = builder.description;
        this.sourceProperties = builder.sourceProperties;
        this.destinationProperties = builder.destinationProperties;
    }

    public String identifier() {
        return this.identifier;
    }

    public String label() {
        return this.label;
    }

    public SupportedFieldTypeDetails supportedFieldTypeDetails() {
        return this.supportedFieldTypeDetails;
    }

    public String description() {
        return this.description;
    }

    public SourceFieldProperties sourceProperties() {
        return this.sourceProperties;
    }

    public DestinationFieldProperties destinationProperties() {
        return this.destinationProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedFieldTypeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationProperties());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorEntityField)) {
            return false;
        }
        ConnectorEntityField other = (ConnectorEntityField)obj;
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.label(), other.label()) && Objects.equals(this.supportedFieldTypeDetails(), other.supportedFieldTypeDetails()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.sourceProperties(), other.sourceProperties()) && Objects.equals(this.destinationProperties(), other.destinationProperties());
    }

    public String toString() {
        return ToString.builder((String)"ConnectorEntityField").add("Identifier", (Object)this.identifier()).add("Label", (Object)this.label()).add("SupportedFieldTypeDetails", (Object)this.supportedFieldTypeDetails()).add("Description", (Object)this.description()).add("SourceProperties", (Object)this.sourceProperties()).add("DestinationProperties", (Object)this.destinationProperties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "supportedFieldTypeDetails": {
                return Optional.ofNullable(clazz.cast(this.supportedFieldTypeDetails()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "sourceProperties": {
                return Optional.ofNullable(clazz.cast(this.sourceProperties()));
            }
            case "destinationProperties": {
                return Optional.ofNullable(clazz.cast(this.destinationProperties()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectorEntityField, T> g) {
        return obj -> g.apply((ConnectorEntityField)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String identifier;
        private String label;
        private SupportedFieldTypeDetails supportedFieldTypeDetails;
        private String description;
        private SourceFieldProperties sourceProperties;
        private DestinationFieldProperties destinationProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorEntityField model) {
            this.identifier(model.identifier);
            this.label(model.label);
            this.supportedFieldTypeDetails(model.supportedFieldTypeDetails);
            this.description(model.description);
            this.sourceProperties(model.sourceProperties);
            this.destinationProperties(model.destinationProperties);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public final String getLabel() {
            return this.label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final SupportedFieldTypeDetails.Builder getSupportedFieldTypeDetails() {
            return this.supportedFieldTypeDetails != null ? this.supportedFieldTypeDetails.toBuilder() : null;
        }

        @Override
        public final Builder supportedFieldTypeDetails(SupportedFieldTypeDetails supportedFieldTypeDetails) {
            this.supportedFieldTypeDetails = supportedFieldTypeDetails;
            return this;
        }

        public final void setSupportedFieldTypeDetails(SupportedFieldTypeDetails.BuilderImpl supportedFieldTypeDetails) {
            this.supportedFieldTypeDetails = supportedFieldTypeDetails != null ? supportedFieldTypeDetails.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final SourceFieldProperties.Builder getSourceProperties() {
            return this.sourceProperties != null ? this.sourceProperties.toBuilder() : null;
        }

        @Override
        public final Builder sourceProperties(SourceFieldProperties sourceProperties) {
            this.sourceProperties = sourceProperties;
            return this;
        }

        public final void setSourceProperties(SourceFieldProperties.BuilderImpl sourceProperties) {
            this.sourceProperties = sourceProperties != null ? sourceProperties.build() : null;
        }

        public final DestinationFieldProperties.Builder getDestinationProperties() {
            return this.destinationProperties != null ? this.destinationProperties.toBuilder() : null;
        }

        @Override
        public final Builder destinationProperties(DestinationFieldProperties destinationProperties) {
            this.destinationProperties = destinationProperties;
            return this;
        }

        public final void setDestinationProperties(DestinationFieldProperties.BuilderImpl destinationProperties) {
            this.destinationProperties = destinationProperties != null ? destinationProperties.build() : null;
        }

        public ConnectorEntityField build() {
            return new ConnectorEntityField(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectorEntityField> {
        public Builder identifier(String var1);

        public Builder label(String var1);

        public Builder supportedFieldTypeDetails(SupportedFieldTypeDetails var1);

        default public Builder supportedFieldTypeDetails(Consumer<SupportedFieldTypeDetails.Builder> supportedFieldTypeDetails) {
            return this.supportedFieldTypeDetails((SupportedFieldTypeDetails)((SupportedFieldTypeDetails.Builder)SupportedFieldTypeDetails.builder().applyMutation(supportedFieldTypeDetails)).build());
        }

        public Builder description(String var1);

        public Builder sourceProperties(SourceFieldProperties var1);

        default public Builder sourceProperties(Consumer<SourceFieldProperties.Builder> sourceProperties) {
            return this.sourceProperties((SourceFieldProperties)((SourceFieldProperties.Builder)SourceFieldProperties.builder().applyMutation(sourceProperties)).build());
        }

        public Builder destinationProperties(DestinationFieldProperties var1);

        default public Builder destinationProperties(Consumer<DestinationFieldProperties.Builder> destinationProperties) {
            return this.destinationProperties((DestinationFieldProperties)((DestinationFieldProperties.Builder)DestinationFieldProperties.builder().applyMutation(destinationProperties)).build());
        }
    }
}

