/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AppAuthorizationStatus {
    PENDING_CONNECT("PendingConnect"),
    CONNECTED("Connected"),
    CONNECTION_VALIDATION_FAILED("ConnectionValidationFailed"),
    TOKEN_AUTO_ROTATION_FAILED("TokenAutoRotationFailed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AppAuthorizationStatus> VALUE_MAP;
    private final String value;

    private AppAuthorizationStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AppAuthorizationStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AppAuthorizationStatus> knownValues() {
        EnumSet<AppAuthorizationStatus> knownValues = EnumSet.allOf(AppAuthorizationStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AppAuthorizationStatus.class, AppAuthorizationStatus::toString);
    }
}

