/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appfabric.model.FirehoseStream;
import software.amazon.awssdk.services.appfabric.model.S3Bucket;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Destination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Destination> {
    private static final SdkField<S3Bucket> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Bucket").getter(Destination.getter(Destination::s3Bucket)).setter(Destination.setter(Builder::s3Bucket)).constructor(S3Bucket::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()}).build();
    private static final SdkField<FirehoseStream> FIREHOSE_STREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("firehoseStream").getter(Destination.getter(Destination::firehoseStream)).setter(Destination.setter(Builder::firehoseStream)).constructor(FirehoseStream::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firehoseStream").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_FIELD, FIREHOSE_STREAM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Destination.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final S3Bucket s3Bucket;
    private final FirehoseStream firehoseStream;
    private final Type type;

    private Destination(BuilderImpl builder) {
        this.s3Bucket = builder.s3Bucket;
        this.firehoseStream = builder.firehoseStream;
        this.type = builder.type;
    }

    public final S3Bucket s3Bucket() {
        return this.s3Bucket;
    }

    public final FirehoseStream firehoseStream() {
        return this.firehoseStream;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.firehoseStream());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Destination)) {
            return false;
        }
        Destination other = (Destination)obj;
        return Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.firehoseStream(), other.firehoseStream());
    }

    public final String toString() {
        return ToString.builder((String)"Destination").add("S3Bucket", (Object)this.s3Bucket()).add("FirehoseStream", (Object)this.firehoseStream()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "firehoseStream": {
                return Optional.ofNullable(clazz.cast(this.firehoseStream()));
            }
        }
        return Optional.empty();
    }

    public static Destination fromS3Bucket(S3Bucket s3Bucket) {
        return (Destination)Destination.builder().s3Bucket(s3Bucket).build();
    }

    public static Destination fromS3Bucket(Consumer<S3Bucket.Builder> s3Bucket) {
        S3Bucket.Builder builder = S3Bucket.builder();
        s3Bucket.accept(builder);
        return Destination.fromS3Bucket((S3Bucket)builder.build());
    }

    public static Destination fromFirehoseStream(FirehoseStream firehoseStream) {
        return (Destination)Destination.builder().firehoseStream(firehoseStream).build();
    }

    public static Destination fromFirehoseStream(Consumer<FirehoseStream.Builder> firehoseStream) {
        FirehoseStream.Builder builder = FirehoseStream.builder();
        firehoseStream.accept(builder);
        return Destination.fromFirehoseStream((FirehoseStream)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("s3Bucket", S3_BUCKET_FIELD);
        map.put("firehoseStream", FIREHOSE_STREAM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Destination, T> g) {
        return obj -> g.apply((Destination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        S3_BUCKET,
        FIREHOSE_STREAM,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private S3Bucket s3Bucket;
        private FirehoseStream firehoseStream;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Destination model) {
            this.s3Bucket(model.s3Bucket);
            this.firehoseStream(model.firehoseStream);
        }

        public final S3Bucket.Builder getS3Bucket() {
            return this.s3Bucket != null ? this.s3Bucket.toBuilder() : null;
        }

        public final void setS3Bucket(S3Bucket.BuilderImpl s3Bucket) {
            S3Bucket oldValue = this.s3Bucket;
            this.s3Bucket = s3Bucket != null ? s3Bucket.build() : null;
            this.handleUnionValueChange(Type.S3_BUCKET, oldValue, this.s3Bucket);
        }

        @Override
        public final Builder s3Bucket(S3Bucket s3Bucket) {
            S3Bucket oldValue = this.s3Bucket;
            this.s3Bucket = s3Bucket;
            this.handleUnionValueChange(Type.S3_BUCKET, oldValue, this.s3Bucket);
            return this;
        }

        public final FirehoseStream.Builder getFirehoseStream() {
            return this.firehoseStream != null ? this.firehoseStream.toBuilder() : null;
        }

        public final void setFirehoseStream(FirehoseStream.BuilderImpl firehoseStream) {
            FirehoseStream oldValue = this.firehoseStream;
            this.firehoseStream = firehoseStream != null ? firehoseStream.build() : null;
            this.handleUnionValueChange(Type.FIREHOSE_STREAM, oldValue, this.firehoseStream);
        }

        @Override
        public final Builder firehoseStream(FirehoseStream firehoseStream) {
            FirehoseStream oldValue = this.firehoseStream;
            this.firehoseStream = firehoseStream;
            this.handleUnionValueChange(Type.FIREHOSE_STREAM, oldValue, this.firehoseStream);
            return this;
        }

        public Destination build() {
            return new Destination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Destination> {
        public Builder s3Bucket(S3Bucket var1);

        default public Builder s3Bucket(Consumer<S3Bucket.Builder> s3Bucket) {
            return this.s3Bucket((S3Bucket)((S3Bucket.Builder)S3Bucket.builder().applyMutation(s3Bucket)).build());
        }

        public Builder firehoseStream(FirehoseStream var1);

        default public Builder firehoseStream(Consumer<FirehoseStream.Builder> firehoseStream) {
            return this.firehoseStream((FirehoseStream)((FirehoseStream.Builder)FirehoseStream.builder().applyMutation(firehoseStream)).build());
        }
    }
}

