/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appfabric.model.AppFabricRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIngestionRequest
extends AppFabricRequest
implements ToCopyableBuilder<Builder, GetIngestionRequest> {
    private static final SdkField<String> APP_BUNDLE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appBundleIdentifier").getter(GetIngestionRequest.getter(GetIngestionRequest::appBundleIdentifier)).setter(GetIngestionRequest.setter(Builder::appBundleIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appBundleIdentifier").build()}).build();
    private static final SdkField<String> INGESTION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ingestionIdentifier").getter(GetIngestionRequest.getter(GetIngestionRequest::ingestionIdentifier)).setter(GetIngestionRequest.setter(Builder::ingestionIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ingestionIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_BUNDLE_IDENTIFIER_FIELD, INGESTION_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetIngestionRequest.memberNameToFieldInitializer();
    private final String appBundleIdentifier;
    private final String ingestionIdentifier;

    private GetIngestionRequest(BuilderImpl builder) {
        super(builder);
        this.appBundleIdentifier = builder.appBundleIdentifier;
        this.ingestionIdentifier = builder.ingestionIdentifier;
    }

    public final String appBundleIdentifier() {
        return this.appBundleIdentifier;
    }

    public final String ingestionIdentifier() {
        return this.ingestionIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appBundleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIngestionRequest)) {
            return false;
        }
        GetIngestionRequest other = (GetIngestionRequest)((Object)obj);
        return Objects.equals(this.appBundleIdentifier(), other.appBundleIdentifier()) && Objects.equals(this.ingestionIdentifier(), other.ingestionIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"GetIngestionRequest").add("AppBundleIdentifier", (Object)this.appBundleIdentifier()).add("IngestionIdentifier", (Object)this.ingestionIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appBundleIdentifier": {
                return Optional.ofNullable(clazz.cast(this.appBundleIdentifier()));
            }
            case "ingestionIdentifier": {
                return Optional.ofNullable(clazz.cast(this.ingestionIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("appBundleIdentifier", APP_BUNDLE_IDENTIFIER_FIELD);
        map.put("ingestionIdentifier", INGESTION_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIngestionRequest, T> g) {
        return obj -> g.apply((GetIngestionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppFabricRequest.BuilderImpl
    implements Builder {
        private String appBundleIdentifier;
        private String ingestionIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIngestionRequest model) {
            super(model);
            this.appBundleIdentifier(model.appBundleIdentifier);
            this.ingestionIdentifier(model.ingestionIdentifier);
        }

        public final String getAppBundleIdentifier() {
            return this.appBundleIdentifier;
        }

        public final void setAppBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
        }

        @Override
        public final Builder appBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
            return this;
        }

        public final String getIngestionIdentifier() {
            return this.ingestionIdentifier;
        }

        public final void setIngestionIdentifier(String ingestionIdentifier) {
            this.ingestionIdentifier = ingestionIdentifier;
        }

        @Override
        public final Builder ingestionIdentifier(String ingestionIdentifier) {
            this.ingestionIdentifier = ingestionIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetIngestionRequest build() {
            return new GetIngestionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppFabricRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIngestionRequest> {
        public Builder appBundleIdentifier(String var1);

        public Builder ingestionIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

