/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appfabric.model.AppBundleSummary;
import software.amazon.awssdk.services.appfabric.model.AppBundleSummaryListCopier;
import software.amazon.awssdk.services.appfabric.model.AppFabricResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAppBundlesResponse
extends AppFabricResponse
implements ToCopyableBuilder<Builder, ListAppBundlesResponse> {
    private static final SdkField<List<AppBundleSummary>> APP_BUNDLE_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("appBundleSummaryList").getter(ListAppBundlesResponse.getter(ListAppBundlesResponse::appBundleSummaryList)).setter(ListAppBundlesResponse.setter(Builder::appBundleSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appBundleSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AppBundleSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAppBundlesResponse.getter(ListAppBundlesResponse::nextToken)).setter(ListAppBundlesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_BUNDLE_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("appBundleSummaryList", APP_BUNDLE_SUMMARY_LIST_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<AppBundleSummary> appBundleSummaryList;
    private final String nextToken;

    private ListAppBundlesResponse(BuilderImpl builder) {
        super(builder);
        this.appBundleSummaryList = builder.appBundleSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAppBundleSummaryList() {
        return this.appBundleSummaryList != null && !(this.appBundleSummaryList instanceof SdkAutoConstructList);
    }

    public final List<AppBundleSummary> appBundleSummaryList() {
        return this.appBundleSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppBundleSummaryList() ? this.appBundleSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppBundlesResponse)) {
            return false;
        }
        ListAppBundlesResponse other = (ListAppBundlesResponse)((Object)obj);
        return this.hasAppBundleSummaryList() == other.hasAppBundleSummaryList() && Objects.equals(this.appBundleSummaryList(), other.appBundleSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAppBundlesResponse").add("AppBundleSummaryList", this.hasAppBundleSummaryList() ? this.appBundleSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appBundleSummaryList": {
                return Optional.ofNullable(clazz.cast(this.appBundleSummaryList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAppBundlesResponse, T> g) {
        return obj -> g.apply((ListAppBundlesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppFabricResponse.BuilderImpl
    implements Builder {
        private List<AppBundleSummary> appBundleSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppBundlesResponse model) {
            super(model);
            this.appBundleSummaryList(model.appBundleSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<AppBundleSummary.Builder> getAppBundleSummaryList() {
            List<AppBundleSummary.Builder> result = AppBundleSummaryListCopier.copyToBuilder(this.appBundleSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppBundleSummaryList(Collection<AppBundleSummary.BuilderImpl> appBundleSummaryList) {
            this.appBundleSummaryList = AppBundleSummaryListCopier.copyFromBuilder(appBundleSummaryList);
        }

        @Override
        public final Builder appBundleSummaryList(Collection<AppBundleSummary> appBundleSummaryList) {
            this.appBundleSummaryList = AppBundleSummaryListCopier.copy(appBundleSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appBundleSummaryList(AppBundleSummary ... appBundleSummaryList) {
            this.appBundleSummaryList(Arrays.asList(appBundleSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appBundleSummaryList(Consumer<AppBundleSummary.Builder> ... appBundleSummaryList) {
            this.appBundleSummaryList(Stream.of(appBundleSummaryList).map(c -> (AppBundleSummary)((AppBundleSummary.Builder)AppBundleSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAppBundlesResponse build() {
            return new ListAppBundlesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppFabricResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAppBundlesResponse> {
        public Builder appBundleSummaryList(Collection<AppBundleSummary> var1);

        public Builder appBundleSummaryList(AppBundleSummary ... var1);

        public Builder appBundleSummaryList(Consumer<AppBundleSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

