/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.appfabric.AppFabricAsyncClient;
import software.amazon.awssdk.services.appfabric.AppFabricAsyncClientBuilder;
import software.amazon.awssdk.services.appfabric.AppFabricServiceClientConfiguration;
import software.amazon.awssdk.services.appfabric.DefaultAppFabricAsyncClient;
import software.amazon.awssdk.services.appfabric.DefaultAppFabricBaseClientBuilder;
import software.amazon.awssdk.services.appfabric.endpoints.AppFabricEndpointProvider;

@SdkInternalApi
final class DefaultAppFabricAsyncClientBuilder
extends DefaultAppFabricBaseClientBuilder<AppFabricAsyncClientBuilder, AppFabricAsyncClient>
implements AppFabricAsyncClientBuilder {
    DefaultAppFabricAsyncClientBuilder() {
    }

    @Override
    public DefaultAppFabricAsyncClientBuilder endpointProvider(AppFabricEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AppFabricAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultAppFabricAsyncClientBuilder.validateClientOptions(clientConfiguration);
        AppFabricServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAppFabricAsyncClient client = new DefaultAppFabricAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AppFabricServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AppFabricServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

