/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appfabric.AppFabricAsyncClient;
import software.amazon.awssdk.services.appfabric.model.IngestionDestinationSummary;
import software.amazon.awssdk.services.appfabric.model.ListIngestionDestinationsRequest;
import software.amazon.awssdk.services.appfabric.model.ListIngestionDestinationsResponse;

public class ListIngestionDestinationsPublisher
implements SdkPublisher<ListIngestionDestinationsResponse> {
    private final AppFabricAsyncClient client;
    private final ListIngestionDestinationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIngestionDestinationsPublisher(AppFabricAsyncClient client, ListIngestionDestinationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIngestionDestinationsPublisher(AppFabricAsyncClient client, ListIngestionDestinationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIngestionDestinationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIngestionDestinationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IngestionDestinationSummary> ingestionDestinations() {
        Function<ListIngestionDestinationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ingestionDestinations() != null) {
                return response.ingestionDestinations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListIngestionDestinationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListIngestionDestinationsResponseFetcher
    implements AsyncPageFetcher<ListIngestionDestinationsResponse> {
        private ListIngestionDestinationsResponseFetcher() {
        }

        public boolean hasNextPage(ListIngestionDestinationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIngestionDestinationsResponse> nextPage(ListIngestionDestinationsResponse previousPage) {
            if (previousPage == null) {
                return ListIngestionDestinationsPublisher.this.client.listIngestionDestinations(ListIngestionDestinationsPublisher.this.firstRequest);
            }
            return ListIngestionDestinationsPublisher.this.client.listIngestionDestinations((ListIngestionDestinationsRequest)((Object)ListIngestionDestinationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

