/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appfabric.AppFabricAsyncClient;
import software.amazon.awssdk.services.appfabric.internal.UserAgentUtils;
import software.amazon.awssdk.services.appfabric.model.AppBundleSummary;
import software.amazon.awssdk.services.appfabric.model.ListAppBundlesRequest;
import software.amazon.awssdk.services.appfabric.model.ListAppBundlesResponse;

public class ListAppBundlesPublisher
implements SdkPublisher<ListAppBundlesResponse> {
    private final AppFabricAsyncClient client;
    private final ListAppBundlesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAppBundlesPublisher(AppFabricAsyncClient client, ListAppBundlesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAppBundlesPublisher(AppFabricAsyncClient client, ListAppBundlesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAppBundlesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAppBundlesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AppBundleSummary> appBundleSummaryList() {
        Function<ListAppBundlesResponse, Iterator> getIterator = response -> {
            if (response != null && response.appBundleSummaryList() != null) {
                return response.appBundleSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAppBundlesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAppBundlesResponseFetcher
    implements AsyncPageFetcher<ListAppBundlesResponse> {
        private ListAppBundlesResponseFetcher() {
        }

        public boolean hasNextPage(ListAppBundlesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAppBundlesResponse> nextPage(ListAppBundlesResponse previousPage) {
            if (previousPage == null) {
                return ListAppBundlesPublisher.this.client.listAppBundles(ListAppBundlesPublisher.this.firstRequest);
            }
            return ListAppBundlesPublisher.this.client.listAppBundles((ListAppBundlesRequest)((Object)ListAppBundlesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

