/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appfabric.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIngestionDestinationResponse extends AppFabricResponse implements
        ToCopyableBuilder<UpdateIngestionDestinationResponse.Builder, UpdateIngestionDestinationResponse> {
    private static final SdkField<IngestionDestination> INGESTION_DESTINATION_FIELD = SdkField
            .<IngestionDestination> builder(MarshallingType.SDK_POJO).memberName("ingestionDestination")
            .getter(getter(UpdateIngestionDestinationResponse::ingestionDestination))
            .setter(setter(Builder::ingestionDestination)).constructor(IngestionDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestionDestination").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INGESTION_DESTINATION_FIELD));

    private final IngestionDestination ingestionDestination;

    private UpdateIngestionDestinationResponse(BuilderImpl builder) {
        super(builder);
        this.ingestionDestination = builder.ingestionDestination;
    }

    /**
     * <p>
     * Contains information about an ingestion destination.
     * </p>
     * 
     * @return Contains information about an ingestion destination.
     */
    public final IngestionDestination ingestionDestination() {
        return ingestionDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ingestionDestination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIngestionDestinationResponse)) {
            return false;
        }
        UpdateIngestionDestinationResponse other = (UpdateIngestionDestinationResponse) obj;
        return Objects.equals(ingestionDestination(), other.ingestionDestination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateIngestionDestinationResponse").add("IngestionDestination", ingestionDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ingestionDestination":
            return Optional.ofNullable(clazz.cast(ingestionDestination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIngestionDestinationResponse, T> g) {
        return obj -> g.apply((UpdateIngestionDestinationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppFabricResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateIngestionDestinationResponse> {
        /**
         * <p>
         * Contains information about an ingestion destination.
         * </p>
         * 
         * @param ingestionDestination
         *        Contains information about an ingestion destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionDestination(IngestionDestination ingestionDestination);

        /**
         * <p>
         * Contains information about an ingestion destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link IngestionDestination.Builder} avoiding
         * the need to create one manually via {@link IngestionDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngestionDestination.Builder#build()} is called immediately and
         * its result is passed to {@link #ingestionDestination(IngestionDestination)}.
         * 
         * @param ingestionDestination
         *        a consumer that will call methods on {@link IngestionDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingestionDestination(IngestionDestination)
         */
        default Builder ingestionDestination(Consumer<IngestionDestination.Builder> ingestionDestination) {
            return ingestionDestination(IngestionDestination.builder().applyMutation(ingestionDestination).build());
        }
    }

    static final class BuilderImpl extends AppFabricResponse.BuilderImpl implements Builder {
        private IngestionDestination ingestionDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIngestionDestinationResponse model) {
            super(model);
            ingestionDestination(model.ingestionDestination);
        }

        public final IngestionDestination.Builder getIngestionDestination() {
            return ingestionDestination != null ? ingestionDestination.toBuilder() : null;
        }

        public final void setIngestionDestination(IngestionDestination.BuilderImpl ingestionDestination) {
            this.ingestionDestination = ingestionDestination != null ? ingestionDestination.build() : null;
        }

        @Override
        public final Builder ingestionDestination(IngestionDestination ingestionDestination) {
            this.ingestionDestination = ingestionDestination;
            return this;
        }

        @Override
        public UpdateIngestionDestinationResponse build() {
            return new UpdateIngestionDestinationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
