/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAccountSettingsRequest extends AppConfigRequest implements
        ToCopyableBuilder<UpdateAccountSettingsRequest.Builder, UpdateAccountSettingsRequest> {
    private static final SdkField<DeletionProtectionSettings> DELETION_PROTECTION_FIELD = SdkField
            .<DeletionProtectionSettings> builder(MarshallingType.SDK_POJO).memberName("DeletionProtection")
            .getter(getter(UpdateAccountSettingsRequest::deletionProtection)).setter(setter(Builder::deletionProtection))
            .constructor(DeletionProtectionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETION_PROTECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DeletionProtectionSettings deletionProtection;

    private UpdateAccountSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.deletionProtection = builder.deletionProtection;
    }

    /**
     * <p>
     * A parameter to configure deletion protection. Deletion protection prevents a user from deleting a configuration
     * profile or an environment if AppConfig has called either <a href=
     * "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
     * >GetLatestConfiguration</a> or for the configuration profile or from the environment during the specified
     * interval. The default interval for <code>ProtectionPeriodInMinutes</code> is 60.
     * </p>
     * 
     * @return A parameter to configure deletion protection. Deletion protection prevents a user from deleting a
     *         configuration profile or an environment if AppConfig has called either <a href=
     *         "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
     *         >GetLatestConfiguration</a> or for the configuration profile or from the environment during the specified
     *         interval. The default interval for <code>ProtectionPeriodInMinutes</code> is 60.
     */
    public final DeletionProtectionSettings deletionProtection() {
        return deletionProtection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountSettingsRequest)) {
            return false;
        }
        UpdateAccountSettingsRequest other = (UpdateAccountSettingsRequest) obj;
        return Objects.equals(deletionProtection(), other.deletionProtection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAccountSettingsRequest").add("DeletionProtection", deletionProtection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeletionProtection", DELETION_PROTECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccountSettingsRequest, T> g) {
        return obj -> g.apply((UpdateAccountSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAccountSettingsRequest> {
        /**
         * <p>
         * A parameter to configure deletion protection. Deletion protection prevents a user from deleting a
         * configuration profile or an environment if AppConfig has called either <a href=
         * "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
         * >GetLatestConfiguration</a> or for the configuration profile or from the environment during the specified
         * interval. The default interval for <code>ProtectionPeriodInMinutes</code> is 60.
         * </p>
         * 
         * @param deletionProtection
         *        A parameter to configure deletion protection. Deletion protection prevents a user from deleting a
         *        configuration profile or an environment if AppConfig has called either <a href=
         *        "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
         *        >GetLatestConfiguration</a> or for the configuration profile or from the environment during the
         *        specified interval. The default interval for <code>ProtectionPeriodInMinutes</code> is 60.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(DeletionProtectionSettings deletionProtection);

        /**
         * <p>
         * A parameter to configure deletion protection. Deletion protection prevents a user from deleting a
         * configuration profile or an environment if AppConfig has called either <a href=
         * "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
         * >GetLatestConfiguration</a> or for the configuration profile or from the environment during the specified
         * interval. The default interval for <code>ProtectionPeriodInMinutes</code> is 60.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeletionProtectionSettings.Builder}
         * avoiding the need to create one manually via {@link DeletionProtectionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeletionProtectionSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #deletionProtection(DeletionProtectionSettings)}.
         * 
         * @param deletionProtection
         *        a consumer that will call methods on {@link DeletionProtectionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deletionProtection(DeletionProtectionSettings)
         */
        default Builder deletionProtection(Consumer<DeletionProtectionSettings.Builder> deletionProtection) {
            return deletionProtection(DeletionProtectionSettings.builder().applyMutation(deletionProtection).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppConfigRequest.BuilderImpl implements Builder {
        private DeletionProtectionSettings deletionProtection;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountSettingsRequest model) {
            super(model);
            deletionProtection(model.deletionProtection);
        }

        public final DeletionProtectionSettings.Builder getDeletionProtection() {
            return deletionProtection != null ? deletionProtection.toBuilder() : null;
        }

        public final void setDeletionProtection(DeletionProtectionSettings.BuilderImpl deletionProtection) {
            this.deletionProtection = deletionProtection != null ? deletionProtection.build() : null;
        }

        @Override
        public final Builder deletionProtection(DeletionProtectionSettings deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccountSettingsRequest build() {
            return new UpdateAccountSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
