/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateExtensionRequest extends AppConfigRequest implements
        ToCopyableBuilder<CreateExtensionRequest.Builder, CreateExtensionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateExtensionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateExtensionRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Map<String, List<Action>>> ACTIONS_FIELD = SdkField
            .<Map<String, List<Action>>> builder(MarshallingType.MAP)
            .memberName("Actions")
            .getter(getter(CreateExtensionRequest::actionsAsStrings))
            .setter(setter(Builder::actionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<Action>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<Action> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(Action::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Map<String, Parameter>> PARAMETERS_FIELD = SdkField
            .<Map<String, Parameter>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(CreateExtensionRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Parameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Parameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateExtensionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> LATEST_VERSION_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("LatestVersionNumber").getter(getter(CreateExtensionRequest::latestVersionNumber))
            .setter(setter(Builder::latestVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Latest-Version-Number").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            ACTIONS_FIELD, PARAMETERS_FIELD, TAGS_FIELD, LATEST_VERSION_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final Map<String, List<Action>> actions;

    private final Map<String, Parameter> parameters;

    private final Map<String, String> tags;

    private final Integer latestVersionNumber;

    private CreateExtensionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.actions = builder.actions;
        this.parameters = builder.parameters;
        this.tags = builder.tags;
        this.latestVersionNumber = builder.latestVersionNumber;
    }

    /**
     * <p>
     * A name for the extension. Each extension name in your account must be unique. Extension versions use the same
     * name.
     * </p>
     * 
     * @return A name for the extension. Each extension name in your account must be unique. Extension versions use the
     *         same name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Information about the extension.
     * </p>
     * 
     * @return Information about the extension.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The actions defined in the extension.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return The actions defined in the extension.
     */
    public final Map<ActionPoint, List<Action>> actions() {
        return ActionsMapCopier.copyStringToEnum(actions);
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The actions defined in the extension.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return The actions defined in the extension.
     */
    public final Map<String, List<Action>> actionsAsStrings() {
        return actions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The parameters accepted by the extension. You specify parameter values when you associate the extension to an
     * AppConfig resource by using the <code>CreateExtensionAssociation</code> API action. For Lambda extension actions,
     * these parameters are included in the Lambda request object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The parameters accepted by the extension. You specify parameter values when you associate the extension
     *         to an AppConfig resource by using the <code>CreateExtensionAssociation</code> API action. For Lambda
     *         extension actions, these parameters are included in the Lambda request object.
     */
    public final Map<String, Parameter> parameters() {
        return parameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Adds one or more tags for the specified extension. Tags are metadata that help you categorize resources in
     * different ways, for example, by purpose, owner, or environment. Each tag consists of a key and an optional value,
     * both of which you define.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Adds one or more tags for the specified extension. Tags are metadata that help you categorize resources
     *         in different ways, for example, by purpose, owner, or environment. Each tag consists of a key and an
     *         optional value, both of which you define.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * You can omit this field when you create an extension. When you create a new version, specify the most recent
     * current version number. For example, you create version 3, enter 2 for this field.
     * </p>
     * 
     * @return You can omit this field when you create an extension. When you create a new version, specify the most
     *         recent current version number. For example, you create version 3, enter 2 for this field.
     */
    public final Integer latestVersionNumber() {
        return latestVersionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(latestVersionNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExtensionRequest)) {
            return false;
        }
        CreateExtensionRequest other = (CreateExtensionRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasActions() == other.hasActions() && Objects.equals(actionsAsStrings(), other.actionsAsStrings())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(latestVersionNumber(), other.latestVersionNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateExtensionRequest").add("Name", name()).add("Description", description())
                .add("Actions", hasActions() ? actionsAsStrings() : null)
                .add("Parameters", hasParameters() ? parameters() : null).add("Tags", hasTags() ? tags() : null)
                .add("LatestVersionNumber", latestVersionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actionsAsStrings()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "LatestVersionNumber":
            return Optional.ofNullable(clazz.cast(latestVersionNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Actions", ACTIONS_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Latest-Version-Number", LATEST_VERSION_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateExtensionRequest, T> g) {
        return obj -> g.apply((CreateExtensionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateExtensionRequest> {
        /**
         * <p>
         * A name for the extension. Each extension name in your account must be unique. Extension versions use the same
         * name.
         * </p>
         * 
         * @param name
         *        A name for the extension. Each extension name in your account must be unique. Extension versions use
         *        the same name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Information about the extension.
         * </p>
         * 
         * @param description
         *        Information about the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The actions defined in the extension.
         * </p>
         * 
         * @param actions
         *        The actions defined in the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionsWithStrings(Map<String, ? extends Collection<Action>> actions);

        /**
         * <p>
         * The actions defined in the extension.
         * </p>
         * 
         * @param actions
         *        The actions defined in the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Map<ActionPoint, ? extends Collection<Action>> actions);

        /**
         * <p>
         * The parameters accepted by the extension. You specify parameter values when you associate the extension to an
         * AppConfig resource by using the <code>CreateExtensionAssociation</code> API action. For Lambda extension
         * actions, these parameters are included in the Lambda request object.
         * </p>
         * 
         * @param parameters
         *        The parameters accepted by the extension. You specify parameter values when you associate the
         *        extension to an AppConfig resource by using the <code>CreateExtensionAssociation</code> API action.
         *        For Lambda extension actions, these parameters are included in the Lambda request object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, Parameter> parameters);

        /**
         * <p>
         * Adds one or more tags for the specified extension. Tags are metadata that help you categorize resources in
         * different ways, for example, by purpose, owner, or environment. Each tag consists of a key and an optional
         * value, both of which you define.
         * </p>
         * 
         * @param tags
         *        Adds one or more tags for the specified extension. Tags are metadata that help you categorize
         *        resources in different ways, for example, by purpose, owner, or environment. Each tag consists of a
         *        key and an optional value, both of which you define.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * You can omit this field when you create an extension. When you create a new version, specify the most recent
         * current version number. For example, you create version 3, enter 2 for this field.
         * </p>
         * 
         * @param latestVersionNumber
         *        You can omit this field when you create an extension. When you create a new version, specify the most
         *        recent current version number. For example, you create version 3, enter 2 for this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersionNumber(Integer latestVersionNumber);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppConfigRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private Map<String, List<Action>> actions = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, Parameter> parameters = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Integer latestVersionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExtensionRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            actionsWithStrings(model.actions);
            parameters(model.parameters);
            tags(model.tags);
            latestVersionNumber(model.latestVersionNumber);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, List<Action.Builder>> getActions() {
            Map<String, List<Action.Builder>> result = ActionsMapCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setActions(Map<String, ? extends Collection<Action.BuilderImpl>> actions) {
            this.actions = ActionsMapCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actionsWithStrings(Map<String, ? extends Collection<Action>> actions) {
            this.actions = ActionsMapCopier.copy(actions);
            return this;
        }

        @Override
        public final Builder actions(Map<ActionPoint, ? extends Collection<Action>> actions) {
            this.actions = ActionsMapCopier.copyEnumToString(actions);
            return this;
        }

        public final Map<String, Parameter.Builder> getParameters() {
            Map<String, Parameter.Builder> result = ParameterMapCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, Parameter.BuilderImpl> parameters) {
            this.parameters = ParameterMapCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, Parameter> parameters) {
            this.parameters = ParameterMapCopier.copy(parameters);
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Integer getLatestVersionNumber() {
            return latestVersionNumber;
        }

        public final void setLatestVersionNumber(Integer latestVersionNumber) {
            this.latestVersionNumber = latestVersionNumber;
        }

        @Override
        public final Builder latestVersionNumber(Integer latestVersionNumber) {
            this.latestVersionNumber = latestVersionNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateExtensionRequest build() {
            return new CreateExtensionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
