/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appconfig.model.AppConfigRequest;
import software.amazon.awssdk.services.appconfig.model.GrowthType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDeploymentStrategyRequest
extends AppConfigRequest
implements ToCopyableBuilder<Builder, UpdateDeploymentStrategyRequest> {
    private static final SdkField<String> DEPLOYMENT_STRATEGY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentStrategyId").getter(UpdateDeploymentStrategyRequest.getter(UpdateDeploymentStrategyRequest::deploymentStrategyId)).setter(UpdateDeploymentStrategyRequest.setter(Builder::deploymentStrategyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DeploymentStrategyId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateDeploymentStrategyRequest.getter(UpdateDeploymentStrategyRequest::description)).setter(UpdateDeploymentStrategyRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Integer> DEPLOYMENT_DURATION_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DeploymentDurationInMinutes").getter(UpdateDeploymentStrategyRequest.getter(UpdateDeploymentStrategyRequest::deploymentDurationInMinutes)).setter(UpdateDeploymentStrategyRequest.setter(Builder::deploymentDurationInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentDurationInMinutes").build()}).build();
    private static final SdkField<Integer> FINAL_BAKE_TIME_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FinalBakeTimeInMinutes").getter(UpdateDeploymentStrategyRequest.getter(UpdateDeploymentStrategyRequest::finalBakeTimeInMinutes)).setter(UpdateDeploymentStrategyRequest.setter(Builder::finalBakeTimeInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalBakeTimeInMinutes").build()}).build();
    private static final SdkField<Float> GROWTH_FACTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("GrowthFactor").getter(UpdateDeploymentStrategyRequest.getter(UpdateDeploymentStrategyRequest::growthFactor)).setter(UpdateDeploymentStrategyRequest.setter(Builder::growthFactor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrowthFactor").build()}).build();
    private static final SdkField<String> GROWTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrowthType").getter(UpdateDeploymentStrategyRequest.getter(UpdateDeploymentStrategyRequest::growthTypeAsString)).setter(UpdateDeploymentStrategyRequest.setter(Builder::growthType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrowthType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_STRATEGY_ID_FIELD, DESCRIPTION_FIELD, DEPLOYMENT_DURATION_IN_MINUTES_FIELD, FINAL_BAKE_TIME_IN_MINUTES_FIELD, GROWTH_FACTOR_FIELD, GROWTH_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDeploymentStrategyRequest.memberNameToFieldInitializer();
    private final String deploymentStrategyId;
    private final String description;
    private final Integer deploymentDurationInMinutes;
    private final Integer finalBakeTimeInMinutes;
    private final Float growthFactor;
    private final String growthType;

    private UpdateDeploymentStrategyRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentStrategyId = builder.deploymentStrategyId;
        this.description = builder.description;
        this.deploymentDurationInMinutes = builder.deploymentDurationInMinutes;
        this.finalBakeTimeInMinutes = builder.finalBakeTimeInMinutes;
        this.growthFactor = builder.growthFactor;
        this.growthType = builder.growthType;
    }

    public final String deploymentStrategyId() {
        return this.deploymentStrategyId;
    }

    public final String description() {
        return this.description;
    }

    public final Integer deploymentDurationInMinutes() {
        return this.deploymentDurationInMinutes;
    }

    public final Integer finalBakeTimeInMinutes() {
        return this.finalBakeTimeInMinutes;
    }

    public final Float growthFactor() {
        return this.growthFactor;
    }

    public final GrowthType growthType() {
        return GrowthType.fromValue(this.growthType);
    }

    public final String growthTypeAsString() {
        return this.growthType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStrategyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentDurationInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.finalBakeTimeInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.growthFactor());
        hashCode = 31 * hashCode + Objects.hashCode(this.growthTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeploymentStrategyRequest)) {
            return false;
        }
        UpdateDeploymentStrategyRequest other = (UpdateDeploymentStrategyRequest)((Object)obj);
        return Objects.equals(this.deploymentStrategyId(), other.deploymentStrategyId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.deploymentDurationInMinutes(), other.deploymentDurationInMinutes()) && Objects.equals(this.finalBakeTimeInMinutes(), other.finalBakeTimeInMinutes()) && Objects.equals(this.growthFactor(), other.growthFactor()) && Objects.equals(this.growthTypeAsString(), other.growthTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDeploymentStrategyRequest").add("DeploymentStrategyId", (Object)this.deploymentStrategyId()).add("Description", (Object)this.description()).add("DeploymentDurationInMinutes", (Object)this.deploymentDurationInMinutes()).add("FinalBakeTimeInMinutes", (Object)this.finalBakeTimeInMinutes()).add("GrowthFactor", (Object)this.growthFactor()).add("GrowthType", (Object)this.growthTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeploymentStrategyId": {
                return Optional.ofNullable(clazz.cast(this.deploymentStrategyId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DeploymentDurationInMinutes": {
                return Optional.ofNullable(clazz.cast(this.deploymentDurationInMinutes()));
            }
            case "FinalBakeTimeInMinutes": {
                return Optional.ofNullable(clazz.cast(this.finalBakeTimeInMinutes()));
            }
            case "GrowthFactor": {
                return Optional.ofNullable(clazz.cast(this.growthFactor()));
            }
            case "GrowthType": {
                return Optional.ofNullable(clazz.cast(this.growthTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DeploymentStrategyId", DEPLOYMENT_STRATEGY_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DeploymentDurationInMinutes", DEPLOYMENT_DURATION_IN_MINUTES_FIELD);
        map.put("FinalBakeTimeInMinutes", FINAL_BAKE_TIME_IN_MINUTES_FIELD);
        map.put("GrowthFactor", GROWTH_FACTOR_FIELD);
        map.put("GrowthType", GROWTH_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDeploymentStrategyRequest, T> g) {
        return obj -> g.apply((UpdateDeploymentStrategyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppConfigRequest.BuilderImpl
    implements Builder {
        private String deploymentStrategyId;
        private String description;
        private Integer deploymentDurationInMinutes;
        private Integer finalBakeTimeInMinutes;
        private Float growthFactor;
        private String growthType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDeploymentStrategyRequest model) {
            super(model);
            this.deploymentStrategyId(model.deploymentStrategyId);
            this.description(model.description);
            this.deploymentDurationInMinutes(model.deploymentDurationInMinutes);
            this.finalBakeTimeInMinutes(model.finalBakeTimeInMinutes);
            this.growthFactor(model.growthFactor);
            this.growthType(model.growthType);
        }

        public final String getDeploymentStrategyId() {
            return this.deploymentStrategyId;
        }

        public final void setDeploymentStrategyId(String deploymentStrategyId) {
            this.deploymentStrategyId = deploymentStrategyId;
        }

        @Override
        public final Builder deploymentStrategyId(String deploymentStrategyId) {
            this.deploymentStrategyId = deploymentStrategyId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getDeploymentDurationInMinutes() {
            return this.deploymentDurationInMinutes;
        }

        public final void setDeploymentDurationInMinutes(Integer deploymentDurationInMinutes) {
            this.deploymentDurationInMinutes = deploymentDurationInMinutes;
        }

        @Override
        public final Builder deploymentDurationInMinutes(Integer deploymentDurationInMinutes) {
            this.deploymentDurationInMinutes = deploymentDurationInMinutes;
            return this;
        }

        public final Integer getFinalBakeTimeInMinutes() {
            return this.finalBakeTimeInMinutes;
        }

        public final void setFinalBakeTimeInMinutes(Integer finalBakeTimeInMinutes) {
            this.finalBakeTimeInMinutes = finalBakeTimeInMinutes;
        }

        @Override
        public final Builder finalBakeTimeInMinutes(Integer finalBakeTimeInMinutes) {
            this.finalBakeTimeInMinutes = finalBakeTimeInMinutes;
            return this;
        }

        public final Float getGrowthFactor() {
            return this.growthFactor;
        }

        public final void setGrowthFactor(Float growthFactor) {
            this.growthFactor = growthFactor;
        }

        @Override
        public final Builder growthFactor(Float growthFactor) {
            this.growthFactor = growthFactor;
            return this;
        }

        public final String getGrowthType() {
            return this.growthType;
        }

        public final void setGrowthType(String growthType) {
            this.growthType = growthType;
        }

        @Override
        public final Builder growthType(String growthType) {
            this.growthType = growthType;
            return this;
        }

        @Override
        public final Builder growthType(GrowthType growthType) {
            this.growthType(growthType == null ? null : growthType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDeploymentStrategyRequest build() {
            return new UpdateDeploymentStrategyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDeploymentStrategyRequest> {
        public Builder deploymentStrategyId(String var1);

        public Builder description(String var1);

        public Builder deploymentDurationInMinutes(Integer var1);

        public Builder finalBakeTimeInMinutes(Integer var1);

        public Builder growthFactor(Float var1);

        public Builder growthType(String var1);

        public Builder growthType(GrowthType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

