/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appconfig.model.AppConfigRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateHostedConfigurationVersionRequest
extends AppConfigRequest
implements ToCopyableBuilder<Builder, CreateHostedConfigurationVersionRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(CreateHostedConfigurationVersionRequest.getter(CreateHostedConfigurationVersionRequest::applicationId)).setter(CreateHostedConfigurationVersionRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> CONFIGURATION_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationProfileId").getter(CreateHostedConfigurationVersionRequest.getter(CreateHostedConfigurationVersionRequest::configurationProfileId)).setter(CreateHostedConfigurationVersionRequest.setter(Builder::configurationProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConfigurationProfileId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateHostedConfigurationVersionRequest.getter(CreateHostedConfigurationVersionRequest::description)).setter(CreateHostedConfigurationVersionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Description").build()}).build();
    private static final SdkField<SdkBytes> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Content").getter(CreateHostedConfigurationVersionRequest.getter(CreateHostedConfigurationVersionRequest::content)).setter(CreateHostedConfigurationVersionRequest.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(CreateHostedConfigurationVersionRequest.getter(CreateHostedConfigurationVersionRequest::contentType)).setter(CreateHostedConfigurationVersionRequest.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<Integer> LATEST_VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LatestVersionNumber").getter(CreateHostedConfigurationVersionRequest.getter(CreateHostedConfigurationVersionRequest::latestVersionNumber)).setter(CreateHostedConfigurationVersionRequest.setter(Builder::latestVersionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Latest-Version-Number").build()}).build();
    private static final SdkField<String> VERSION_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionLabel").getter(CreateHostedConfigurationVersionRequest.getter(CreateHostedConfigurationVersionRequest::versionLabel)).setter(CreateHostedConfigurationVersionRequest.setter(Builder::versionLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("VersionLabel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, CONFIGURATION_PROFILE_ID_FIELD, DESCRIPTION_FIELD, CONTENT_FIELD, CONTENT_TYPE_FIELD, LATEST_VERSION_NUMBER_FIELD, VERSION_LABEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateHostedConfigurationVersionRequest.memberNameToFieldInitializer();
    private final String applicationId;
    private final String configurationProfileId;
    private final String description;
    private final SdkBytes content;
    private final String contentType;
    private final Integer latestVersionNumber;
    private final String versionLabel;

    private CreateHostedConfigurationVersionRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.configurationProfileId = builder.configurationProfileId;
        this.description = builder.description;
        this.content = builder.content;
        this.contentType = builder.contentType;
        this.latestVersionNumber = builder.latestVersionNumber;
        this.versionLabel = builder.versionLabel;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String configurationProfileId() {
        return this.configurationProfileId;
    }

    public final String description() {
        return this.description;
    }

    public final SdkBytes content() {
        return this.content;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final Integer latestVersionNumber() {
        return this.latestVersionNumber;
    }

    public final String versionLabel() {
        return this.versionLabel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionLabel());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHostedConfigurationVersionRequest)) {
            return false;
        }
        CreateHostedConfigurationVersionRequest other = (CreateHostedConfigurationVersionRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.configurationProfileId(), other.configurationProfileId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.latestVersionNumber(), other.latestVersionNumber()) && Objects.equals(this.versionLabel(), other.versionLabel());
    }

    public final String toString() {
        return ToString.builder((String)"CreateHostedConfigurationVersionRequest").add("ApplicationId", (Object)this.applicationId()).add("ConfigurationProfileId", (Object)this.configurationProfileId()).add("Description", (Object)this.description()).add("Content", (Object)(this.content() == null ? null : "*** Sensitive Data Redacted ***")).add("ContentType", (Object)this.contentType()).add("LatestVersionNumber", (Object)this.latestVersionNumber()).add("VersionLabel", (Object)this.versionLabel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "ConfigurationProfileId": {
                return Optional.ofNullable(clazz.cast(this.configurationProfileId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "LatestVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.latestVersionNumber()));
            }
            case "VersionLabel": {
                return Optional.ofNullable(clazz.cast(this.versionLabel()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("ConfigurationProfileId", CONFIGURATION_PROFILE_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Content", CONTENT_FIELD);
        map.put("Content-Type", CONTENT_TYPE_FIELD);
        map.put("Latest-Version-Number", LATEST_VERSION_NUMBER_FIELD);
        map.put("VersionLabel", VERSION_LABEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateHostedConfigurationVersionRequest, T> g) {
        return obj -> g.apply((CreateHostedConfigurationVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppConfigRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String configurationProfileId;
        private String description;
        private SdkBytes content;
        private String contentType;
        private Integer latestVersionNumber;
        private String versionLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHostedConfigurationVersionRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.configurationProfileId(model.configurationProfileId);
            this.description(model.description);
            this.content(model.content);
            this.contentType(model.contentType);
            this.latestVersionNumber(model.latestVersionNumber);
            this.versionLabel(model.versionLabel);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getConfigurationProfileId() {
            return this.configurationProfileId;
        }

        public final void setConfigurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
        }

        @Override
        public final Builder configurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ByteBuffer getContent() {
            return this.content == null ? null : this.content.asByteBuffer();
        }

        public final void setContent(ByteBuffer content) {
            this.content(content == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)content));
        }

        @Override
        public final Builder content(SdkBytes content) {
            this.content = content;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final Integer getLatestVersionNumber() {
            return this.latestVersionNumber;
        }

        public final void setLatestVersionNumber(Integer latestVersionNumber) {
            this.latestVersionNumber = latestVersionNumber;
        }

        @Override
        public final Builder latestVersionNumber(Integer latestVersionNumber) {
            this.latestVersionNumber = latestVersionNumber;
            return this;
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHostedConfigurationVersionRequest build() {
            return new CreateHostedConfigurationVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateHostedConfigurationVersionRequest> {
        public Builder applicationId(String var1);

        public Builder configurationProfileId(String var1);

        public Builder description(String var1);

        public Builder content(SdkBytes var1);

        public Builder contentType(String var1);

        public Builder latestVersionNumber(Integer var1);

        public Builder versionLabel(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

