/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appconfig.model.AppConfigRequest;
import software.amazon.awssdk.services.appconfig.model.DynamicParameterMapCopier;
import software.amazon.awssdk.services.appconfig.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDeploymentRequest
extends AppConfigRequest
implements ToCopyableBuilder<Builder, StartDeploymentRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(StartDeploymentRequest.getter(StartDeploymentRequest::applicationId)).setter(StartDeploymentRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentId").getter(StartDeploymentRequest.getter(StartDeploymentRequest::environmentId)).setter(StartDeploymentRequest.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("EnvironmentId").build()}).build();
    private static final SdkField<String> DEPLOYMENT_STRATEGY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentStrategyId").getter(StartDeploymentRequest.getter(StartDeploymentRequest::deploymentStrategyId)).setter(StartDeploymentRequest.setter(Builder::deploymentStrategyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStrategyId").build()}).build();
    private static final SdkField<String> CONFIGURATION_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationProfileId").getter(StartDeploymentRequest.getter(StartDeploymentRequest::configurationProfileId)).setter(StartDeploymentRequest.setter(Builder::configurationProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationProfileId").build()}).build();
    private static final SdkField<String> CONFIGURATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationVersion").getter(StartDeploymentRequest.getter(StartDeploymentRequest::configurationVersion)).setter(StartDeploymentRequest.setter(Builder::configurationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationVersion").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(StartDeploymentRequest.getter(StartDeploymentRequest::description)).setter(StartDeploymentRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(StartDeploymentRequest.getter(StartDeploymentRequest::tags)).setter(StartDeploymentRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyIdentifier").getter(StartDeploymentRequest.getter(StartDeploymentRequest::kmsKeyIdentifier)).setter(StartDeploymentRequest.setter(Builder::kmsKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyIdentifier").build()}).build();
    private static final SdkField<Map<String, String>> DYNAMIC_EXTENSION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("DynamicExtensionParameters").getter(StartDeploymentRequest.getter(StartDeploymentRequest::dynamicExtensionParameters)).setter(StartDeploymentRequest.setter(Builder::dynamicExtensionParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamicExtensionParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, ENVIRONMENT_ID_FIELD, DEPLOYMENT_STRATEGY_ID_FIELD, CONFIGURATION_PROFILE_ID_FIELD, CONFIGURATION_VERSION_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, KMS_KEY_IDENTIFIER_FIELD, DYNAMIC_EXTENSION_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartDeploymentRequest.memberNameToFieldInitializer();
    private final String applicationId;
    private final String environmentId;
    private final String deploymentStrategyId;
    private final String configurationProfileId;
    private final String configurationVersion;
    private final String description;
    private final Map<String, String> tags;
    private final String kmsKeyIdentifier;
    private final Map<String, String> dynamicExtensionParameters;

    private StartDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.environmentId = builder.environmentId;
        this.deploymentStrategyId = builder.deploymentStrategyId;
        this.configurationProfileId = builder.configurationProfileId;
        this.configurationVersion = builder.configurationVersion;
        this.description = builder.description;
        this.tags = builder.tags;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
        this.dynamicExtensionParameters = builder.dynamicExtensionParameters;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String deploymentStrategyId() {
        return this.deploymentStrategyId;
    }

    public final String configurationProfileId() {
        return this.configurationProfileId;
    }

    public final String configurationVersion() {
        return this.configurationVersion;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String kmsKeyIdentifier() {
        return this.kmsKeyIdentifier;
    }

    public final boolean hasDynamicExtensionParameters() {
        return this.dynamicExtensionParameters != null && !(this.dynamicExtensionParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> dynamicExtensionParameters() {
        return this.dynamicExtensionParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStrategyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDynamicExtensionParameters() ? this.dynamicExtensionParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDeploymentRequest)) {
            return false;
        }
        StartDeploymentRequest other = (StartDeploymentRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.deploymentStrategyId(), other.deploymentStrategyId()) && Objects.equals(this.configurationProfileId(), other.configurationProfileId()) && Objects.equals(this.configurationVersion(), other.configurationVersion()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.kmsKeyIdentifier(), other.kmsKeyIdentifier()) && this.hasDynamicExtensionParameters() == other.hasDynamicExtensionParameters() && Objects.equals(this.dynamicExtensionParameters(), other.dynamicExtensionParameters());
    }

    public final String toString() {
        return ToString.builder((String)"StartDeploymentRequest").add("ApplicationId", (Object)this.applicationId()).add("EnvironmentId", (Object)this.environmentId()).add("DeploymentStrategyId", (Object)this.deploymentStrategyId()).add("ConfigurationProfileId", (Object)this.configurationProfileId()).add("ConfigurationVersion", (Object)this.configurationVersion()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).add("KmsKeyIdentifier", (Object)this.kmsKeyIdentifier()).add("DynamicExtensionParameters", (Object)(this.dynamicExtensionParameters() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "EnvironmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "DeploymentStrategyId": {
                return Optional.ofNullable(clazz.cast(this.deploymentStrategyId()));
            }
            case "ConfigurationProfileId": {
                return Optional.ofNullable(clazz.cast(this.configurationProfileId()));
            }
            case "ConfigurationVersion": {
                return Optional.ofNullable(clazz.cast(this.configurationVersion()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "KmsKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyIdentifier()));
            }
            case "DynamicExtensionParameters": {
                return Optional.ofNullable(clazz.cast(this.dynamicExtensionParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("EnvironmentId", ENVIRONMENT_ID_FIELD);
        map.put("DeploymentStrategyId", DEPLOYMENT_STRATEGY_ID_FIELD);
        map.put("ConfigurationProfileId", CONFIGURATION_PROFILE_ID_FIELD);
        map.put("ConfigurationVersion", CONFIGURATION_VERSION_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("KmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
        map.put("DynamicExtensionParameters", DYNAMIC_EXTENSION_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDeploymentRequest, T> g) {
        return obj -> g.apply((StartDeploymentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppConfigRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String environmentId;
        private String deploymentStrategyId;
        private String configurationProfileId;
        private String configurationVersion;
        private String description;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String kmsKeyIdentifier;
        private Map<String, String> dynamicExtensionParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartDeploymentRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.environmentId(model.environmentId);
            this.deploymentStrategyId(model.deploymentStrategyId);
            this.configurationProfileId(model.configurationProfileId);
            this.configurationVersion(model.configurationVersion);
            this.description(model.description);
            this.tags(model.tags);
            this.kmsKeyIdentifier(model.kmsKeyIdentifier);
            this.dynamicExtensionParameters(model.dynamicExtensionParameters);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getDeploymentStrategyId() {
            return this.deploymentStrategyId;
        }

        public final void setDeploymentStrategyId(String deploymentStrategyId) {
            this.deploymentStrategyId = deploymentStrategyId;
        }

        @Override
        public final Builder deploymentStrategyId(String deploymentStrategyId) {
            this.deploymentStrategyId = deploymentStrategyId;
            return this;
        }

        public final String getConfigurationProfileId() {
            return this.configurationProfileId;
        }

        public final void setConfigurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
        }

        @Override
        public final Builder configurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
            return this;
        }

        public final String getConfigurationVersion() {
            return this.configurationVersion;
        }

        public final void setConfigurationVersion(String configurationVersion) {
            this.configurationVersion = configurationVersion;
        }

        @Override
        public final Builder configurationVersion(String configurationVersion) {
            this.configurationVersion = configurationVersion;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return this.kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        public final Map<String, String> getDynamicExtensionParameters() {
            if (this.dynamicExtensionParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.dynamicExtensionParameters;
        }

        public final void setDynamicExtensionParameters(Map<String, String> dynamicExtensionParameters) {
            this.dynamicExtensionParameters = DynamicParameterMapCopier.copy(dynamicExtensionParameters);
        }

        @Override
        public final Builder dynamicExtensionParameters(Map<String, String> dynamicExtensionParameters) {
            this.dynamicExtensionParameters = DynamicParameterMapCopier.copy(dynamicExtensionParameters);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDeploymentRequest build() {
            return new StartDeploymentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDeploymentRequest> {
        public Builder applicationId(String var1);

        public Builder environmentId(String var1);

        public Builder deploymentStrategyId(String var1);

        public Builder configurationProfileId(String var1);

        public Builder configurationVersion(String var1);

        public Builder description(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder kmsKeyIdentifier(String var1);

        public Builder dynamicExtensionParameters(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

