/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appconfig.model.AppConfigResponse;
import software.amazon.awssdk.services.appconfig.model.Validator;
import software.amazon.awssdk.services.appconfig.model.ValidatorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConfigurationProfileResponse
extends AppConfigResponse
implements ToCopyableBuilder<Builder, CreateConfigurationProfileResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(CreateConfigurationProfileResponse.getter(CreateConfigurationProfileResponse::applicationId)).setter(CreateConfigurationProfileResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CreateConfigurationProfileResponse.getter(CreateConfigurationProfileResponse::id)).setter(CreateConfigurationProfileResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateConfigurationProfileResponse.getter(CreateConfigurationProfileResponse::name)).setter(CreateConfigurationProfileResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateConfigurationProfileResponse.getter(CreateConfigurationProfileResponse::description)).setter(CreateConfigurationProfileResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationUri").getter(CreateConfigurationProfileResponse.getter(CreateConfigurationProfileResponse::locationUri)).setter(CreateConfigurationProfileResponse.setter(Builder::locationUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()}).build();
    private static final SdkField<String> RETRIEVAL_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RetrievalRoleArn").getter(CreateConfigurationProfileResponse.getter(CreateConfigurationProfileResponse::retrievalRoleArn)).setter(CreateConfigurationProfileResponse.setter(Builder::retrievalRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrievalRoleArn").build()}).build();
    private static final SdkField<List<Validator>> VALIDATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Validators").getter(CreateConfigurationProfileResponse.getter(CreateConfigurationProfileResponse::validators)).setter(CreateConfigurationProfileResponse.setter(Builder::validators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Validator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CreateConfigurationProfileResponse.getter(CreateConfigurationProfileResponse::type)).setter(CreateConfigurationProfileResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(CreateConfigurationProfileResponse.getter(CreateConfigurationProfileResponse::kmsKeyArn)).setter(CreateConfigurationProfileResponse.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyIdentifier").getter(CreateConfigurationProfileResponse.getter(CreateConfigurationProfileResponse::kmsKeyIdentifier)).setter(CreateConfigurationProfileResponse.setter(Builder::kmsKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, LOCATION_URI_FIELD, RETRIEVAL_ROLE_ARN_FIELD, VALIDATORS_FIELD, TYPE_FIELD, KMS_KEY_ARN_FIELD, KMS_KEY_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ApplicationId", APPLICATION_ID_FIELD);
            this.put("Id", ID_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("LocationUri", LOCATION_URI_FIELD);
            this.put("RetrievalRoleArn", RETRIEVAL_ROLE_ARN_FIELD);
            this.put("Validators", VALIDATORS_FIELD);
            this.put("Type", TYPE_FIELD);
            this.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
            this.put("KmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
        }
    });
    private final String applicationId;
    private final String id;
    private final String name;
    private final String description;
    private final String locationUri;
    private final String retrievalRoleArn;
    private final List<Validator> validators;
    private final String type;
    private final String kmsKeyArn;
    private final String kmsKeyIdentifier;

    private CreateConfigurationProfileResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.locationUri = builder.locationUri;
        this.retrievalRoleArn = builder.retrievalRoleArn;
        this.validators = builder.validators;
        this.type = builder.type;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String locationUri() {
        return this.locationUri;
    }

    public final String retrievalRoleArn() {
        return this.retrievalRoleArn;
    }

    public final boolean hasValidators() {
        return this.validators != null && !(this.validators instanceof SdkAutoConstructList);
    }

    public final List<Validator> validators() {
        return this.validators;
    }

    public final String type() {
        return this.type;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final String kmsKeyIdentifier() {
        return this.kmsKeyIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrievalRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidators() ? this.validators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationProfileResponse)) {
            return false;
        }
        CreateConfigurationProfileResponse other = (CreateConfigurationProfileResponse)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.locationUri(), other.locationUri()) && Objects.equals(this.retrievalRoleArn(), other.retrievalRoleArn()) && this.hasValidators() == other.hasValidators() && Objects.equals(this.validators(), other.validators()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.kmsKeyIdentifier(), other.kmsKeyIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConfigurationProfileResponse").add("ApplicationId", (Object)this.applicationId()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("LocationUri", (Object)this.locationUri()).add("RetrievalRoleArn", (Object)this.retrievalRoleArn()).add("Validators", this.hasValidators() ? this.validators() : null).add("Type", (Object)this.type()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("KmsKeyIdentifier", (Object)this.kmsKeyIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LocationUri": {
                return Optional.ofNullable(clazz.cast(this.locationUri()));
            }
            case "RetrievalRoleArn": {
                return Optional.ofNullable(clazz.cast(this.retrievalRoleArn()));
            }
            case "Validators": {
                return Optional.ofNullable(clazz.cast(this.validators()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "KmsKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateConfigurationProfileResponse, T> g) {
        return obj -> g.apply((CreateConfigurationProfileResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppConfigResponse.BuilderImpl
    implements Builder {
        private String applicationId;
        private String id;
        private String name;
        private String description;
        private String locationUri;
        private String retrievalRoleArn;
        private List<Validator> validators = DefaultSdkAutoConstructList.getInstance();
        private String type;
        private String kmsKeyArn;
        private String kmsKeyIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigurationProfileResponse model) {
            super(model);
            this.applicationId(model.applicationId);
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.locationUri(model.locationUri);
            this.retrievalRoleArn(model.retrievalRoleArn);
            this.validators(model.validators);
            this.type(model.type);
            this.kmsKeyArn(model.kmsKeyArn);
            this.kmsKeyIdentifier(model.kmsKeyIdentifier);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getLocationUri() {
            return this.locationUri;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        @Override
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final String getRetrievalRoleArn() {
            return this.retrievalRoleArn;
        }

        public final void setRetrievalRoleArn(String retrievalRoleArn) {
            this.retrievalRoleArn = retrievalRoleArn;
        }

        @Override
        public final Builder retrievalRoleArn(String retrievalRoleArn) {
            this.retrievalRoleArn = retrievalRoleArn;
            return this;
        }

        public final List<Validator.Builder> getValidators() {
            List<Validator.Builder> result = ValidatorListCopier.copyToBuilder(this.validators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidators(Collection<Validator.BuilderImpl> validators) {
            this.validators = ValidatorListCopier.copyFromBuilder(validators);
        }

        @Override
        public final Builder validators(Collection<Validator> validators) {
            this.validators = ValidatorListCopier.copy(validators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validators(Validator ... validators) {
            this.validators(Arrays.asList(validators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validators(Consumer<Validator.Builder> ... validators) {
            this.validators(Stream.of(validators).map(c -> (Validator)((Validator.Builder)Validator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return this.kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        @Override
        public CreateConfigurationProfileResponse build() {
            return new CreateConfigurationProfileResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConfigurationProfileResponse> {
        public Builder applicationId(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder locationUri(String var1);

        public Builder retrievalRoleArn(String var1);

        public Builder validators(Collection<Validator> var1);

        public Builder validators(Validator ... var1);

        public Builder validators(Consumer<Validator.Builder> ... var1);

        public Builder type(String var1);

        public Builder kmsKeyArn(String var1);

        public Builder kmsKeyIdentifier(String var1);
    }
}

