/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appconfig.model.InvalidConfigurationDetail;
import software.amazon.awssdk.services.appconfig.model.InvalidConfigurationDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BadRequestDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BadRequestDetails> {
    private static final SdkField<List<InvalidConfigurationDetail>> INVALID_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InvalidConfiguration").getter(BadRequestDetails.getter(BadRequestDetails::invalidConfiguration)).setter(BadRequestDetails.setter(Builder::invalidConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidConfiguration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InvalidConfigurationDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVALID_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<InvalidConfigurationDetail> invalidConfiguration;
    private final Type type;

    private BadRequestDetails(BuilderImpl builder) {
        this.invalidConfiguration = builder.invalidConfiguration;
        this.type = builder.type;
    }

    public final boolean hasInvalidConfiguration() {
        return this.invalidConfiguration != null && !(this.invalidConfiguration instanceof SdkAutoConstructList);
    }

    public final List<InvalidConfigurationDetail> invalidConfiguration() {
        return this.invalidConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInvalidConfiguration() ? this.invalidConfiguration() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BadRequestDetails)) {
            return false;
        }
        BadRequestDetails other = (BadRequestDetails)obj;
        return this.hasInvalidConfiguration() == other.hasInvalidConfiguration() && Objects.equals(this.invalidConfiguration(), other.invalidConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"BadRequestDetails").add("InvalidConfiguration", this.hasInvalidConfiguration() ? this.invalidConfiguration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InvalidConfiguration": {
                return Optional.ofNullable(clazz.cast(this.invalidConfiguration()));
            }
        }
        return Optional.empty();
    }

    public static BadRequestDetails fromInvalidConfiguration(List<InvalidConfigurationDetail> invalidConfiguration) {
        return (BadRequestDetails)BadRequestDetails.builder().invalidConfiguration(invalidConfiguration).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BadRequestDetails, T> g) {
        return obj -> g.apply((BadRequestDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        INVALID_CONFIGURATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<InvalidConfigurationDetail> invalidConfiguration = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(BadRequestDetails model) {
            this.invalidConfiguration(model.invalidConfiguration);
        }

        public final List<InvalidConfigurationDetail.Builder> getInvalidConfiguration() {
            List<InvalidConfigurationDetail.Builder> result = InvalidConfigurationDetailListCopier.copyToBuilder(this.invalidConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvalidConfiguration(Collection<InvalidConfigurationDetail.BuilderImpl> invalidConfiguration) {
            List<InvalidConfigurationDetail> oldValue = this.invalidConfiguration;
            this.invalidConfiguration = InvalidConfigurationDetailListCopier.copyFromBuilder(invalidConfiguration);
            this.handleUnionValueChange(Type.INVALID_CONFIGURATION, oldValue, this.invalidConfiguration);
        }

        @Override
        @Transient
        public final Builder invalidConfiguration(Collection<InvalidConfigurationDetail> invalidConfiguration) {
            List<InvalidConfigurationDetail> oldValue = this.invalidConfiguration;
            this.invalidConfiguration = InvalidConfigurationDetailListCopier.copy(invalidConfiguration);
            this.handleUnionValueChange(Type.INVALID_CONFIGURATION, oldValue, this.invalidConfiguration);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder invalidConfiguration(InvalidConfigurationDetail ... invalidConfiguration) {
            this.invalidConfiguration(Arrays.asList(invalidConfiguration));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder invalidConfiguration(Consumer<InvalidConfigurationDetail.Builder> ... invalidConfiguration) {
            this.invalidConfiguration(Stream.of(invalidConfiguration).map(c -> (InvalidConfigurationDetail)((InvalidConfigurationDetail.Builder)InvalidConfigurationDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public BadRequestDetails build() {
            return new BadRequestDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BadRequestDetails> {
        public Builder invalidConfiguration(Collection<InvalidConfigurationDetail> var1);

        public Builder invalidConfiguration(InvalidConfigurationDetail ... var1);

        public Builder invalidConfiguration(Consumer<InvalidConfigurationDetail.Builder> ... var1);
    }
}

