/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appconfig.model.AppConfigRequest;
import software.amazon.awssdk.services.appconfig.model.Validator;
import software.amazon.awssdk.services.appconfig.model.ValidatorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateConfigurationProfileRequest
extends AppConfigRequest
implements ToCopyableBuilder<Builder, UpdateConfigurationProfileRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(UpdateConfigurationProfileRequest.getter(UpdateConfigurationProfileRequest::applicationId)).setter(UpdateConfigurationProfileRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> CONFIGURATION_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationProfileId").getter(UpdateConfigurationProfileRequest.getter(UpdateConfigurationProfileRequest::configurationProfileId)).setter(UpdateConfigurationProfileRequest.setter(Builder::configurationProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConfigurationProfileId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateConfigurationProfileRequest.getter(UpdateConfigurationProfileRequest::name)).setter(UpdateConfigurationProfileRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateConfigurationProfileRequest.getter(UpdateConfigurationProfileRequest::description)).setter(UpdateConfigurationProfileRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> RETRIEVAL_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RetrievalRoleArn").getter(UpdateConfigurationProfileRequest.getter(UpdateConfigurationProfileRequest::retrievalRoleArn)).setter(UpdateConfigurationProfileRequest.setter(Builder::retrievalRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrievalRoleArn").build()}).build();
    private static final SdkField<List<Validator>> VALIDATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Validators").getter(UpdateConfigurationProfileRequest.getter(UpdateConfigurationProfileRequest::validators)).setter(UpdateConfigurationProfileRequest.setter(Builder::validators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Validator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, CONFIGURATION_PROFILE_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, RETRIEVAL_ROLE_ARN_FIELD, VALIDATORS_FIELD));
    private final String applicationId;
    private final String configurationProfileId;
    private final String name;
    private final String description;
    private final String retrievalRoleArn;
    private final List<Validator> validators;

    private UpdateConfigurationProfileRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.configurationProfileId = builder.configurationProfileId;
        this.name = builder.name;
        this.description = builder.description;
        this.retrievalRoleArn = builder.retrievalRoleArn;
        this.validators = builder.validators;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String configurationProfileId() {
        return this.configurationProfileId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String retrievalRoleArn() {
        return this.retrievalRoleArn;
    }

    public boolean hasValidators() {
        return this.validators != null && !(this.validators instanceof SdkAutoConstructList);
    }

    public List<Validator> validators() {
        return this.validators;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrievalRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidators() ? this.validators() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigurationProfileRequest)) {
            return false;
        }
        UpdateConfigurationProfileRequest other = (UpdateConfigurationProfileRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.configurationProfileId(), other.configurationProfileId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.retrievalRoleArn(), other.retrievalRoleArn()) && this.hasValidators() == other.hasValidators() && Objects.equals(this.validators(), other.validators());
    }

    public String toString() {
        return ToString.builder((String)"UpdateConfigurationProfileRequest").add("ApplicationId", (Object)this.applicationId()).add("ConfigurationProfileId", (Object)this.configurationProfileId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("RetrievalRoleArn", (Object)this.retrievalRoleArn()).add("Validators", this.hasValidators() ? this.validators() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "ConfigurationProfileId": {
                return Optional.ofNullable(clazz.cast(this.configurationProfileId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RetrievalRoleArn": {
                return Optional.ofNullable(clazz.cast(this.retrievalRoleArn()));
            }
            case "Validators": {
                return Optional.ofNullable(clazz.cast(this.validators()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConfigurationProfileRequest, T> g) {
        return obj -> g.apply((UpdateConfigurationProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppConfigRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String configurationProfileId;
        private String name;
        private String description;
        private String retrievalRoleArn;
        private List<Validator> validators = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfigurationProfileRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.configurationProfileId(model.configurationProfileId);
            this.name(model.name);
            this.description(model.description);
            this.retrievalRoleArn(model.retrievalRoleArn);
            this.validators(model.validators);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getConfigurationProfileId() {
            return this.configurationProfileId;
        }

        @Override
        public final Builder configurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
            return this;
        }

        public final void setConfigurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getRetrievalRoleArn() {
            return this.retrievalRoleArn;
        }

        @Override
        public final Builder retrievalRoleArn(String retrievalRoleArn) {
            this.retrievalRoleArn = retrievalRoleArn;
            return this;
        }

        public final void setRetrievalRoleArn(String retrievalRoleArn) {
            this.retrievalRoleArn = retrievalRoleArn;
        }

        public final Collection<Validator.Builder> getValidators() {
            if (this.validators instanceof SdkAutoConstructList) {
                return null;
            }
            return this.validators != null ? (Collection)this.validators.stream().map(Validator::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validators(Collection<Validator> validators) {
            this.validators = ValidatorListCopier.copy(validators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validators(Validator ... validators) {
            this.validators(Arrays.asList(validators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validators(Consumer<Validator.Builder> ... validators) {
            this.validators(Stream.of(validators).map(c -> (Validator)((Validator.Builder)Validator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setValidators(Collection<Validator.BuilderImpl> validators) {
            this.validators = ValidatorListCopier.copyFromBuilder(validators);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConfigurationProfileRequest build() {
            return new UpdateConfigurationProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateConfigurationProfileRequest> {
        public Builder applicationId(String var1);

        public Builder configurationProfileId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder retrievalRoleArn(String var1);

        public Builder validators(Collection<Validator> var1);

        public Builder validators(Validator ... var1);

        public Builder validators(Consumer<Validator.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

