/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConfigurationRequest extends AppConfigRequest implements
        ToCopyableBuilder<GetConfigurationRequest.Builder, GetConfigurationRequest> {
    private static final SdkField<String> APPLICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetConfigurationRequest::application)).setter(setter(Builder::application))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Application").build()).build();

    private static final SdkField<String> ENVIRONMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetConfigurationRequest::environment)).setter(setter(Builder::environment))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Environment").build()).build();

    private static final SdkField<String> CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetConfigurationRequest::configuration)).setter(setter(Builder::configuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Configuration").build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetConfigurationRequest::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("client_id").build()).build();

    private static final SdkField<String> CLIENT_CONFIGURATION_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetConfigurationRequest::clientConfigurationVersion))
            .setter(setter(Builder::clientConfigurationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("client_configuration_version")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FIELD,
            ENVIRONMENT_FIELD, CONFIGURATION_FIELD, CLIENT_ID_FIELD, CLIENT_CONFIGURATION_VERSION_FIELD));

    private final String application;

    private final String environment;

    private final String configuration;

    private final String clientId;

    private final String clientConfigurationVersion;

    private GetConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.application = builder.application;
        this.environment = builder.environment;
        this.configuration = builder.configuration;
        this.clientId = builder.clientId;
        this.clientConfigurationVersion = builder.clientConfigurationVersion;
    }

    /**
     * <p>
     * The application to get. Specify either the application name or the application ID.
     * </p>
     * 
     * @return The application to get. Specify either the application name or the application ID.
     */
    public String application() {
        return application;
    }

    /**
     * <p>
     * The environment to get. Specify either the environment name or the environment ID.
     * </p>
     * 
     * @return The environment to get. Specify either the environment name or the environment ID.
     */
    public String environment() {
        return environment;
    }

    /**
     * <p>
     * The configuration to get. Specify either the configuration name or the configuration ID.
     * </p>
     * 
     * @return The configuration to get. Specify either the configuration name or the configuration ID.
     */
    public String configuration() {
        return configuration;
    }

    /**
     * <p>
     * A unique ID to identify the client for the configuration. This ID enables AppConfig to deploy the configuration
     * in intervals, as defined in the deployment strategy.
     * </p>
     * 
     * @return A unique ID to identify the client for the configuration. This ID enables AppConfig to deploy the
     *         configuration in intervals, as defined in the deployment strategy.
     */
    public String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The configuration version returned in the most recent <code>GetConfiguration</code> response.
     * </p>
     * <important>
     * <p>
     * AWS AppConfig uses the value of the <code>ClientConfigurationVersion</code> parameter to identify the
     * configuration version on your clients. If you don’t send <code>ClientConfigurationVersion</code> with each call
     * to <code>GetConfiguration</code>, your clients receive the current configuration. You are charged each time your
     * clients receive a configuration.
     * </p>
     * <p>
     * To avoid excess charges, we recommend that you include the <code>ClientConfigurationVersion</code> value with
     * every call to <code>GetConfiguration</code>. This value must be saved on your client. Subsequent calls to
     * <code>GetConfiguration</code> must pass this value by using the <code>ClientConfigurationVersion</code>
     * parameter.
     * </p>
     * </important>
     * <p>
     * For more information about working with configurations, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/appconfig-retrieving-the-configuration.html"
     * >Retrieving the Configuration</a> in the <i>AWS AppConfig User Guide</i>.
     * </p>
     * 
     * @return The configuration version returned in the most recent <code>GetConfiguration</code> response.</p>
     *         <important>
     *         <p>
     *         AWS AppConfig uses the value of the <code>ClientConfigurationVersion</code> parameter to identify the
     *         configuration version on your clients. If you don’t send <code>ClientConfigurationVersion</code> with
     *         each call to <code>GetConfiguration</code>, your clients receive the current configuration. You are
     *         charged each time your clients receive a configuration.
     *         </p>
     *         <p>
     *         To avoid excess charges, we recommend that you include the <code>ClientConfigurationVersion</code> value
     *         with every call to <code>GetConfiguration</code>. This value must be saved on your client. Subsequent
     *         calls to <code>GetConfiguration</code> must pass this value by using the
     *         <code>ClientConfigurationVersion</code> parameter.
     *         </p>
     *         </important>
     *         <p>
     *         For more information about working with configurations, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/appconfig-retrieving-the-configuration.html"
     *         >Retrieving the Configuration</a> in the <i>AWS AppConfig User Guide</i>.
     */
    public String clientConfigurationVersion() {
        return clientConfigurationVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(application());
        hashCode = 31 * hashCode + Objects.hashCode(environment());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(clientConfigurationVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigurationRequest)) {
            return false;
        }
        GetConfigurationRequest other = (GetConfigurationRequest) obj;
        return Objects.equals(application(), other.application()) && Objects.equals(environment(), other.environment())
                && Objects.equals(configuration(), other.configuration()) && Objects.equals(clientId(), other.clientId())
                && Objects.equals(clientConfigurationVersion(), other.clientConfigurationVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetConfigurationRequest").add("Application", application()).add("Environment", environment())
                .add("Configuration", configuration()).add("ClientId", clientId())
                .add("ClientConfigurationVersion", clientConfigurationVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Application":
            return Optional.ofNullable(clazz.cast(application()));
        case "Environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "ClientConfigurationVersion":
            return Optional.ofNullable(clazz.cast(clientConfigurationVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConfigurationRequest, T> g) {
        return obj -> g.apply((GetConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetConfigurationRequest> {
        /**
         * <p>
         * The application to get. Specify either the application name or the application ID.
         * </p>
         * 
         * @param application
         *        The application to get. Specify either the application name or the application ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder application(String application);

        /**
         * <p>
         * The environment to get. Specify either the environment name or the environment ID.
         * </p>
         * 
         * @param environment
         *        The environment to get. Specify either the environment name or the environment ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(String environment);

        /**
         * <p>
         * The configuration to get. Specify either the configuration name or the configuration ID.
         * </p>
         * 
         * @param configuration
         *        The configuration to get. Specify either the configuration name or the configuration ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(String configuration);

        /**
         * <p>
         * A unique ID to identify the client for the configuration. This ID enables AppConfig to deploy the
         * configuration in intervals, as defined in the deployment strategy.
         * </p>
         * 
         * @param clientId
         *        A unique ID to identify the client for the configuration. This ID enables AppConfig to deploy the
         *        configuration in intervals, as defined in the deployment strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The configuration version returned in the most recent <code>GetConfiguration</code> response.
         * </p>
         * <important>
         * <p>
         * AWS AppConfig uses the value of the <code>ClientConfigurationVersion</code> parameter to identify the
         * configuration version on your clients. If you don’t send <code>ClientConfigurationVersion</code> with each
         * call to <code>GetConfiguration</code>, your clients receive the current configuration. You are charged each
         * time your clients receive a configuration.
         * </p>
         * <p>
         * To avoid excess charges, we recommend that you include the <code>ClientConfigurationVersion</code> value with
         * every call to <code>GetConfiguration</code>. This value must be saved on your client. Subsequent calls to
         * <code>GetConfiguration</code> must pass this value by using the <code>ClientConfigurationVersion</code>
         * parameter.
         * </p>
         * </important>
         * <p>
         * For more information about working with configurations, see <a href=
         * "https://docs.aws.amazon.com/systems-manager/latest/userguide/appconfig-retrieving-the-configuration.html"
         * >Retrieving the Configuration</a> in the <i>AWS AppConfig User Guide</i>.
         * </p>
         * 
         * @param clientConfigurationVersion
         *        The configuration version returned in the most recent <code>GetConfiguration</code> response.</p>
         *        <important>
         *        <p>
         *        AWS AppConfig uses the value of the <code>ClientConfigurationVersion</code> parameter to identify the
         *        configuration version on your clients. If you don’t send <code>ClientConfigurationVersion</code> with
         *        each call to <code>GetConfiguration</code>, your clients receive the current configuration. You are
         *        charged each time your clients receive a configuration.
         *        </p>
         *        <p>
         *        To avoid excess charges, we recommend that you include the <code>ClientConfigurationVersion</code>
         *        value with every call to <code>GetConfiguration</code>. This value must be saved on your client.
         *        Subsequent calls to <code>GetConfiguration</code> must pass this value by using the
         *        <code>ClientConfigurationVersion</code> parameter.
         *        </p>
         *        </important>
         *        <p>
         *        For more information about working with configurations, see <a href=
         *        "https://docs.aws.amazon.com/systems-manager/latest/userguide/appconfig-retrieving-the-configuration.html"
         *        >Retrieving the Configuration</a> in the <i>AWS AppConfig User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientConfigurationVersion(String clientConfigurationVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppConfigRequest.BuilderImpl implements Builder {
        private String application;

        private String environment;

        private String configuration;

        private String clientId;

        private String clientConfigurationVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigurationRequest model) {
            super(model);
            application(model.application);
            environment(model.environment);
            configuration(model.configuration);
            clientId(model.clientId);
            clientConfigurationVersion(model.clientConfigurationVersion);
        }

        public final String getApplication() {
            return application;
        }

        @Override
        public final Builder application(String application) {
            this.application = application;
            return this;
        }

        public final void setApplication(String application) {
            this.application = application;
        }

        public final String getEnvironment() {
            return environment;
        }

        @Override
        public final Builder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public final void setEnvironment(String environment) {
            this.environment = environment;
        }

        public final String getConfiguration() {
            return configuration;
        }

        @Override
        public final Builder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(String configuration) {
            this.configuration = configuration;
        }

        public final String getClientId() {
            return clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getClientConfigurationVersion() {
            return clientConfigurationVersion;
        }

        @Override
        public final Builder clientConfigurationVersion(String clientConfigurationVersion) {
            this.clientConfigurationVersion = clientConfigurationVersion;
            return this;
        }

        public final void setClientConfigurationVersion(String clientConfigurationVersion) {
            this.clientConfigurationVersion = clientConfigurationVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetConfigurationRequest build() {
            return new GetConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
