/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appconfig.AppConfigClient;
import software.amazon.awssdk.services.appconfig.model.ListDeploymentsRequest;
import software.amazon.awssdk.services.appconfig.model.ListDeploymentsResponse;

public class ListDeploymentsIterable
implements SdkIterable<ListDeploymentsResponse> {
    private final AppConfigClient client;
    private final ListDeploymentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDeploymentsIterable(AppConfigClient client, ListDeploymentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDeploymentsResponseFetcher();
    }

    public Iterator<ListDeploymentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDeploymentsResponseFetcher
    implements SyncPageFetcher<ListDeploymentsResponse> {
        private ListDeploymentsResponseFetcher() {
        }

        public boolean hasNextPage(ListDeploymentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDeploymentsResponse nextPage(ListDeploymentsResponse previousPage) {
            if (previousPage == null) {
                return ListDeploymentsIterable.this.client.listDeployments(ListDeploymentsIterable.this.firstRequest);
            }
            return ListDeploymentsIterable.this.client.listDeployments((ListDeploymentsRequest)((Object)ListDeploymentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

