/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Request;
import software.amazon.awssdk.services.apigatewayv2.model.ProtocolType;
import software.amazon.awssdk.services.apigatewayv2.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApiRequest
extends ApiGatewayV2Request
implements ToCopyableBuilder<Builder, CreateApiRequest> {
    private static final SdkField<String> API_KEY_SELECTION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApiRequest.getter(CreateApiRequest::apiKeySelectionExpression)).setter(CreateApiRequest.setter(Builder::apiKeySelectionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeySelectionExpression").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApiRequest.getter(CreateApiRequest::description)).setter(CreateApiRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> DISABLE_SCHEMA_VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateApiRequest.getter(CreateApiRequest::disableSchemaValidation)).setter(CreateApiRequest.setter(Builder::disableSchemaValidation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableSchemaValidation").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApiRequest.getter(CreateApiRequest::name)).setter(CreateApiRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PROTOCOL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApiRequest.getter(CreateApiRequest::protocolTypeAsString)).setter(CreateApiRequest.setter(Builder::protocolType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolType").build()}).build();
    private static final SdkField<String> ROUTE_SELECTION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApiRequest.getter(CreateApiRequest::routeSelectionExpression)).setter(CreateApiRequest.setter(Builder::routeSelectionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeSelectionExpression").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApiRequest.getter(CreateApiRequest::version)).setter(CreateApiRequest.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateApiRequest.getter(CreateApiRequest::tags)).setter(CreateApiRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_KEY_SELECTION_EXPRESSION_FIELD, DESCRIPTION_FIELD, DISABLE_SCHEMA_VALIDATION_FIELD, NAME_FIELD, PROTOCOL_TYPE_FIELD, ROUTE_SELECTION_EXPRESSION_FIELD, VERSION_FIELD, TAGS_FIELD));
    private final String apiKeySelectionExpression;
    private final String description;
    private final Boolean disableSchemaValidation;
    private final String name;
    private final String protocolType;
    private final String routeSelectionExpression;
    private final String version;
    private final Map<String, String> tags;

    private CreateApiRequest(BuilderImpl builder) {
        super(builder);
        this.apiKeySelectionExpression = builder.apiKeySelectionExpression;
        this.description = builder.description;
        this.disableSchemaValidation = builder.disableSchemaValidation;
        this.name = builder.name;
        this.protocolType = builder.protocolType;
        this.routeSelectionExpression = builder.routeSelectionExpression;
        this.version = builder.version;
        this.tags = builder.tags;
    }

    public String apiKeySelectionExpression() {
        return this.apiKeySelectionExpression;
    }

    public String description() {
        return this.description;
    }

    public Boolean disableSchemaValidation() {
        return this.disableSchemaValidation;
    }

    public String name() {
        return this.name;
    }

    public ProtocolType protocolType() {
        return ProtocolType.fromValue(this.protocolType);
    }

    public String protocolTypeAsString() {
        return this.protocolType;
    }

    public String routeSelectionExpression() {
        return this.routeSelectionExpression;
    }

    public String version() {
        return this.version;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKeySelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableSchemaValidation());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApiRequest)) {
            return false;
        }
        CreateApiRequest other = (CreateApiRequest)((Object)obj);
        return Objects.equals(this.apiKeySelectionExpression(), other.apiKeySelectionExpression()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.disableSchemaValidation(), other.disableSchemaValidation()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.protocolTypeAsString(), other.protocolTypeAsString()) && Objects.equals(this.routeSelectionExpression(), other.routeSelectionExpression()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateApiRequest").add("ApiKeySelectionExpression", (Object)this.apiKeySelectionExpression()).add("Description", (Object)this.description()).add("DisableSchemaValidation", (Object)this.disableSchemaValidation()).add("Name", (Object)this.name()).add("ProtocolType", (Object)this.protocolTypeAsString()).add("RouteSelectionExpression", (Object)this.routeSelectionExpression()).add("Version", (Object)this.version()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiKeySelectionExpression": {
                return Optional.ofNullable(clazz.cast(this.apiKeySelectionExpression()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DisableSchemaValidation": {
                return Optional.ofNullable(clazz.cast(this.disableSchemaValidation()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ProtocolType": {
                return Optional.ofNullable(clazz.cast(this.protocolTypeAsString()));
            }
            case "RouteSelectionExpression": {
                return Optional.ofNullable(clazz.cast(this.routeSelectionExpression()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApiRequest, T> g) {
        return obj -> g.apply((CreateApiRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Request.BuilderImpl
    implements Builder {
        private String apiKeySelectionExpression;
        private String description;
        private Boolean disableSchemaValidation;
        private String name;
        private String protocolType;
        private String routeSelectionExpression;
        private String version;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApiRequest model) {
            super(model);
            this.apiKeySelectionExpression(model.apiKeySelectionExpression);
            this.description(model.description);
            this.disableSchemaValidation(model.disableSchemaValidation);
            this.name(model.name);
            this.protocolType(model.protocolType);
            this.routeSelectionExpression(model.routeSelectionExpression);
            this.version(model.version);
            this.tags(model.tags);
        }

        public final String getApiKeySelectionExpression() {
            return this.apiKeySelectionExpression;
        }

        @Override
        public final Builder apiKeySelectionExpression(String apiKeySelectionExpression) {
            this.apiKeySelectionExpression = apiKeySelectionExpression;
            return this;
        }

        public final void setApiKeySelectionExpression(String apiKeySelectionExpression) {
            this.apiKeySelectionExpression = apiKeySelectionExpression;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getDisableSchemaValidation() {
            return this.disableSchemaValidation;
        }

        @Override
        public final Builder disableSchemaValidation(Boolean disableSchemaValidation) {
            this.disableSchemaValidation = disableSchemaValidation;
            return this;
        }

        public final void setDisableSchemaValidation(Boolean disableSchemaValidation) {
            this.disableSchemaValidation = disableSchemaValidation;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getProtocolTypeAsString() {
            return this.protocolType;
        }

        @Override
        public final Builder protocolType(String protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        @Override
        public final Builder protocolType(ProtocolType protocolType) {
            this.protocolType(protocolType.toString());
            return this;
        }

        public final void setProtocolType(String protocolType) {
            this.protocolType = protocolType;
        }

        public final String getRouteSelectionExpression() {
            return this.routeSelectionExpression;
        }

        @Override
        public final Builder routeSelectionExpression(String routeSelectionExpression) {
            this.routeSelectionExpression = routeSelectionExpression;
            return this;
        }

        public final void setRouteSelectionExpression(String routeSelectionExpression) {
            this.routeSelectionExpression = routeSelectionExpression;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApiRequest build() {
            return new CreateApiRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApiRequest> {
        public Builder apiKeySelectionExpression(String var1);

        public Builder description(String var1);

        public Builder disableSchemaValidation(Boolean var1);

        public Builder name(String var1);

        public Builder protocolType(String var1);

        public Builder protocolType(ProtocolType var1);

        public Builder routeSelectionExpression(String var1);

        public Builder version(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

