/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Request;
import software.amazon.awssdk.services.apigatewayv2.model.DisplayContent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProductPageRequest
extends ApiGatewayV2Request
implements ToCopyableBuilder<Builder, UpdateProductPageRequest> {
    private static final SdkField<DisplayContent> DISPLAY_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DisplayContent").getter(UpdateProductPageRequest.getter(UpdateProductPageRequest::displayContent)).setter(UpdateProductPageRequest.setter(Builder::displayContent)).constructor(DisplayContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayContent").build()}).build();
    private static final SdkField<String> PORTAL_PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PortalProductId").getter(UpdateProductPageRequest.getter(UpdateProductPageRequest::portalProductId)).setter(UpdateProductPageRequest.setter(Builder::portalProductId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("portalProductId").build()}).build();
    private static final SdkField<String> PRODUCT_PAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductPageId").getter(UpdateProductPageRequest.getter(UpdateProductPageRequest::productPageId)).setter(UpdateProductPageRequest.setter(Builder::productPageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("productPageId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_CONTENT_FIELD, PORTAL_PRODUCT_ID_FIELD, PRODUCT_PAGE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateProductPageRequest.memberNameToFieldInitializer();
    private final DisplayContent displayContent;
    private final String portalProductId;
    private final String productPageId;

    private UpdateProductPageRequest(BuilderImpl builder) {
        super(builder);
        this.displayContent = builder.displayContent;
        this.portalProductId = builder.portalProductId;
        this.productPageId = builder.productPageId;
    }

    public final DisplayContent displayContent() {
        return this.displayContent;
    }

    public final String portalProductId() {
        return this.portalProductId;
    }

    public final String productPageId() {
        return this.productPageId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.displayContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalProductId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productPageId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProductPageRequest)) {
            return false;
        }
        UpdateProductPageRequest other = (UpdateProductPageRequest)((Object)obj);
        return Objects.equals(this.displayContent(), other.displayContent()) && Objects.equals(this.portalProductId(), other.portalProductId()) && Objects.equals(this.productPageId(), other.productPageId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProductPageRequest").add("DisplayContent", (Object)this.displayContent()).add("PortalProductId", (Object)this.portalProductId()).add("ProductPageId", (Object)this.productPageId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DisplayContent": {
                return Optional.ofNullable(clazz.cast(this.displayContent()));
            }
            case "PortalProductId": {
                return Optional.ofNullable(clazz.cast(this.portalProductId()));
            }
            case "ProductPageId": {
                return Optional.ofNullable(clazz.cast(this.productPageId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("displayContent", DISPLAY_CONTENT_FIELD);
        map.put("portalProductId", PORTAL_PRODUCT_ID_FIELD);
        map.put("productPageId", PRODUCT_PAGE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProductPageRequest, T> g) {
        return obj -> g.apply((UpdateProductPageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Request.BuilderImpl
    implements Builder {
        private DisplayContent displayContent;
        private String portalProductId;
        private String productPageId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProductPageRequest model) {
            super(model);
            this.displayContent(model.displayContent);
            this.portalProductId(model.portalProductId);
            this.productPageId(model.productPageId);
        }

        public final DisplayContent.Builder getDisplayContent() {
            return this.displayContent != null ? this.displayContent.toBuilder() : null;
        }

        public final void setDisplayContent(DisplayContent.BuilderImpl displayContent) {
            this.displayContent = displayContent != null ? displayContent.build() : null;
        }

        @Override
        public final Builder displayContent(DisplayContent displayContent) {
            this.displayContent = displayContent;
            return this;
        }

        public final String getPortalProductId() {
            return this.portalProductId;
        }

        public final void setPortalProductId(String portalProductId) {
            this.portalProductId = portalProductId;
        }

        @Override
        public final Builder portalProductId(String portalProductId) {
            this.portalProductId = portalProductId;
            return this;
        }

        public final String getProductPageId() {
            return this.productPageId;
        }

        public final void setProductPageId(String productPageId) {
            this.productPageId = productPageId;
        }

        @Override
        public final Builder productPageId(String productPageId) {
            this.productPageId = productPageId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProductPageRequest build() {
            return new UpdateProductPageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApiGatewayV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProductPageRequest> {
        public Builder displayContent(DisplayContent var1);

        default public Builder displayContent(Consumer<DisplayContent.Builder> displayContent) {
            return this.displayContent((DisplayContent)((DisplayContent.Builder)DisplayContent.builder().applyMutation(displayContent)).build());
        }

        public Builder portalProductId(String var1);

        public Builder productPageId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

