/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apigatewayv2.model.Section;
import software.amazon.awssdk.services.apigatewayv2.model.___listOfSectionCopier;
import software.amazon.awssdk.services.apigatewayv2.model.___listOf__stringMin20Max2048Copier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisplayOrder
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DisplayOrder> {
    private static final SdkField<List<Section>> CONTENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Contents").getter(DisplayOrder.getter(DisplayOrder::contents)).setter(DisplayOrder.setter(Builder::contents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Section::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OVERVIEW_PAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OverviewPageArn").getter(DisplayOrder.getter(DisplayOrder::overviewPageArn)).setter(DisplayOrder.setter(Builder::overviewPageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overviewPageArn").build()}).build();
    private static final SdkField<List<String>> PRODUCT_PAGE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProductPageArns").getter(DisplayOrder.getter(DisplayOrder::productPageArns)).setter(DisplayOrder.setter(Builder::productPageArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productPageArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENTS_FIELD, OVERVIEW_PAGE_ARN_FIELD, PRODUCT_PAGE_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DisplayOrder.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Section> contents;
    private final String overviewPageArn;
    private final List<String> productPageArns;

    private DisplayOrder(BuilderImpl builder) {
        this.contents = builder.contents;
        this.overviewPageArn = builder.overviewPageArn;
        this.productPageArns = builder.productPageArns;
    }

    public final boolean hasContents() {
        return this.contents != null && !(this.contents instanceof SdkAutoConstructList);
    }

    public final List<Section> contents() {
        return this.contents;
    }

    public final String overviewPageArn() {
        return this.overviewPageArn;
    }

    public final boolean hasProductPageArns() {
        return this.productPageArns != null && !(this.productPageArns instanceof SdkAutoConstructList);
    }

    public final List<String> productPageArns() {
        return this.productPageArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContents() ? this.contents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.overviewPageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProductPageArns() ? this.productPageArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisplayOrder)) {
            return false;
        }
        DisplayOrder other = (DisplayOrder)obj;
        return this.hasContents() == other.hasContents() && Objects.equals(this.contents(), other.contents()) && Objects.equals(this.overviewPageArn(), other.overviewPageArn()) && this.hasProductPageArns() == other.hasProductPageArns() && Objects.equals(this.productPageArns(), other.productPageArns());
    }

    public final String toString() {
        return ToString.builder((String)"DisplayOrder").add("Contents", this.hasContents() ? this.contents() : null).add("OverviewPageArn", (Object)this.overviewPageArn()).add("ProductPageArns", this.hasProductPageArns() ? this.productPageArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Contents": {
                return Optional.ofNullable(clazz.cast(this.contents()));
            }
            case "OverviewPageArn": {
                return Optional.ofNullable(clazz.cast(this.overviewPageArn()));
            }
            case "ProductPageArns": {
                return Optional.ofNullable(clazz.cast(this.productPageArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contents", CONTENTS_FIELD);
        map.put("overviewPageArn", OVERVIEW_PAGE_ARN_FIELD);
        map.put("productPageArns", PRODUCT_PAGE_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisplayOrder, T> g) {
        return obj -> g.apply((DisplayOrder)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Section> contents = DefaultSdkAutoConstructList.getInstance();
        private String overviewPageArn;
        private List<String> productPageArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisplayOrder model) {
            this.contents(model.contents);
            this.overviewPageArn(model.overviewPageArn);
            this.productPageArns(model.productPageArns);
        }

        public final List<Section.Builder> getContents() {
            List<Section.Builder> result = ___listOfSectionCopier.copyToBuilder(this.contents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContents(Collection<Section.BuilderImpl> contents) {
            this.contents = ___listOfSectionCopier.copyFromBuilder(contents);
        }

        @Override
        public final Builder contents(Collection<Section> contents) {
            this.contents = ___listOfSectionCopier.copy(contents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contents(Section ... contents) {
            this.contents(Arrays.asList(contents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contents(Consumer<Section.Builder> ... contents) {
            this.contents(Stream.of(contents).map(c -> (Section)((Section.Builder)Section.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOverviewPageArn() {
            return this.overviewPageArn;
        }

        public final void setOverviewPageArn(String overviewPageArn) {
            this.overviewPageArn = overviewPageArn;
        }

        @Override
        public final Builder overviewPageArn(String overviewPageArn) {
            this.overviewPageArn = overviewPageArn;
            return this;
        }

        public final Collection<String> getProductPageArns() {
            if (this.productPageArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.productPageArns;
        }

        public final void setProductPageArns(Collection<String> productPageArns) {
            this.productPageArns = ___listOf__stringMin20Max2048Copier.copy(productPageArns);
        }

        @Override
        public final Builder productPageArns(Collection<String> productPageArns) {
            this.productPageArns = ___listOf__stringMin20Max2048Copier.copy(productPageArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productPageArns(String ... productPageArns) {
            this.productPageArns(Arrays.asList(productPageArns));
            return this;
        }

        public DisplayOrder build() {
            return new DisplayOrder(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DisplayOrder> {
        public Builder contents(Collection<Section> var1);

        public Builder contents(Section ... var1);

        public Builder contents(Consumer<Section.Builder> ... var1);

        public Builder overviewPageArn(String var1);

        public Builder productPageArns(Collection<String> var1);

        public Builder productPageArns(String ... var1);
    }
}

