/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Response;
import software.amazon.awssdk.services.apigatewayv2.model.ConnectionType;
import software.amazon.awssdk.services.apigatewayv2.model.ContentHandlingStrategy;
import software.amazon.awssdk.services.apigatewayv2.model.IntegrationParametersCopier;
import software.amazon.awssdk.services.apigatewayv2.model.IntegrationType;
import software.amazon.awssdk.services.apigatewayv2.model.PassthroughBehavior;
import software.amazon.awssdk.services.apigatewayv2.model.ResponseParametersCopier;
import software.amazon.awssdk.services.apigatewayv2.model.TemplateMapCopier;
import software.amazon.awssdk.services.apigatewayv2.model.TlsConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateIntegrationResponse
extends ApiGatewayV2Response
implements ToCopyableBuilder<Builder, UpdateIntegrationResponse> {
    private static final SdkField<Boolean> API_GATEWAY_MANAGED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ApiGatewayManaged").getter(UpdateIntegrationResponse.getter(UpdateIntegrationResponse::apiGatewayManaged)).setter(UpdateIntegrationResponse.setter(Builder::apiGatewayManaged)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiGatewayManaged").build()}).build();
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionId").getter(UpdateIntegrationResponse.getter(UpdateIntegrationResponse::connectionId)).setter(UpdateIntegrationResponse.setter(Builder::connectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()}).build();
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionType").getter(UpdateIntegrationResponse.getter(UpdateIntegrationResponse::connectionTypeAsString)).setter(UpdateIntegrationResponse.setter(Builder::connectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionType").build()}).build();
    private static final SdkField<String> CONTENT_HANDLING_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentHandlingStrategy").getter(UpdateIntegrationResponse.getter(UpdateIntegrationResponse::contentHandlingStrategyAsString)).setter(UpdateIntegrationResponse.setter(Builder::contentHandlingStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentHandlingStrategy").build()}).build();
    private static final SdkField<String> CREDENTIALS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CredentialsArn").getter(UpdateIntegrationResponse.getter(UpdateIntegrationResponse::credentialsArn)).setter(UpdateIntegrationResponse.setter(Builder::credentialsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateIntegrationResponse.getter(UpdateIntegrationResponse::description)).setter(UpdateIntegrationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> INTEGRATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationId").getter(UpdateIntegrationResponse.getter(UpdateIntegrationResponse::integrationId)).setter(UpdateIntegrationResponse.setter(Builder::integrationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationId").build()}).build();
    private static final SdkField<String> INTEGRATION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationMethod").getter(UpdateIntegrationResponse.getter(UpdateIntegrationResponse::integrationMethod)).setter(UpdateIntegrationResponse.setter(Builder::integrationMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationMethod").build()}).build();
    private static final SdkField<String> INTEGRATION_RESPONSE_SELECTION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationResponseSelectionExpression").getter(UpdateIntegrationResponse.getter(UpdateIntegrationResponse::integrationResponseSelectionExpression)).setter(UpdateIntegrationResponse.setter(Builder::integrationResponseSelectionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationResponseSelectionExpression").build()}).build();
    private static final SdkField<String> INTEGRATION_SUBTYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationSubtype").getter(UpdateIntegrationResponse.getter(UpdateIntegrationResponse::integrationSubtype)).setter(UpdateIntegrationResponse.setter(Builder::integrationSubtype)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationSubtype").build()}).build();
    private static final SdkField<String> INTEGRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationType").getter(UpdateIntegrationResponse.getter(UpdateIntegrationResponse::integrationTypeAsString)).setter(UpdateIntegrationResponse.setter(Builder::integrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationType").build()}).build();
    private static final SdkField<String> INTEGRATION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationUri").getter(UpdateIntegrationResponse.getter(UpdateIntegrationResponse::integrationUri)).setter(UpdateIntegrationResponse.setter(Builder::integrationUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationUri").build()}).build();
    private static final SdkField<String> PASSTHROUGH_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PassthroughBehavior").getter(UpdateIntegrationResponse.getter(UpdateIntegrationResponse::passthroughBehaviorAsString)).setter(UpdateIntegrationResponse.setter(Builder::passthroughBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passthroughBehavior").build()}).build();
    private static final SdkField<String> PAYLOAD_FORMAT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PayloadFormatVersion").getter(UpdateIntegrationResponse.getter(UpdateIntegrationResponse::payloadFormatVersion)).setter(UpdateIntegrationResponse.setter(Builder::payloadFormatVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payloadFormatVersion").build()}).build();
    private static final SdkField<Map<String, String>> REQUEST_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RequestParameters").getter(UpdateIntegrationResponse.getter(UpdateIntegrationResponse::requestParameters)).setter(UpdateIntegrationResponse.setter(Builder::requestParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> REQUEST_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RequestTemplates").getter(UpdateIntegrationResponse.getter(UpdateIntegrationResponse::requestTemplates)).setter(UpdateIntegrationResponse.setter(Builder::requestTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestTemplates").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Map<String, String>>> RESPONSE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ResponseParameters").getter(UpdateIntegrationResponse.getter(UpdateIntegrationResponse::responseParameters)).setter(UpdateIntegrationResponse.setter(Builder::responseParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> TEMPLATE_SELECTION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateSelectionExpression").getter(UpdateIntegrationResponse.getter(UpdateIntegrationResponse::templateSelectionExpression)).setter(UpdateIntegrationResponse.setter(Builder::templateSelectionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateSelectionExpression").build()}).build();
    private static final SdkField<Integer> TIMEOUT_IN_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimeoutInMillis").getter(UpdateIntegrationResponse.getter(UpdateIntegrationResponse::timeoutInMillis)).setter(UpdateIntegrationResponse.setter(Builder::timeoutInMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInMillis").build()}).build();
    private static final SdkField<TlsConfig> TLS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TlsConfig").getter(UpdateIntegrationResponse.getter(UpdateIntegrationResponse::tlsConfig)).setter(UpdateIntegrationResponse.setter(Builder::tlsConfig)).constructor(TlsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tlsConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_GATEWAY_MANAGED_FIELD, CONNECTION_ID_FIELD, CONNECTION_TYPE_FIELD, CONTENT_HANDLING_STRATEGY_FIELD, CREDENTIALS_ARN_FIELD, DESCRIPTION_FIELD, INTEGRATION_ID_FIELD, INTEGRATION_METHOD_FIELD, INTEGRATION_RESPONSE_SELECTION_EXPRESSION_FIELD, INTEGRATION_SUBTYPE_FIELD, INTEGRATION_TYPE_FIELD, INTEGRATION_URI_FIELD, PASSTHROUGH_BEHAVIOR_FIELD, PAYLOAD_FORMAT_VERSION_FIELD, REQUEST_PARAMETERS_FIELD, REQUEST_TEMPLATES_FIELD, RESPONSE_PARAMETERS_FIELD, TEMPLATE_SELECTION_EXPRESSION_FIELD, TIMEOUT_IN_MILLIS_FIELD, TLS_CONFIG_FIELD));
    private final Boolean apiGatewayManaged;
    private final String connectionId;
    private final String connectionType;
    private final String contentHandlingStrategy;
    private final String credentialsArn;
    private final String description;
    private final String integrationId;
    private final String integrationMethod;
    private final String integrationResponseSelectionExpression;
    private final String integrationSubtype;
    private final String integrationType;
    private final String integrationUri;
    private final String passthroughBehavior;
    private final String payloadFormatVersion;
    private final Map<String, String> requestParameters;
    private final Map<String, String> requestTemplates;
    private final Map<String, Map<String, String>> responseParameters;
    private final String templateSelectionExpression;
    private final Integer timeoutInMillis;
    private final TlsConfig tlsConfig;

    private UpdateIntegrationResponse(BuilderImpl builder) {
        super(builder);
        this.apiGatewayManaged = builder.apiGatewayManaged;
        this.connectionId = builder.connectionId;
        this.connectionType = builder.connectionType;
        this.contentHandlingStrategy = builder.contentHandlingStrategy;
        this.credentialsArn = builder.credentialsArn;
        this.description = builder.description;
        this.integrationId = builder.integrationId;
        this.integrationMethod = builder.integrationMethod;
        this.integrationResponseSelectionExpression = builder.integrationResponseSelectionExpression;
        this.integrationSubtype = builder.integrationSubtype;
        this.integrationType = builder.integrationType;
        this.integrationUri = builder.integrationUri;
        this.passthroughBehavior = builder.passthroughBehavior;
        this.payloadFormatVersion = builder.payloadFormatVersion;
        this.requestParameters = builder.requestParameters;
        this.requestTemplates = builder.requestTemplates;
        this.responseParameters = builder.responseParameters;
        this.templateSelectionExpression = builder.templateSelectionExpression;
        this.timeoutInMillis = builder.timeoutInMillis;
        this.tlsConfig = builder.tlsConfig;
    }

    public final Boolean apiGatewayManaged() {
        return this.apiGatewayManaged;
    }

    public final String connectionId() {
        return this.connectionId;
    }

    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(this.connectionType);
    }

    public final String connectionTypeAsString() {
        return this.connectionType;
    }

    public final ContentHandlingStrategy contentHandlingStrategy() {
        return ContentHandlingStrategy.fromValue(this.contentHandlingStrategy);
    }

    public final String contentHandlingStrategyAsString() {
        return this.contentHandlingStrategy;
    }

    public final String credentialsArn() {
        return this.credentialsArn;
    }

    public final String description() {
        return this.description;
    }

    public final String integrationId() {
        return this.integrationId;
    }

    public final String integrationMethod() {
        return this.integrationMethod;
    }

    public final String integrationResponseSelectionExpression() {
        return this.integrationResponseSelectionExpression;
    }

    public final String integrationSubtype() {
        return this.integrationSubtype;
    }

    public final IntegrationType integrationType() {
        return IntegrationType.fromValue(this.integrationType);
    }

    public final String integrationTypeAsString() {
        return this.integrationType;
    }

    public final String integrationUri() {
        return this.integrationUri;
    }

    public final PassthroughBehavior passthroughBehavior() {
        return PassthroughBehavior.fromValue(this.passthroughBehavior);
    }

    public final String passthroughBehaviorAsString() {
        return this.passthroughBehavior;
    }

    public final String payloadFormatVersion() {
        return this.payloadFormatVersion;
    }

    public final boolean hasRequestParameters() {
        return this.requestParameters != null && !(this.requestParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> requestParameters() {
        return this.requestParameters;
    }

    public final boolean hasRequestTemplates() {
        return this.requestTemplates != null && !(this.requestTemplates instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> requestTemplates() {
        return this.requestTemplates;
    }

    public final boolean hasResponseParameters() {
        return this.responseParameters != null && !(this.responseParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, Map<String, String>> responseParameters() {
        return this.responseParameters;
    }

    public final String templateSelectionExpression() {
        return this.templateSelectionExpression;
    }

    public final Integer timeoutInMillis() {
        return this.timeoutInMillis;
    }

    public final TlsConfig tlsConfig() {
        return this.tlsConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiGatewayManaged());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentHandlingStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationResponseSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationSubtype());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.passthroughBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.payloadFormatVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestParameters() ? this.requestParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestTemplates() ? this.requestTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponseParameters() ? this.responseParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.templateSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIntegrationResponse)) {
            return false;
        }
        UpdateIntegrationResponse other = (UpdateIntegrationResponse)((Object)obj);
        return Objects.equals(this.apiGatewayManaged(), other.apiGatewayManaged()) && Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.connectionTypeAsString(), other.connectionTypeAsString()) && Objects.equals(this.contentHandlingStrategyAsString(), other.contentHandlingStrategyAsString()) && Objects.equals(this.credentialsArn(), other.credentialsArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.integrationId(), other.integrationId()) && Objects.equals(this.integrationMethod(), other.integrationMethod()) && Objects.equals(this.integrationResponseSelectionExpression(), other.integrationResponseSelectionExpression()) && Objects.equals(this.integrationSubtype(), other.integrationSubtype()) && Objects.equals(this.integrationTypeAsString(), other.integrationTypeAsString()) && Objects.equals(this.integrationUri(), other.integrationUri()) && Objects.equals(this.passthroughBehaviorAsString(), other.passthroughBehaviorAsString()) && Objects.equals(this.payloadFormatVersion(), other.payloadFormatVersion()) && this.hasRequestParameters() == other.hasRequestParameters() && Objects.equals(this.requestParameters(), other.requestParameters()) && this.hasRequestTemplates() == other.hasRequestTemplates() && Objects.equals(this.requestTemplates(), other.requestTemplates()) && this.hasResponseParameters() == other.hasResponseParameters() && Objects.equals(this.responseParameters(), other.responseParameters()) && Objects.equals(this.templateSelectionExpression(), other.templateSelectionExpression()) && Objects.equals(this.timeoutInMillis(), other.timeoutInMillis()) && Objects.equals(this.tlsConfig(), other.tlsConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateIntegrationResponse").add("ApiGatewayManaged", (Object)this.apiGatewayManaged()).add("ConnectionId", (Object)this.connectionId()).add("ConnectionType", (Object)this.connectionTypeAsString()).add("ContentHandlingStrategy", (Object)this.contentHandlingStrategyAsString()).add("CredentialsArn", (Object)this.credentialsArn()).add("Description", (Object)this.description()).add("IntegrationId", (Object)this.integrationId()).add("IntegrationMethod", (Object)this.integrationMethod()).add("IntegrationResponseSelectionExpression", (Object)this.integrationResponseSelectionExpression()).add("IntegrationSubtype", (Object)this.integrationSubtype()).add("IntegrationType", (Object)this.integrationTypeAsString()).add("IntegrationUri", (Object)this.integrationUri()).add("PassthroughBehavior", (Object)this.passthroughBehaviorAsString()).add("PayloadFormatVersion", (Object)this.payloadFormatVersion()).add("RequestParameters", this.hasRequestParameters() ? this.requestParameters() : null).add("RequestTemplates", this.hasRequestTemplates() ? this.requestTemplates() : null).add("ResponseParameters", this.hasResponseParameters() ? this.responseParameters() : null).add("TemplateSelectionExpression", (Object)this.templateSelectionExpression()).add("TimeoutInMillis", (Object)this.timeoutInMillis()).add("TlsConfig", (Object)this.tlsConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiGatewayManaged": {
                return Optional.ofNullable(clazz.cast(this.apiGatewayManaged()));
            }
            case "ConnectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "ConnectionType": {
                return Optional.ofNullable(clazz.cast(this.connectionTypeAsString()));
            }
            case "ContentHandlingStrategy": {
                return Optional.ofNullable(clazz.cast(this.contentHandlingStrategyAsString()));
            }
            case "CredentialsArn": {
                return Optional.ofNullable(clazz.cast(this.credentialsArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "IntegrationId": {
                return Optional.ofNullable(clazz.cast(this.integrationId()));
            }
            case "IntegrationMethod": {
                return Optional.ofNullable(clazz.cast(this.integrationMethod()));
            }
            case "IntegrationResponseSelectionExpression": {
                return Optional.ofNullable(clazz.cast(this.integrationResponseSelectionExpression()));
            }
            case "IntegrationSubtype": {
                return Optional.ofNullable(clazz.cast(this.integrationSubtype()));
            }
            case "IntegrationType": {
                return Optional.ofNullable(clazz.cast(this.integrationTypeAsString()));
            }
            case "IntegrationUri": {
                return Optional.ofNullable(clazz.cast(this.integrationUri()));
            }
            case "PassthroughBehavior": {
                return Optional.ofNullable(clazz.cast(this.passthroughBehaviorAsString()));
            }
            case "PayloadFormatVersion": {
                return Optional.ofNullable(clazz.cast(this.payloadFormatVersion()));
            }
            case "RequestParameters": {
                return Optional.ofNullable(clazz.cast(this.requestParameters()));
            }
            case "RequestTemplates": {
                return Optional.ofNullable(clazz.cast(this.requestTemplates()));
            }
            case "ResponseParameters": {
                return Optional.ofNullable(clazz.cast(this.responseParameters()));
            }
            case "TemplateSelectionExpression": {
                return Optional.ofNullable(clazz.cast(this.templateSelectionExpression()));
            }
            case "TimeoutInMillis": {
                return Optional.ofNullable(clazz.cast(this.timeoutInMillis()));
            }
            case "TlsConfig": {
                return Optional.ofNullable(clazz.cast(this.tlsConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIntegrationResponse, T> g) {
        return obj -> g.apply((UpdateIntegrationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Response.BuilderImpl
    implements Builder {
        private Boolean apiGatewayManaged;
        private String connectionId;
        private String connectionType;
        private String contentHandlingStrategy;
        private String credentialsArn;
        private String description;
        private String integrationId;
        private String integrationMethod;
        private String integrationResponseSelectionExpression;
        private String integrationSubtype;
        private String integrationType;
        private String integrationUri;
        private String passthroughBehavior;
        private String payloadFormatVersion;
        private Map<String, String> requestParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> requestTemplates = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, Map<String, String>> responseParameters = DefaultSdkAutoConstructMap.getInstance();
        private String templateSelectionExpression;
        private Integer timeoutInMillis;
        private TlsConfig tlsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIntegrationResponse model) {
            super(model);
            this.apiGatewayManaged(model.apiGatewayManaged);
            this.connectionId(model.connectionId);
            this.connectionType(model.connectionType);
            this.contentHandlingStrategy(model.contentHandlingStrategy);
            this.credentialsArn(model.credentialsArn);
            this.description(model.description);
            this.integrationId(model.integrationId);
            this.integrationMethod(model.integrationMethod);
            this.integrationResponseSelectionExpression(model.integrationResponseSelectionExpression);
            this.integrationSubtype(model.integrationSubtype);
            this.integrationType(model.integrationType);
            this.integrationUri(model.integrationUri);
            this.passthroughBehavior(model.passthroughBehavior);
            this.payloadFormatVersion(model.payloadFormatVersion);
            this.requestParameters(model.requestParameters);
            this.requestTemplates(model.requestTemplates);
            this.responseParameters(model.responseParameters);
            this.templateSelectionExpression(model.templateSelectionExpression);
            this.timeoutInMillis(model.timeoutInMillis);
            this.tlsConfig(model.tlsConfig);
        }

        public final Boolean getApiGatewayManaged() {
            return this.apiGatewayManaged;
        }

        public final void setApiGatewayManaged(Boolean apiGatewayManaged) {
            this.apiGatewayManaged = apiGatewayManaged;
        }

        @Override
        public final Builder apiGatewayManaged(Boolean apiGatewayManaged) {
            this.apiGatewayManaged = apiGatewayManaged;
            return this;
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final String getConnectionType() {
            return this.connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final String getContentHandlingStrategy() {
            return this.contentHandlingStrategy;
        }

        public final void setContentHandlingStrategy(String contentHandlingStrategy) {
            this.contentHandlingStrategy = contentHandlingStrategy;
        }

        @Override
        public final Builder contentHandlingStrategy(String contentHandlingStrategy) {
            this.contentHandlingStrategy = contentHandlingStrategy;
            return this;
        }

        @Override
        public final Builder contentHandlingStrategy(ContentHandlingStrategy contentHandlingStrategy) {
            this.contentHandlingStrategy(contentHandlingStrategy == null ? null : contentHandlingStrategy.toString());
            return this;
        }

        public final String getCredentialsArn() {
            return this.credentialsArn;
        }

        public final void setCredentialsArn(String credentialsArn) {
            this.credentialsArn = credentialsArn;
        }

        @Override
        public final Builder credentialsArn(String credentialsArn) {
            this.credentialsArn = credentialsArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getIntegrationId() {
            return this.integrationId;
        }

        public final void setIntegrationId(String integrationId) {
            this.integrationId = integrationId;
        }

        @Override
        public final Builder integrationId(String integrationId) {
            this.integrationId = integrationId;
            return this;
        }

        public final String getIntegrationMethod() {
            return this.integrationMethod;
        }

        public final void setIntegrationMethod(String integrationMethod) {
            this.integrationMethod = integrationMethod;
        }

        @Override
        public final Builder integrationMethod(String integrationMethod) {
            this.integrationMethod = integrationMethod;
            return this;
        }

        public final String getIntegrationResponseSelectionExpression() {
            return this.integrationResponseSelectionExpression;
        }

        public final void setIntegrationResponseSelectionExpression(String integrationResponseSelectionExpression) {
            this.integrationResponseSelectionExpression = integrationResponseSelectionExpression;
        }

        @Override
        public final Builder integrationResponseSelectionExpression(String integrationResponseSelectionExpression) {
            this.integrationResponseSelectionExpression = integrationResponseSelectionExpression;
            return this;
        }

        public final String getIntegrationSubtype() {
            return this.integrationSubtype;
        }

        public final void setIntegrationSubtype(String integrationSubtype) {
            this.integrationSubtype = integrationSubtype;
        }

        @Override
        public final Builder integrationSubtype(String integrationSubtype) {
            this.integrationSubtype = integrationSubtype;
            return this;
        }

        public final String getIntegrationType() {
            return this.integrationType;
        }

        public final void setIntegrationType(String integrationType) {
            this.integrationType = integrationType;
        }

        @Override
        public final Builder integrationType(String integrationType) {
            this.integrationType = integrationType;
            return this;
        }

        @Override
        public final Builder integrationType(IntegrationType integrationType) {
            this.integrationType(integrationType == null ? null : integrationType.toString());
            return this;
        }

        public final String getIntegrationUri() {
            return this.integrationUri;
        }

        public final void setIntegrationUri(String integrationUri) {
            this.integrationUri = integrationUri;
        }

        @Override
        public final Builder integrationUri(String integrationUri) {
            this.integrationUri = integrationUri;
            return this;
        }

        public final String getPassthroughBehavior() {
            return this.passthroughBehavior;
        }

        public final void setPassthroughBehavior(String passthroughBehavior) {
            this.passthroughBehavior = passthroughBehavior;
        }

        @Override
        public final Builder passthroughBehavior(String passthroughBehavior) {
            this.passthroughBehavior = passthroughBehavior;
            return this;
        }

        @Override
        public final Builder passthroughBehavior(PassthroughBehavior passthroughBehavior) {
            this.passthroughBehavior(passthroughBehavior == null ? null : passthroughBehavior.toString());
            return this;
        }

        public final String getPayloadFormatVersion() {
            return this.payloadFormatVersion;
        }

        public final void setPayloadFormatVersion(String payloadFormatVersion) {
            this.payloadFormatVersion = payloadFormatVersion;
        }

        @Override
        public final Builder payloadFormatVersion(String payloadFormatVersion) {
            this.payloadFormatVersion = payloadFormatVersion;
            return this;
        }

        public final Map<String, String> getRequestParameters() {
            if (this.requestParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.requestParameters;
        }

        public final void setRequestParameters(Map<String, String> requestParameters) {
            this.requestParameters = IntegrationParametersCopier.copy(requestParameters);
        }

        @Override
        public final Builder requestParameters(Map<String, String> requestParameters) {
            this.requestParameters = IntegrationParametersCopier.copy(requestParameters);
            return this;
        }

        public final Map<String, String> getRequestTemplates() {
            if (this.requestTemplates instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.requestTemplates;
        }

        public final void setRequestTemplates(Map<String, String> requestTemplates) {
            this.requestTemplates = TemplateMapCopier.copy(requestTemplates);
        }

        @Override
        public final Builder requestTemplates(Map<String, String> requestTemplates) {
            this.requestTemplates = TemplateMapCopier.copy(requestTemplates);
            return this;
        }

        public final Map<String, ? extends Map<String, String>> getResponseParameters() {
            if (this.responseParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.responseParameters;
        }

        public final void setResponseParameters(Map<String, ? extends Map<String, String>> responseParameters) {
            this.responseParameters = ResponseParametersCopier.copy(responseParameters);
        }

        @Override
        public final Builder responseParameters(Map<String, ? extends Map<String, String>> responseParameters) {
            this.responseParameters = ResponseParametersCopier.copy(responseParameters);
            return this;
        }

        public final String getTemplateSelectionExpression() {
            return this.templateSelectionExpression;
        }

        public final void setTemplateSelectionExpression(String templateSelectionExpression) {
            this.templateSelectionExpression = templateSelectionExpression;
        }

        @Override
        public final Builder templateSelectionExpression(String templateSelectionExpression) {
            this.templateSelectionExpression = templateSelectionExpression;
            return this;
        }

        public final Integer getTimeoutInMillis() {
            return this.timeoutInMillis;
        }

        public final void setTimeoutInMillis(Integer timeoutInMillis) {
            this.timeoutInMillis = timeoutInMillis;
        }

        @Override
        public final Builder timeoutInMillis(Integer timeoutInMillis) {
            this.timeoutInMillis = timeoutInMillis;
            return this;
        }

        public final TlsConfig.Builder getTlsConfig() {
            return this.tlsConfig != null ? this.tlsConfig.toBuilder() : null;
        }

        public final void setTlsConfig(TlsConfig.BuilderImpl tlsConfig) {
            this.tlsConfig = tlsConfig != null ? tlsConfig.build() : null;
        }

        @Override
        public final Builder tlsConfig(TlsConfig tlsConfig) {
            this.tlsConfig = tlsConfig;
            return this;
        }

        @Override
        public UpdateIntegrationResponse build() {
            return new UpdateIntegrationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateIntegrationResponse> {
        public Builder apiGatewayManaged(Boolean var1);

        public Builder connectionId(String var1);

        public Builder connectionType(String var1);

        public Builder connectionType(ConnectionType var1);

        public Builder contentHandlingStrategy(String var1);

        public Builder contentHandlingStrategy(ContentHandlingStrategy var1);

        public Builder credentialsArn(String var1);

        public Builder description(String var1);

        public Builder integrationId(String var1);

        public Builder integrationMethod(String var1);

        public Builder integrationResponseSelectionExpression(String var1);

        public Builder integrationSubtype(String var1);

        public Builder integrationType(String var1);

        public Builder integrationType(IntegrationType var1);

        public Builder integrationUri(String var1);

        public Builder passthroughBehavior(String var1);

        public Builder passthroughBehavior(PassthroughBehavior var1);

        public Builder payloadFormatVersion(String var1);

        public Builder requestParameters(Map<String, String> var1);

        public Builder requestTemplates(Map<String, String> var1);

        public Builder responseParameters(Map<String, ? extends Map<String, String>> var1);

        public Builder templateSelectionExpression(String var1);

        public Builder timeoutInMillis(Integer var1);

        public Builder tlsConfig(TlsConfig var1);

        default public Builder tlsConfig(Consumer<TlsConfig.Builder> tlsConfig) {
            return this.tlsConfig((TlsConfig)((TlsConfig.Builder)TlsConfig.builder().applyMutation(tlsConfig)).build());
        }
    }
}

