/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRouteResponse extends ApiGatewayV2Response implements
        ToCopyableBuilder<GetRouteResponse.Builder, GetRouteResponse> {
    private static final SdkField<Boolean> API_GATEWAY_MANAGED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ApiGatewayManaged").getter(getter(GetRouteResponse::apiGatewayManaged))
            .setter(setter(Builder::apiGatewayManaged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiGatewayManaged").build()).build();

    private static final SdkField<Boolean> API_KEY_REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ApiKeyRequired").getter(getter(GetRouteResponse::apiKeyRequired))
            .setter(setter(Builder::apiKeyRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeyRequired").build()).build();

    private static final SdkField<List<String>> AUTHORIZATION_SCOPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AuthorizationScopes")
            .getter(getter(GetRouteResponse::authorizationScopes))
            .setter(setter(Builder::authorizationScopes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationScopes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AUTHORIZATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthorizationType").getter(getter(GetRouteResponse::authorizationTypeAsString))
            .setter(setter(Builder::authorizationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationType").build()).build();

    private static final SdkField<String> AUTHORIZER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthorizerId").getter(getter(GetRouteResponse::authorizerId)).setter(setter(Builder::authorizerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerId").build()).build();

    private static final SdkField<String> MODEL_SELECTION_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelSelectionExpression").getter(getter(GetRouteResponse::modelSelectionExpression))
            .setter(setter(Builder::modelSelectionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelSelectionExpression").build())
            .build();

    private static final SdkField<String> OPERATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationName").getter(getter(GetRouteResponse::operationName)).setter(setter(Builder::operationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationName").build()).build();

    private static final SdkField<Map<String, String>> REQUEST_MODELS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("RequestModels")
            .getter(getter(GetRouteResponse::requestModels))
            .setter(setter(Builder::requestModels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestModels").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, ParameterConstraints>> REQUEST_PARAMETERS_FIELD = SdkField
            .<Map<String, ParameterConstraints>> builder(MarshallingType.MAP)
            .memberName("RequestParameters")
            .getter(getter(GetRouteResponse::requestParameters))
            .setter(setter(Builder::requestParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ParameterConstraints> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParameterConstraints::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ROUTE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteId").getter(getter(GetRouteResponse::routeId)).setter(setter(Builder::routeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeId").build()).build();

    private static final SdkField<String> ROUTE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteKey").getter(getter(GetRouteResponse::routeKey)).setter(setter(Builder::routeKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeKey").build()).build();

    private static final SdkField<String> ROUTE_RESPONSE_SELECTION_EXPRESSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RouteResponseSelectionExpression")
            .getter(getter(GetRouteResponse::routeResponseSelectionExpression))
            .setter(setter(Builder::routeResponseSelectionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeResponseSelectionExpression")
                    .build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Target")
            .getter(getter(GetRouteResponse::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_GATEWAY_MANAGED_FIELD,
            API_KEY_REQUIRED_FIELD, AUTHORIZATION_SCOPES_FIELD, AUTHORIZATION_TYPE_FIELD, AUTHORIZER_ID_FIELD,
            MODEL_SELECTION_EXPRESSION_FIELD, OPERATION_NAME_FIELD, REQUEST_MODELS_FIELD, REQUEST_PARAMETERS_FIELD,
            ROUTE_ID_FIELD, ROUTE_KEY_FIELD, ROUTE_RESPONSE_SELECTION_EXPRESSION_FIELD, TARGET_FIELD));

    private final Boolean apiGatewayManaged;

    private final Boolean apiKeyRequired;

    private final List<String> authorizationScopes;

    private final String authorizationType;

    private final String authorizerId;

    private final String modelSelectionExpression;

    private final String operationName;

    private final Map<String, String> requestModels;

    private final Map<String, ParameterConstraints> requestParameters;

    private final String routeId;

    private final String routeKey;

    private final String routeResponseSelectionExpression;

    private final String target;

    private GetRouteResponse(BuilderImpl builder) {
        super(builder);
        this.apiGatewayManaged = builder.apiGatewayManaged;
        this.apiKeyRequired = builder.apiKeyRequired;
        this.authorizationScopes = builder.authorizationScopes;
        this.authorizationType = builder.authorizationType;
        this.authorizerId = builder.authorizerId;
        this.modelSelectionExpression = builder.modelSelectionExpression;
        this.operationName = builder.operationName;
        this.requestModels = builder.requestModels;
        this.requestParameters = builder.requestParameters;
        this.routeId = builder.routeId;
        this.routeKey = builder.routeKey;
        this.routeResponseSelectionExpression = builder.routeResponseSelectionExpression;
        this.target = builder.target;
    }

    /**
     * <p>
     * Specifies whether a route is managed by API Gateway. If you created an API using quick create, the $default route
     * is managed by API Gateway. You can't modify the $default route key.
     * </p>
     * 
     * @return Specifies whether a route is managed by API Gateway. If you created an API using quick create, the
     *         $default route is managed by API Gateway. You can't modify the $default route key.
     */
    public final Boolean apiGatewayManaged() {
        return apiGatewayManaged;
    }

    /**
     * <p>
     * Specifies whether an API key is required for this route. Supported only for WebSocket APIs.
     * </p>
     * 
     * @return Specifies whether an API key is required for this route. Supported only for WebSocket APIs.
     */
    public final Boolean apiKeyRequired() {
        return apiKeyRequired;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthorizationScopes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuthorizationScopes() {
        return authorizationScopes != null && !(authorizationScopes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to authorize the
     * method invocation. The authorization works by matching the route scopes against the scopes parsed from the access
     * token in the incoming request. The method invocation is authorized if any route scope matches a claimed scope in
     * the access token. Otherwise, the invocation is not authorized. When the route scope is configured, the client
     * must provide an access token instead of an identity token for authorization purposes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthorizationScopes} method.
     * </p>
     * 
     * @return A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to
     *         authorize the method invocation. The authorization works by matching the route scopes against the scopes
     *         parsed from the access token in the incoming request. The method invocation is authorized if any route
     *         scope matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the
     *         route scope is configured, the client must provide an access token instead of an identity token for
     *         authorization purposes.
     */
    public final List<String> authorizationScopes() {
        return authorizationScopes;
    }

    /**
     * <p>
     * The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for
     * using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open
     * access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda
     * authorizer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authorizationType}
     * will return {@link AuthorizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #authorizationTypeAsString}.
     * </p>
     * 
     * @return The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM
     *         for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are
     *         NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM
     *         for using a Lambda authorizer.
     * @see AuthorizationType
     */
    public final AuthorizationType authorizationType() {
        return AuthorizationType.fromValue(authorizationType);
    }

    /**
     * <p>
     * The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for
     * using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open
     * access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda
     * authorizer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authorizationType}
     * will return {@link AuthorizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #authorizationTypeAsString}.
     * </p>
     * 
     * @return The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM
     *         for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are
     *         NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM
     *         for using a Lambda authorizer.
     * @see AuthorizationType
     */
    public final String authorizationTypeAsString() {
        return authorizationType;
    }

    /**
     * <p>
     * The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is
     * generated by API Gateway when you created the authorizer.
     * </p>
     * 
     * @return The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is
     *         generated by API Gateway when you created the authorizer.
     */
    public final String authorizerId() {
        return authorizerId;
    }

    /**
     * <p>
     * The model selection expression for the route. Supported only for WebSocket APIs.
     * </p>
     * 
     * @return The model selection expression for the route. Supported only for WebSocket APIs.
     */
    public final String modelSelectionExpression() {
        return modelSelectionExpression;
    }

    /**
     * <p>
     * The operation name for the route.
     * </p>
     * 
     * @return The operation name for the route.
     */
    public final String operationName() {
        return operationName;
    }

    /**
     * For responses, this returns true if the service returned a value for the RequestModels property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRequestModels() {
        return requestModels != null && !(requestModels instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The request models for the route. Supported only for WebSocket APIs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequestModels} method.
     * </p>
     * 
     * @return The request models for the route. Supported only for WebSocket APIs.
     */
    public final Map<String, String> requestModels() {
        return requestModels;
    }

    /**
     * For responses, this returns true if the service returned a value for the RequestParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRequestParameters() {
        return requestParameters != null && !(requestParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The request parameters for the route. Supported only for WebSocket APIs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequestParameters} method.
     * </p>
     * 
     * @return The request parameters for the route. Supported only for WebSocket APIs.
     */
    public final Map<String, ParameterConstraints> requestParameters() {
        return requestParameters;
    }

    /**
     * <p>
     * The route ID.
     * </p>
     * 
     * @return The route ID.
     */
    public final String routeId() {
        return routeId;
    }

    /**
     * <p>
     * The route key for the route.
     * </p>
     * 
     * @return The route key for the route.
     */
    public final String routeKey() {
        return routeKey;
    }

    /**
     * <p>
     * The route response selection expression for the route. Supported only for WebSocket APIs.
     * </p>
     * 
     * @return The route response selection expression for the route. Supported only for WebSocket APIs.
     */
    public final String routeResponseSelectionExpression() {
        return routeResponseSelectionExpression;
    }

    /**
     * <p>
     * The target for the route.
     * </p>
     * 
     * @return The target for the route.
     */
    public final String target() {
        return target;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiGatewayManaged());
        hashCode = 31 * hashCode + Objects.hashCode(apiKeyRequired());
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthorizationScopes() ? authorizationScopes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(authorizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(authorizerId());
        hashCode = 31 * hashCode + Objects.hashCode(modelSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(operationName());
        hashCode = 31 * hashCode + Objects.hashCode(hasRequestModels() ? requestModels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRequestParameters() ? requestParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(routeId());
        hashCode = 31 * hashCode + Objects.hashCode(routeKey());
        hashCode = 31 * hashCode + Objects.hashCode(routeResponseSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRouteResponse)) {
            return false;
        }
        GetRouteResponse other = (GetRouteResponse) obj;
        return Objects.equals(apiGatewayManaged(), other.apiGatewayManaged())
                && Objects.equals(apiKeyRequired(), other.apiKeyRequired())
                && hasAuthorizationScopes() == other.hasAuthorizationScopes()
                && Objects.equals(authorizationScopes(), other.authorizationScopes())
                && Objects.equals(authorizationTypeAsString(), other.authorizationTypeAsString())
                && Objects.equals(authorizerId(), other.authorizerId())
                && Objects.equals(modelSelectionExpression(), other.modelSelectionExpression())
                && Objects.equals(operationName(), other.operationName()) && hasRequestModels() == other.hasRequestModels()
                && Objects.equals(requestModels(), other.requestModels())
                && hasRequestParameters() == other.hasRequestParameters()
                && Objects.equals(requestParameters(), other.requestParameters()) && Objects.equals(routeId(), other.routeId())
                && Objects.equals(routeKey(), other.routeKey())
                && Objects.equals(routeResponseSelectionExpression(), other.routeResponseSelectionExpression())
                && Objects.equals(target(), other.target());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRouteResponse").add("ApiGatewayManaged", apiGatewayManaged())
                .add("ApiKeyRequired", apiKeyRequired())
                .add("AuthorizationScopes", hasAuthorizationScopes() ? authorizationScopes() : null)
                .add("AuthorizationType", authorizationTypeAsString()).add("AuthorizerId", authorizerId())
                .add("ModelSelectionExpression", modelSelectionExpression()).add("OperationName", operationName())
                .add("RequestModels", hasRequestModels() ? requestModels() : null)
                .add("RequestParameters", hasRequestParameters() ? requestParameters() : null).add("RouteId", routeId())
                .add("RouteKey", routeKey()).add("RouteResponseSelectionExpression", routeResponseSelectionExpression())
                .add("Target", target()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiGatewayManaged":
            return Optional.ofNullable(clazz.cast(apiGatewayManaged()));
        case "ApiKeyRequired":
            return Optional.ofNullable(clazz.cast(apiKeyRequired()));
        case "AuthorizationScopes":
            return Optional.ofNullable(clazz.cast(authorizationScopes()));
        case "AuthorizationType":
            return Optional.ofNullable(clazz.cast(authorizationTypeAsString()));
        case "AuthorizerId":
            return Optional.ofNullable(clazz.cast(authorizerId()));
        case "ModelSelectionExpression":
            return Optional.ofNullable(clazz.cast(modelSelectionExpression()));
        case "OperationName":
            return Optional.ofNullable(clazz.cast(operationName()));
        case "RequestModels":
            return Optional.ofNullable(clazz.cast(requestModels()));
        case "RequestParameters":
            return Optional.ofNullable(clazz.cast(requestParameters()));
        case "RouteId":
            return Optional.ofNullable(clazz.cast(routeId()));
        case "RouteKey":
            return Optional.ofNullable(clazz.cast(routeKey()));
        case "RouteResponseSelectionExpression":
            return Optional.ofNullable(clazz.cast(routeResponseSelectionExpression()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRouteResponse, T> g) {
        return obj -> g.apply((GetRouteResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayV2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetRouteResponse> {
        /**
         * <p>
         * Specifies whether a route is managed by API Gateway. If you created an API using quick create, the $default
         * route is managed by API Gateway. You can't modify the $default route key.
         * </p>
         * 
         * @param apiGatewayManaged
         *        Specifies whether a route is managed by API Gateway. If you created an API using quick create, the
         *        $default route is managed by API Gateway. You can't modify the $default route key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiGatewayManaged(Boolean apiGatewayManaged);

        /**
         * <p>
         * Specifies whether an API key is required for this route. Supported only for WebSocket APIs.
         * </p>
         * 
         * @param apiKeyRequired
         *        Specifies whether an API key is required for this route. Supported only for WebSocket APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKeyRequired(Boolean apiKeyRequired);

        /**
         * <p>
         * A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to authorize
         * the method invocation. The authorization works by matching the route scopes against the scopes parsed from
         * the access token in the incoming request. The method invocation is authorized if any route scope matches a
         * claimed scope in the access token. Otherwise, the invocation is not authorized. When the route scope is
         * configured, the client must provide an access token instead of an identity token for authorization purposes.
         * </p>
         * 
         * @param authorizationScopes
         *        A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to
         *        authorize the method invocation. The authorization works by matching the route scopes against the
         *        scopes parsed from the access token in the incoming request. The method invocation is authorized if
         *        any route scope matches a claimed scope in the access token. Otherwise, the invocation is not
         *        authorized. When the route scope is configured, the client must provide an access token instead of an
         *        identity token for authorization purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationScopes(Collection<String> authorizationScopes);

        /**
         * <p>
         * A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to authorize
         * the method invocation. The authorization works by matching the route scopes against the scopes parsed from
         * the access token in the incoming request. The method invocation is authorized if any route scope matches a
         * claimed scope in the access token. Otherwise, the invocation is not authorized. When the route scope is
         * configured, the client must provide an access token instead of an identity token for authorization purposes.
         * </p>
         * 
         * @param authorizationScopes
         *        A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to
         *        authorize the method invocation. The authorization works by matching the route scopes against the
         *        scopes parsed from the access token in the incoming request. The method invocation is authorized if
         *        any route scope matches a claimed scope in the access token. Otherwise, the invocation is not
         *        authorized. When the route scope is configured, the client must provide an access token instead of an
         *        identity token for authorization purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationScopes(String... authorizationScopes);

        /**
         * <p>
         * The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for
         * using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for
         * open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a
         * Lambda authorizer.
         * </p>
         * 
         * @param authorizationType
         *        The authorization type for the route. For WebSocket APIs, valid values are NONE for open access,
         *        AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid
         *        values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions,
         *        and CUSTOM for using a Lambda authorizer.
         * @see AuthorizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizationType
         */
        Builder authorizationType(String authorizationType);

        /**
         * <p>
         * The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for
         * using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for
         * open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a
         * Lambda authorizer.
         * </p>
         * 
         * @param authorizationType
         *        The authorization type for the route. For WebSocket APIs, valid values are NONE for open access,
         *        AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid
         *        values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions,
         *        and CUSTOM for using a Lambda authorizer.
         * @see AuthorizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizationType
         */
        Builder authorizationType(AuthorizationType authorizationType);

        /**
         * <p>
         * The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is
         * generated by API Gateway when you created the authorizer.
         * </p>
         * 
         * @param authorizerId
         *        The identifier of the Authorizer resource to be associated with this route. The authorizer identifier
         *        is generated by API Gateway when you created the authorizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerId(String authorizerId);

        /**
         * <p>
         * The model selection expression for the route. Supported only for WebSocket APIs.
         * </p>
         * 
         * @param modelSelectionExpression
         *        The model selection expression for the route. Supported only for WebSocket APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelSelectionExpression(String modelSelectionExpression);

        /**
         * <p>
         * The operation name for the route.
         * </p>
         * 
         * @param operationName
         *        The operation name for the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationName(String operationName);

        /**
         * <p>
         * The request models for the route. Supported only for WebSocket APIs.
         * </p>
         * 
         * @param requestModels
         *        The request models for the route. Supported only for WebSocket APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestModels(Map<String, String> requestModels);

        /**
         * <p>
         * The request parameters for the route. Supported only for WebSocket APIs.
         * </p>
         * 
         * @param requestParameters
         *        The request parameters for the route. Supported only for WebSocket APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestParameters(Map<String, ParameterConstraints> requestParameters);

        /**
         * <p>
         * The route ID.
         * </p>
         * 
         * @param routeId
         *        The route ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeId(String routeId);

        /**
         * <p>
         * The route key for the route.
         * </p>
         * 
         * @param routeKey
         *        The route key for the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeKey(String routeKey);

        /**
         * <p>
         * The route response selection expression for the route. Supported only for WebSocket APIs.
         * </p>
         * 
         * @param routeResponseSelectionExpression
         *        The route response selection expression for the route. Supported only for WebSocket APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeResponseSelectionExpression(String routeResponseSelectionExpression);

        /**
         * <p>
         * The target for the route.
         * </p>
         * 
         * @param target
         *        The target for the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);
    }

    static final class BuilderImpl extends ApiGatewayV2Response.BuilderImpl implements Builder {
        private Boolean apiGatewayManaged;

        private Boolean apiKeyRequired;

        private List<String> authorizationScopes = DefaultSdkAutoConstructList.getInstance();

        private String authorizationType;

        private String authorizerId;

        private String modelSelectionExpression;

        private String operationName;

        private Map<String, String> requestModels = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, ParameterConstraints> requestParameters = DefaultSdkAutoConstructMap.getInstance();

        private String routeId;

        private String routeKey;

        private String routeResponseSelectionExpression;

        private String target;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRouteResponse model) {
            super(model);
            apiGatewayManaged(model.apiGatewayManaged);
            apiKeyRequired(model.apiKeyRequired);
            authorizationScopes(model.authorizationScopes);
            authorizationType(model.authorizationType);
            authorizerId(model.authorizerId);
            modelSelectionExpression(model.modelSelectionExpression);
            operationName(model.operationName);
            requestModels(model.requestModels);
            requestParameters(model.requestParameters);
            routeId(model.routeId);
            routeKey(model.routeKey);
            routeResponseSelectionExpression(model.routeResponseSelectionExpression);
            target(model.target);
        }

        public final Boolean getApiGatewayManaged() {
            return apiGatewayManaged;
        }

        public final void setApiGatewayManaged(Boolean apiGatewayManaged) {
            this.apiGatewayManaged = apiGatewayManaged;
        }

        @Override
        public final Builder apiGatewayManaged(Boolean apiGatewayManaged) {
            this.apiGatewayManaged = apiGatewayManaged;
            return this;
        }

        public final Boolean getApiKeyRequired() {
            return apiKeyRequired;
        }

        public final void setApiKeyRequired(Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
        }

        @Override
        public final Builder apiKeyRequired(Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
            return this;
        }

        public final Collection<String> getAuthorizationScopes() {
            if (authorizationScopes instanceof SdkAutoConstructList) {
                return null;
            }
            return authorizationScopes;
        }

        public final void setAuthorizationScopes(Collection<String> authorizationScopes) {
            this.authorizationScopes = AuthorizationScopesCopier.copy(authorizationScopes);
        }

        @Override
        public final Builder authorizationScopes(Collection<String> authorizationScopes) {
            this.authorizationScopes = AuthorizationScopesCopier.copy(authorizationScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizationScopes(String... authorizationScopes) {
            authorizationScopes(Arrays.asList(authorizationScopes));
            return this;
        }

        public final String getAuthorizationType() {
            return authorizationType;
        }

        public final void setAuthorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
        }

        @Override
        public final Builder authorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        @Override
        public final Builder authorizationType(AuthorizationType authorizationType) {
            this.authorizationType(authorizationType == null ? null : authorizationType.toString());
            return this;
        }

        public final String getAuthorizerId() {
            return authorizerId;
        }

        public final void setAuthorizerId(String authorizerId) {
            this.authorizerId = authorizerId;
        }

        @Override
        public final Builder authorizerId(String authorizerId) {
            this.authorizerId = authorizerId;
            return this;
        }

        public final String getModelSelectionExpression() {
            return modelSelectionExpression;
        }

        public final void setModelSelectionExpression(String modelSelectionExpression) {
            this.modelSelectionExpression = modelSelectionExpression;
        }

        @Override
        public final Builder modelSelectionExpression(String modelSelectionExpression) {
            this.modelSelectionExpression = modelSelectionExpression;
            return this;
        }

        public final String getOperationName() {
            return operationName;
        }

        public final void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        @Override
        public final Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public final Map<String, String> getRequestModels() {
            if (requestModels instanceof SdkAutoConstructMap) {
                return null;
            }
            return requestModels;
        }

        public final void setRequestModels(Map<String, String> requestModels) {
            this.requestModels = RouteModelsCopier.copy(requestModels);
        }

        @Override
        public final Builder requestModels(Map<String, String> requestModels) {
            this.requestModels = RouteModelsCopier.copy(requestModels);
            return this;
        }

        public final Map<String, ParameterConstraints.Builder> getRequestParameters() {
            Map<String, ParameterConstraints.Builder> result = RouteParametersCopier.copyToBuilder(this.requestParameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setRequestParameters(Map<String, ParameterConstraints.BuilderImpl> requestParameters) {
            this.requestParameters = RouteParametersCopier.copyFromBuilder(requestParameters);
        }

        @Override
        public final Builder requestParameters(Map<String, ParameterConstraints> requestParameters) {
            this.requestParameters = RouteParametersCopier.copy(requestParameters);
            return this;
        }

        public final String getRouteId() {
            return routeId;
        }

        public final void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        @Override
        public final Builder routeId(String routeId) {
            this.routeId = routeId;
            return this;
        }

        public final String getRouteKey() {
            return routeKey;
        }

        public final void setRouteKey(String routeKey) {
            this.routeKey = routeKey;
        }

        @Override
        public final Builder routeKey(String routeKey) {
            this.routeKey = routeKey;
            return this;
        }

        public final String getRouteResponseSelectionExpression() {
            return routeResponseSelectionExpression;
        }

        public final void setRouteResponseSelectionExpression(String routeResponseSelectionExpression) {
            this.routeResponseSelectionExpression = routeResponseSelectionExpression;
        }

        @Override
        public final Builder routeResponseSelectionExpression(String routeResponseSelectionExpression) {
            this.routeResponseSelectionExpression = routeResponseSelectionExpression;
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        @Override
        public GetRouteResponse build() {
            return new GetRouteResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
