/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Response;
import software.amazon.awssdk.services.apigatewayv2.model.DeploymentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDeploymentResponse
extends ApiGatewayV2Response
implements ToCopyableBuilder<Builder, UpdateDeploymentResponse> {
    private static final SdkField<Boolean> AUTO_DEPLOYED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoDeployed").getter(UpdateDeploymentResponse.getter(UpdateDeploymentResponse::autoDeployed)).setter(UpdateDeploymentResponse.setter(Builder::autoDeployed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoDeployed").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedDate").getter(UpdateDeploymentResponse.getter(UpdateDeploymentResponse::createdDate)).setter(UpdateDeploymentResponse.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentId").getter(UpdateDeploymentResponse.getter(UpdateDeploymentResponse::deploymentId)).setter(UpdateDeploymentResponse.setter(Builder::deploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()}).build();
    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentStatus").getter(UpdateDeploymentResponse.getter(UpdateDeploymentResponse::deploymentStatusAsString)).setter(UpdateDeploymentResponse.setter(Builder::deploymentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStatus").build()}).build();
    private static final SdkField<String> DEPLOYMENT_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentStatusMessage").getter(UpdateDeploymentResponse.getter(UpdateDeploymentResponse::deploymentStatusMessage)).setter(UpdateDeploymentResponse.setter(Builder::deploymentStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStatusMessage").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateDeploymentResponse.getter(UpdateDeploymentResponse::description)).setter(UpdateDeploymentResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_DEPLOYED_FIELD, CREATED_DATE_FIELD, DEPLOYMENT_ID_FIELD, DEPLOYMENT_STATUS_FIELD, DEPLOYMENT_STATUS_MESSAGE_FIELD, DESCRIPTION_FIELD));
    private final Boolean autoDeployed;
    private final Instant createdDate;
    private final String deploymentId;
    private final String deploymentStatus;
    private final String deploymentStatusMessage;
    private final String description;

    private UpdateDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.autoDeployed = builder.autoDeployed;
        this.createdDate = builder.createdDate;
        this.deploymentId = builder.deploymentId;
        this.deploymentStatus = builder.deploymentStatus;
        this.deploymentStatusMessage = builder.deploymentStatusMessage;
        this.description = builder.description;
    }

    public final Boolean autoDeployed() {
        return this.autoDeployed;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final String deploymentId() {
        return this.deploymentId;
    }

    public final DeploymentStatus deploymentStatus() {
        return DeploymentStatus.fromValue(this.deploymentStatus);
    }

    public final String deploymentStatusAsString() {
        return this.deploymentStatus;
    }

    public final String deploymentStatusMessage() {
        return this.deploymentStatusMessage;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoDeployed());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeploymentResponse)) {
            return false;
        }
        UpdateDeploymentResponse other = (UpdateDeploymentResponse)((Object)obj);
        return Objects.equals(this.autoDeployed(), other.autoDeployed()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.deploymentStatusAsString(), other.deploymentStatusAsString()) && Objects.equals(this.deploymentStatusMessage(), other.deploymentStatusMessage()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDeploymentResponse").add("AutoDeployed", (Object)this.autoDeployed()).add("CreatedDate", (Object)this.createdDate()).add("DeploymentId", (Object)this.deploymentId()).add("DeploymentStatus", (Object)this.deploymentStatusAsString()).add("DeploymentStatusMessage", (Object)this.deploymentStatusMessage()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoDeployed": {
                return Optional.ofNullable(clazz.cast(this.autoDeployed()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "DeploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "DeploymentStatus": {
                return Optional.ofNullable(clazz.cast(this.deploymentStatusAsString()));
            }
            case "DeploymentStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.deploymentStatusMessage()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDeploymentResponse, T> g) {
        return obj -> g.apply((UpdateDeploymentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Response.BuilderImpl
    implements Builder {
        private Boolean autoDeployed;
        private Instant createdDate;
        private String deploymentId;
        private String deploymentStatus;
        private String deploymentStatusMessage;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDeploymentResponse model) {
            super(model);
            this.autoDeployed(model.autoDeployed);
            this.createdDate(model.createdDate);
            this.deploymentId(model.deploymentId);
            this.deploymentStatus(model.deploymentStatus);
            this.deploymentStatusMessage(model.deploymentStatusMessage);
            this.description(model.description);
        }

        public final Boolean getAutoDeployed() {
            return this.autoDeployed;
        }

        public final void setAutoDeployed(Boolean autoDeployed) {
            this.autoDeployed = autoDeployed;
        }

        @Override
        @Transient
        public final Builder autoDeployed(Boolean autoDeployed) {
            this.autoDeployed = autoDeployed;
            return this;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        @Transient
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        @Transient
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final String getDeploymentStatus() {
            return this.deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        @Transient
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder deploymentStatus(DeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus == null ? null : deploymentStatus.toString());
            return this;
        }

        public final String getDeploymentStatusMessage() {
            return this.deploymentStatusMessage;
        }

        public final void setDeploymentStatusMessage(String deploymentStatusMessage) {
            this.deploymentStatusMessage = deploymentStatusMessage;
        }

        @Override
        @Transient
        public final Builder deploymentStatusMessage(String deploymentStatusMessage) {
            this.deploymentStatusMessage = deploymentStatusMessage;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public UpdateDeploymentResponse build() {
            return new UpdateDeploymentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDeploymentResponse> {
        public Builder autoDeployed(Boolean var1);

        public Builder createdDate(Instant var1);

        public Builder deploymentId(String var1);

        public Builder deploymentStatus(String var1);

        public Builder deploymentStatus(DeploymentStatus var1);

        public Builder deploymentStatusMessage(String var1);

        public Builder description(String var1);
    }
}

