/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRouteRequestParameterRequest extends ApiGatewayV2Request implements
        ToCopyableBuilder<DeleteRouteRequestParameterRequest.Builder, DeleteRouteRequestParameterRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteRouteRequestParameterRequest::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()).build();

    private static final SdkField<String> REQUEST_PARAMETER_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteRouteRequestParameterRequest::requestParameterKey)).setter(setter(Builder::requestParameterKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("requestParameterKey").build()).build();

    private static final SdkField<String> ROUTE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteRouteRequestParameterRequest::routeId)).setter(setter(Builder::routeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("routeId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD,
            REQUEST_PARAMETER_KEY_FIELD, ROUTE_ID_FIELD));

    private final String apiId;

    private final String requestParameterKey;

    private final String routeId;

    private DeleteRouteRequestParameterRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.requestParameterKey = builder.requestParameterKey;
        this.routeId = builder.routeId;
    }

    /**
     * <p>
     * The API identifier.
     * </p>
     * 
     * @return The API identifier.
     */
    public String apiId() {
        return apiId;
    }

    /**
     * <p>
     * The route request parameter key.
     * </p>
     * 
     * @return The route request parameter key.
     */
    public String requestParameterKey() {
        return requestParameterKey;
    }

    /**
     * <p>
     * The route ID.
     * </p>
     * 
     * @return The route ID.
     */
    public String routeId() {
        return routeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(requestParameterKey());
        hashCode = 31 * hashCode + Objects.hashCode(routeId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRouteRequestParameterRequest)) {
            return false;
        }
        DeleteRouteRequestParameterRequest other = (DeleteRouteRequestParameterRequest) obj;
        return Objects.equals(apiId(), other.apiId()) && Objects.equals(requestParameterKey(), other.requestParameterKey())
                && Objects.equals(routeId(), other.routeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteRouteRequestParameterRequest").add("ApiId", apiId())
                .add("RequestParameterKey", requestParameterKey()).add("RouteId", routeId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "RequestParameterKey":
            return Optional.ofNullable(clazz.cast(requestParameterKey()));
        case "RouteId":
            return Optional.ofNullable(clazz.cast(routeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRouteRequestParameterRequest, T> g) {
        return obj -> g.apply((DeleteRouteRequestParameterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteRouteRequestParameterRequest> {
        /**
         * <p>
         * The API identifier.
         * </p>
         * 
         * @param apiId
         *        The API identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * The route request parameter key.
         * </p>
         * 
         * @param requestParameterKey
         *        The route request parameter key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestParameterKey(String requestParameterKey);

        /**
         * <p>
         * The route ID.
         * </p>
         * 
         * @param routeId
         *        The route ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeId(String routeId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayV2Request.BuilderImpl implements Builder {
        private String apiId;

        private String requestParameterKey;

        private String routeId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRouteRequestParameterRequest model) {
            super(model);
            apiId(model.apiId);
            requestParameterKey(model.requestParameterKey);
            routeId(model.routeId);
        }

        public final String getApiId() {
            return apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getRequestParameterKey() {
            return requestParameterKey;
        }

        @Override
        public final Builder requestParameterKey(String requestParameterKey) {
            this.requestParameterKey = requestParameterKey;
            return this;
        }

        public final void setRequestParameterKey(String requestParameterKey) {
            this.requestParameterKey = requestParameterKey;
        }

        public final String getRouteId() {
            return routeId;
        }

        @Override
        public final Builder routeId(String routeId) {
            this.routeId = routeId;
            return this;
        }

        public final void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRouteRequestParameterRequest build() {
            return new DeleteRouteRequestParameterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
