/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * <p>
 * The authorization type. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM
 * permissions, and CUSTOM for using a Lambda authorizer. For HTTP APIs, valid values are NONE for open access, or JWT
 * for using JSON Web Tokens.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public enum AuthorizationType {
    NONE("NONE"),

    AWS_IAM("AWS_IAM"),

    CUSTOM("CUSTOM"),

    JWT("JWT"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AuthorizationType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return AuthorizationType corresponding to the value
     */
    public static AuthorizationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AuthorizationType.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link AuthorizationType}s
     */
    public static Set<AuthorizationType> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
