/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.apigatewayv2.model.AuthorizationScopesCopier;
import software.amazon.awssdk.services.apigatewayv2.model.AuthorizationType;
import software.amazon.awssdk.services.apigatewayv2.model.ParameterConstraints;
import software.amazon.awssdk.services.apigatewayv2.model.RouteModelsCopier;
import software.amazon.awssdk.services.apigatewayv2.model.RouteParametersCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Route
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Route> {
    private static final SdkField<Boolean> API_GATEWAY_MANAGED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Route.getter(Route::apiGatewayManaged)).setter(Route.setter(Builder::apiGatewayManaged)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiGatewayManaged").build()}).build();
    private static final SdkField<Boolean> API_KEY_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Route.getter(Route::apiKeyRequired)).setter(Route.setter(Builder::apiKeyRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeyRequired").build()}).build();
    private static final SdkField<List<String>> AUTHORIZATION_SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Route.getter(Route::authorizationScopes)).setter(Route.setter(Builder::authorizationScopes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationScopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AUTHORIZATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Route.getter(Route::authorizationTypeAsString)).setter(Route.setter(Builder::authorizationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationType").build()}).build();
    private static final SdkField<String> AUTHORIZER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Route.getter(Route::authorizerId)).setter(Route.setter(Builder::authorizerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerId").build()}).build();
    private static final SdkField<String> MODEL_SELECTION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Route.getter(Route::modelSelectionExpression)).setter(Route.setter(Builder::modelSelectionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelSelectionExpression").build()}).build();
    private static final SdkField<String> OPERATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Route.getter(Route::operationName)).setter(Route.setter(Builder::operationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationName").build()}).build();
    private static final SdkField<Map<String, String>> REQUEST_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Route.getter(Route::requestModels)).setter(Route.setter(Builder::requestModels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestModels").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, ParameterConstraints>> REQUEST_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Route.getter(Route::requestParameters)).setter(Route.setter(Builder::requestParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterConstraints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ROUTE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Route.getter(Route::routeId)).setter(Route.setter(Builder::routeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeId").build()}).build();
    private static final SdkField<String> ROUTE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Route.getter(Route::routeKey)).setter(Route.setter(Builder::routeKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeKey").build()}).build();
    private static final SdkField<String> ROUTE_RESPONSE_SELECTION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Route.getter(Route::routeResponseSelectionExpression)).setter(Route.setter(Builder::routeResponseSelectionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeResponseSelectionExpression").build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Route.getter(Route::target)).setter(Route.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_GATEWAY_MANAGED_FIELD, API_KEY_REQUIRED_FIELD, AUTHORIZATION_SCOPES_FIELD, AUTHORIZATION_TYPE_FIELD, AUTHORIZER_ID_FIELD, MODEL_SELECTION_EXPRESSION_FIELD, OPERATION_NAME_FIELD, REQUEST_MODELS_FIELD, REQUEST_PARAMETERS_FIELD, ROUTE_ID_FIELD, ROUTE_KEY_FIELD, ROUTE_RESPONSE_SELECTION_EXPRESSION_FIELD, TARGET_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean apiGatewayManaged;
    private final Boolean apiKeyRequired;
    private final List<String> authorizationScopes;
    private final String authorizationType;
    private final String authorizerId;
    private final String modelSelectionExpression;
    private final String operationName;
    private final Map<String, String> requestModels;
    private final Map<String, ParameterConstraints> requestParameters;
    private final String routeId;
    private final String routeKey;
    private final String routeResponseSelectionExpression;
    private final String target;

    private Route(BuilderImpl builder) {
        this.apiGatewayManaged = builder.apiGatewayManaged;
        this.apiKeyRequired = builder.apiKeyRequired;
        this.authorizationScopes = builder.authorizationScopes;
        this.authorizationType = builder.authorizationType;
        this.authorizerId = builder.authorizerId;
        this.modelSelectionExpression = builder.modelSelectionExpression;
        this.operationName = builder.operationName;
        this.requestModels = builder.requestModels;
        this.requestParameters = builder.requestParameters;
        this.routeId = builder.routeId;
        this.routeKey = builder.routeKey;
        this.routeResponseSelectionExpression = builder.routeResponseSelectionExpression;
        this.target = builder.target;
    }

    public Boolean apiGatewayManaged() {
        return this.apiGatewayManaged;
    }

    public Boolean apiKeyRequired() {
        return this.apiKeyRequired;
    }

    public List<String> authorizationScopes() {
        return this.authorizationScopes;
    }

    public AuthorizationType authorizationType() {
        return AuthorizationType.fromValue(this.authorizationType);
    }

    public String authorizationTypeAsString() {
        return this.authorizationType;
    }

    public String authorizerId() {
        return this.authorizerId;
    }

    public String modelSelectionExpression() {
        return this.modelSelectionExpression;
    }

    public String operationName() {
        return this.operationName;
    }

    public Map<String, String> requestModels() {
        return this.requestModels;
    }

    public Map<String, ParameterConstraints> requestParameters() {
        return this.requestParameters;
    }

    public String routeId() {
        return this.routeId;
    }

    public String routeKey() {
        return this.routeKey;
    }

    public String routeResponseSelectionExpression() {
        return this.routeResponseSelectionExpression;
    }

    public String target() {
        return this.target;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiGatewayManaged());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKeyRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationScopes());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestModels());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeResponseSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Route)) {
            return false;
        }
        Route other = (Route)obj;
        return Objects.equals(this.apiGatewayManaged(), other.apiGatewayManaged()) && Objects.equals(this.apiKeyRequired(), other.apiKeyRequired()) && Objects.equals(this.authorizationScopes(), other.authorizationScopes()) && Objects.equals(this.authorizationTypeAsString(), other.authorizationTypeAsString()) && Objects.equals(this.authorizerId(), other.authorizerId()) && Objects.equals(this.modelSelectionExpression(), other.modelSelectionExpression()) && Objects.equals(this.operationName(), other.operationName()) && Objects.equals(this.requestModels(), other.requestModels()) && Objects.equals(this.requestParameters(), other.requestParameters()) && Objects.equals(this.routeId(), other.routeId()) && Objects.equals(this.routeKey(), other.routeKey()) && Objects.equals(this.routeResponseSelectionExpression(), other.routeResponseSelectionExpression()) && Objects.equals(this.target(), other.target());
    }

    public String toString() {
        return ToString.builder((String)"Route").add("ApiGatewayManaged", (Object)this.apiGatewayManaged()).add("ApiKeyRequired", (Object)this.apiKeyRequired()).add("AuthorizationScopes", this.authorizationScopes()).add("AuthorizationType", (Object)this.authorizationTypeAsString()).add("AuthorizerId", (Object)this.authorizerId()).add("ModelSelectionExpression", (Object)this.modelSelectionExpression()).add("OperationName", (Object)this.operationName()).add("RequestModels", this.requestModels()).add("RequestParameters", this.requestParameters()).add("RouteId", (Object)this.routeId()).add("RouteKey", (Object)this.routeKey()).add("RouteResponseSelectionExpression", (Object)this.routeResponseSelectionExpression()).add("Target", (Object)this.target()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiGatewayManaged": {
                return Optional.ofNullable(clazz.cast(this.apiGatewayManaged()));
            }
            case "ApiKeyRequired": {
                return Optional.ofNullable(clazz.cast(this.apiKeyRequired()));
            }
            case "AuthorizationScopes": {
                return Optional.ofNullable(clazz.cast(this.authorizationScopes()));
            }
            case "AuthorizationType": {
                return Optional.ofNullable(clazz.cast(this.authorizationTypeAsString()));
            }
            case "AuthorizerId": {
                return Optional.ofNullable(clazz.cast(this.authorizerId()));
            }
            case "ModelSelectionExpression": {
                return Optional.ofNullable(clazz.cast(this.modelSelectionExpression()));
            }
            case "OperationName": {
                return Optional.ofNullable(clazz.cast(this.operationName()));
            }
            case "RequestModels": {
                return Optional.ofNullable(clazz.cast(this.requestModels()));
            }
            case "RequestParameters": {
                return Optional.ofNullable(clazz.cast(this.requestParameters()));
            }
            case "RouteId": {
                return Optional.ofNullable(clazz.cast(this.routeId()));
            }
            case "RouteKey": {
                return Optional.ofNullable(clazz.cast(this.routeKey()));
            }
            case "RouteResponseSelectionExpression": {
                return Optional.ofNullable(clazz.cast(this.routeResponseSelectionExpression()));
            }
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Route, T> g) {
        return obj -> g.apply((Route)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean apiGatewayManaged;
        private Boolean apiKeyRequired;
        private List<String> authorizationScopes = DefaultSdkAutoConstructList.getInstance();
        private String authorizationType;
        private String authorizerId;
        private String modelSelectionExpression;
        private String operationName;
        private Map<String, String> requestModels = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, ParameterConstraints> requestParameters = DefaultSdkAutoConstructMap.getInstance();
        private String routeId;
        private String routeKey;
        private String routeResponseSelectionExpression;
        private String target;

        private BuilderImpl() {
        }

        private BuilderImpl(Route model) {
            this.apiGatewayManaged(model.apiGatewayManaged);
            this.apiKeyRequired(model.apiKeyRequired);
            this.authorizationScopes(model.authorizationScopes);
            this.authorizationType(model.authorizationType);
            this.authorizerId(model.authorizerId);
            this.modelSelectionExpression(model.modelSelectionExpression);
            this.operationName(model.operationName);
            this.requestModels(model.requestModels);
            this.requestParameters(model.requestParameters);
            this.routeId(model.routeId);
            this.routeKey(model.routeKey);
            this.routeResponseSelectionExpression(model.routeResponseSelectionExpression);
            this.target(model.target);
        }

        public final Boolean getApiGatewayManaged() {
            return this.apiGatewayManaged;
        }

        @Override
        public final Builder apiGatewayManaged(Boolean apiGatewayManaged) {
            this.apiGatewayManaged = apiGatewayManaged;
            return this;
        }

        public final void setApiGatewayManaged(Boolean apiGatewayManaged) {
            this.apiGatewayManaged = apiGatewayManaged;
        }

        public final Boolean getApiKeyRequired() {
            return this.apiKeyRequired;
        }

        @Override
        public final Builder apiKeyRequired(Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
            return this;
        }

        public final void setApiKeyRequired(Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
        }

        public final Collection<String> getAuthorizationScopes() {
            return this.authorizationScopes;
        }

        @Override
        public final Builder authorizationScopes(Collection<String> authorizationScopes) {
            this.authorizationScopes = AuthorizationScopesCopier.copy(authorizationScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizationScopes(String ... authorizationScopes) {
            this.authorizationScopes(Arrays.asList(authorizationScopes));
            return this;
        }

        public final void setAuthorizationScopes(Collection<String> authorizationScopes) {
            this.authorizationScopes = AuthorizationScopesCopier.copy(authorizationScopes);
        }

        public final String getAuthorizationTypeAsString() {
            return this.authorizationType;
        }

        @Override
        public final Builder authorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        @Override
        public final Builder authorizationType(AuthorizationType authorizationType) {
            this.authorizationType(authorizationType == null ? null : authorizationType.toString());
            return this;
        }

        public final void setAuthorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
        }

        public final String getAuthorizerId() {
            return this.authorizerId;
        }

        @Override
        public final Builder authorizerId(String authorizerId) {
            this.authorizerId = authorizerId;
            return this;
        }

        public final void setAuthorizerId(String authorizerId) {
            this.authorizerId = authorizerId;
        }

        public final String getModelSelectionExpression() {
            return this.modelSelectionExpression;
        }

        @Override
        public final Builder modelSelectionExpression(String modelSelectionExpression) {
            this.modelSelectionExpression = modelSelectionExpression;
            return this;
        }

        public final void setModelSelectionExpression(String modelSelectionExpression) {
            this.modelSelectionExpression = modelSelectionExpression;
        }

        public final String getOperationName() {
            return this.operationName;
        }

        @Override
        public final Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public final void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        public final Map<String, String> getRequestModels() {
            return this.requestModels;
        }

        @Override
        public final Builder requestModels(Map<String, String> requestModels) {
            this.requestModels = RouteModelsCopier.copy(requestModels);
            return this;
        }

        public final void setRequestModels(Map<String, String> requestModels) {
            this.requestModels = RouteModelsCopier.copy(requestModels);
        }

        public final Map<String, ParameterConstraints.Builder> getRequestParameters() {
            return this.requestParameters != null ? CollectionUtils.mapValues(this.requestParameters, ParameterConstraints::toBuilder) : null;
        }

        @Override
        public final Builder requestParameters(Map<String, ParameterConstraints> requestParameters) {
            this.requestParameters = RouteParametersCopier.copy(requestParameters);
            return this;
        }

        public final void setRequestParameters(Map<String, ParameterConstraints.BuilderImpl> requestParameters) {
            this.requestParameters = RouteParametersCopier.copyFromBuilder(requestParameters);
        }

        public final String getRouteId() {
            return this.routeId;
        }

        @Override
        public final Builder routeId(String routeId) {
            this.routeId = routeId;
            return this;
        }

        public final void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        public final String getRouteKey() {
            return this.routeKey;
        }

        @Override
        public final Builder routeKey(String routeKey) {
            this.routeKey = routeKey;
            return this;
        }

        public final void setRouteKey(String routeKey) {
            this.routeKey = routeKey;
        }

        public final String getRouteResponseSelectionExpression() {
            return this.routeResponseSelectionExpression;
        }

        @Override
        public final Builder routeResponseSelectionExpression(String routeResponseSelectionExpression) {
            this.routeResponseSelectionExpression = routeResponseSelectionExpression;
            return this;
        }

        public final void setRouteResponseSelectionExpression(String routeResponseSelectionExpression) {
            this.routeResponseSelectionExpression = routeResponseSelectionExpression;
        }

        public final String getTarget() {
            return this.target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public Route build() {
            return new Route(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Route> {
        public Builder apiGatewayManaged(Boolean var1);

        public Builder apiKeyRequired(Boolean var1);

        public Builder authorizationScopes(Collection<String> var1);

        public Builder authorizationScopes(String ... var1);

        public Builder authorizationType(String var1);

        public Builder authorizationType(AuthorizationType var1);

        public Builder authorizerId(String var1);

        public Builder modelSelectionExpression(String var1);

        public Builder operationName(String var1);

        public Builder requestModels(Map<String, String> var1);

        public Builder requestParameters(Map<String, ParameterConstraints> var1);

        public Builder routeId(String var1);

        public Builder routeKey(String var1);

        public Builder routeResponseSelectionExpression(String var1);

        public Builder target(String var1);
    }
}

