/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigateway.ApiGatewayAsyncClient;
import software.amazon.awssdk.services.apigateway.internal.UserAgentUtils;
import software.amazon.awssdk.services.apigateway.model.ApiKey;
import software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest;
import software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse;

public class GetApiKeysPublisher
implements SdkPublisher<GetApiKeysResponse> {
    private final ApiGatewayAsyncClient client;
    private final GetApiKeysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetApiKeysPublisher(ApiGatewayAsyncClient client, GetApiKeysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetApiKeysPublisher(ApiGatewayAsyncClient client, GetApiKeysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetApiKeysResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetApiKeysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ApiKey> items() {
        return this.flatMapIterable(response -> response.items());
    }

    private class GetApiKeysResponseFetcher
    implements AsyncPageFetcher<GetApiKeysResponse> {
        private GetApiKeysResponseFetcher() {
        }

        public boolean hasNextPage(GetApiKeysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.position());
        }

        public CompletableFuture<GetApiKeysResponse> nextPage(GetApiKeysResponse previousPage) {
            if (previousPage == null) {
                return GetApiKeysPublisher.this.client.getApiKeys(GetApiKeysPublisher.this.firstRequest);
            }
            return GetApiKeysPublisher.this.client.getApiKeys((GetApiKeysRequest)((Object)GetApiKeysPublisher.this.firstRequest.toBuilder().position(previousPage.position()).build()));
        }
    }
}

